#include <allegro.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "main.h"
#include "log.h"
#include "game.h"
#include "menu.h"
#include "run.h"
#include "pal.h"
#include "tile.h"
#include "map.h"
#include "ob.h"
#include "anim.h"
#include "edit.h"
#include "load.h"

static int particlenum;
static int sliding;
static int slidedir;
static int gameover;
static int fromx,fromy,from;
static int bombsleft;
static int levelnum;
static int score;
static int completed;
static int bombticking;
static int bombx,bomby;
static int stop;
static int badx,bady;

typedef struct EXPLOSION {
	int x,y,t,st;
} EXPLOSION;
static int explosions;
static EXPLOSION *explosion;

int gamekeys[GAMEKEYS];

void gamekeycheck(int scan) {
	int n;
	for(n=0;n<GAMEKEYS;n++) {
		if((scan&127)==setupdata.gamekeynums[n]) {
			if(scan&128) {
				if(gamekeys[n]==1) gamekeys[n]=3;
				else gamekeys[n]=0;
			} else {
				gamekeys[n]=1;
			}
		}
	}
}
END_OF_FUNCTION(gamekeycheck);

void updategamekeys() {
	int n;
	for(n=0;n<GAMEKEYS;n++) {
		if(gamekeys[n]==1) gamekeys[n]=2;
		else gamekeys[n]=0;
	}
}

void spawnparticle(int x,int y,int st) {
	if(particlenum<PARTICLENUM) {
		int r=rand();
		if(st==0) {r=0;st=1;}
		particle[particlenum]->x=x;
		particle[particlenum]->y=y;
		particle[particlenum]->z=10;
		particle[particlenum]->dx=((rand()%3)-1)*st;
		particle[particlenum]->dy=((rand()%3)-1)*st;
		particle[particlenum]->dz=((rand()%5)+5)*st;
		particle[particlenum]->t=0;
		{  r%=8;
			if(r<=5) particle[particlenum]->an=particleanim;
			if(r==6) particle[particlenum]->an=dustanim[0];
			if(r==7) particle[particlenum]->an=dustanim[1];
		}
		particlenum++;
	}
}
void processparticles(void) {
	int n;
	for(n=0;n<particlenum;n++) {
		particle[n]->x+=particle[n]->dx;
		particle[n]->y+=particle[n]->dy;
		particle[n]->z+=particle[n]->dz;
		particle[n]->t++;
		particle[n]->dz--;
		if(particle[n]->t>FPS*2||particle[n]->z<0) {
			*particle[n]=*particle[particlenum-1];
			particlenum--;
			n--;
		}
	}
}
void drawparticles(void) {
	int n;
	for(n=0;n<particlenum;n++) {
		ob_draw(particle[n],page,-mapx,-mapy);
	}
}
void addexplosion(int x,int y) {
	int n;
	char t;
	int st=0;
	int met=0;

	t=map_gettile(x,y);

	if(t==TILE_BOMB1) st=1;
	if(t==TILE_BOMB2) st=2;
	if(t==TILE_BOMB3) st=3;
	if(t==TILE_BOMB1G) st=1;
	if(t==TILE_BOMB2G) st=2;
	if(t==TILE_BOMB3G) st=3;
	if(t==TILE_BOMB1M) {st=1;met=1;}
	if(t==TILE_BOMB2M) {st=2;met=1;}
	if(t==TILE_BOMB3M) {st=3;met=1;}

	if(st==0) return;

	score+=st*2;

	for(n=0;n<8*st;n++) {
		spawnparticle(x<<4,y<<4,st);
	}
	bombsleft--;

	if(met) map_puttile(x,y,TILE_METAL);
	else map_puttile(x,y,TILE_NO);

	play_sample(expl_wav,
		255-60+st*20,
		128+(rand()%61)-30,
		1000-(rand()%101)-50,0);
	if(explosions==0) {
		explosion=malloc(sizeof *explosion);
	} else {
		explosion=realloc(explosion,(explosions+1)*sizeof *explosion);
	}
	explosion[explosions].x=x;
	explosion[explosions].y=y;
	explosion[explosions].t=0;
	explosion[explosions].st=st;
	explosions++;
}

void processexplosions() {
	int n;
	for(n=0;n<explosions;n++) {
		spawnparticle(explosion[n].x<<4,explosion[n].y<<4,1);
		explosion[n].t++;
		if(explosion[n].t>FPS/3) {
			int tx,ty;
			int d;
			int i;
			tx=explosion[n].x;
			ty=explosion[n].y;
			for(d=1;d<=explosion[n].st;d++) {
				for(i=0;i<d*4;i++) {
					int x,y;
					if(i<d*2) y=-d+i; else y=d-(i-d*2);
					if(i<d) x=i; else
					if(i<d*3) x=d-(i-d); else
						x=-d+(i-d*3);
					addexplosion(tx+x,ty+y);
					if(tx+x==badx&&ty+y==bady) gameover=1;
					spawnparticle(explosion[n].x<<4,explosion[n].y<<4,1);
					if(d<explosion[n].st) {
						char t=map_gettile(tx+x,ty+y);
						if(t==TILE_STONE||
							t==TILE_GRASS||
							t==TILE_ICE) {
							map_puttile(tx+x,ty+y,TILE_NO);
						}
					}
				}
			}
			explosion[n]=explosion[explosions-1];
			explosions--;
			if(explosions==0) {free(explosion);explosion=NULL;}
			else explosion=realloc(explosion,explosions*sizeof*explosion);
			n--;
		}
	}
}

int level(int l) {
	BITMAP *next;
	char str[256];
	if(l<0) l=-l;
	sprintf(str,"maps\\lev%d.bmp",l);
	next=load_bitmap(str,NULL);
	if(next) {
		int x,y;
		destroy_bitmap(map);
		map=next;
		if(map_scan(&x,&y,&bombsleft)) {
			donkey->x=x<<4;
			donkey->y=y<<4;
			donkey->z=0;
		}
		particlenum=0;
		sliding=0;
		from=0;
		gameover=0;
		completed=0;
		bombticking=0;
		stop=0;
		return 1;
	}
	return 0;
}

void game_init(int lev) {
	static int lockonce=0;
	logmsg("Entering Game Mode.\n");
	mode=MODE_GAME;

	if(!lockonce) {
		LOCK_VARIABLE(setupdata);
		LOCK_VARIABLE(gamekeys);
		LOCK_FUNCTION(gamekeycheck);
		lockonce=1;
	}

	{  int n;
		for(n=0;n<GAMEKEYS;n++) gamekeys[n]=0;
	}

	keyboard_lowlevel_callback=gamekeycheck;

	loadgfx();

	donkey->dir=donkey->want=96;

	explosions=0;
	explosion=NULL;

	score=0;
	map_init();
	levelnum=lev;
	if(!level(levelnum)) {
		game_end();
		menu_init();
	}
}

void game_process() {
	int k;
	while(keypressed()) {
		k=readkey();
		k>>=8;
		if(k==KEY_ESC) {
			game_end();
			if(levelnum<0) {
				edit_init(-levelnum);
				return;
			} else {
				menu_init();
			}
			return;
		}
	}

	processparticles();

	stop=0;

	if(explosions) {
		processexplosions();
		stop=1;
	}

	if(gameover) {
		if(gamekeys[GAMEKEY_USE]&1) {
			if(!explosions) level(levelnum);
		}
		donkey->z++;
		stop=1;
	}

	if(completed) {
		stop=1;
	}

	if(bombsleft==0) {
		if(gamekeys[GAMEKEY_USE]&1) {
			if(levelnum<0) {
				game_end();
				edit_init(-levelnum);
				return;
			}
			if(!explosions) {
				levelnum++;
				setupdata.lastcompleted=levelnum;
				level(levelnum);
			}
		}
		stop=1;
	}

	if(bombticking) {
		if((ticks%(FPS/4))==0) {
			spawnparticle(bombx<<4,bomby<<4,0);
		}
	}

	if(donkey->dir==donkey->want) {
		int dx,dy;
		dx=0;
		dy=0;

		if(donkey->dir==32) {
			dy=-1;
		}
		if(donkey->dir==96) {
			dx=1;
		}
		if(donkey->dir==160) {
			dy=1;
		}
		if(donkey->dir==224) {
			dx=-1;
		}

		if(donkey->anim==0) {

			if(from) {
				from=0;
				map_puttile(fromx,fromy,TILE_NO);
				spawnparticle(fromx<<4,fromy<<4,1);
				play_sample(expl_wav,
					100,
					128,
					1500+(rand()%1000),0);
				score++;
			}
			if(sliding) {
				int tx,ty;
				char t;
				tx=(donkey->x>>4);
				ty=(donkey->y>>4);
				t=map_gettile(tx,ty);
				if(t==TILE_NO) {
					gameover=-1;
					goto dont;
				}
				sliding=0;
				goto walk;
			}
			if(!stop) {
				if(gamekeys[GAMEKEY_USE]&1) {
					int tx,ty;
					char t;
					tx=(donkey->x>>4);
					ty=(donkey->y>>4);

					if(bombticking) {
						bombticking=0;
						badx=tx;
						bady=ty;
						addexplosion(bombx,bomby);
					} else {
						bombx=tx+dx;
						bomby=ty+dy;
						t=map_gettile(bombx,bomby);
						if(t==TILE_BOMB1||
							t==TILE_BOMB2||
							t==TILE_BOMB3||
							t==TILE_BOMB1G||
							t==TILE_BOMB2G||
							t==TILE_BOMB3G||
							t==TILE_BOMB1M||
							t==TILE_BOMB2M||
							t==TILE_BOMB3M) {
							bombticking=1;
						}
					}
				}

				if(gamekeys[GAMEKEY_UP]) {donkey->want=32; goto walk;}
				if(gamekeys[GAMEKEY_RIGHT]) {donkey->want=96; goto walk;}
				if(gamekeys[GAMEKEY_DOWN]) {donkey->want=160; goto walk;}
				if(gamekeys[GAMEKEY_LEFT]) {donkey->want=224; goto walk;}
			}
		}
		if(donkey->anim) {
			char t;
walk:

			if(donkey->dir!=donkey->want) goto turn;

			if(donkey->anim==0) {
				int tx,ty;
				char ot;
				tx=(donkey->x>>4);
				ty=(donkey->y>>4);
				ot=map_gettile(tx,ty);
				t=map_gettile(tx+dx,ty+dy);

				if(t!=TILE_STONE&&
					t!=TILE_ICE&&
					t!=TILE_GRASS&&
					t!=TILE_METAL) {
					if(ot==TILE_ICE) {
						sliding=1;
						slidedir=0;
						if(t!=TILE_NO) {
							donkey->want+=128;
							if(donkey->want>=256) donkey->want-=256;
							goto dont;
						}
					} else goto dont;
				}

				badx=tx+dx;
				bady=ty+dy;

				if(t==TILE_ICE) {
					sliding=1;
				}
				if(ot==TILE_STONE) {
					from=1;
					fromx=tx;
					fromy=ty;
				}
				if(ot==TILE_NO) gameover=-1;
				if(bombticking) {
					bombticking=0;
					badx=tx+dx;
					bady=ty+dy;
					addexplosion(bombx,bomby);
				}

			}

			donkey->x+=dx;
			donkey->y+=dy;
			donkey->anim+=16;
			donkey->anim&=255;
			if(sliding) {
				slidedir+=16;
			}
		}

	} else {
		int d;
turn:
		d=donkey->want-donkey->dir;
		if(d<-128) d+=256;
		if(d>=128) d-=256;
		if(sliding) {
			if(d<0) donkey->dir-=16;
			if(d>0) donkey->dir+=16;
			if(donkey->dir<0) donkey->dir+=256;
			if(donkey->dir>=256) donkey->dir-=256;
		} else {
			if(d<0) donkey->dir-=2;
			if(d>0) donkey->dir+=2;
			if(donkey->dir<0) donkey->dir+=256;
			if(donkey->dir>=256) donkey->dir-=256;
			donkey->anim+=8;
			donkey->anim&=255;
		}
	}
dont:

	{  int ox,oy;
		ox=ob_x(donkey);
		oy=ob_y(donkey);
		if(ox-mapx-70<50) mapx=ox-70-50;
		if(oy-mapy-70<50) mapy=oy-70-50;
		if(ox-mapx+70>=SCREEN_W-50) mapx=ox+70-SCREEN_W+50;
		if(oy-mapy+70>=SCREEN_W/2-50) mapy=oy+70-SCREEN_W/2+50;
	}

	updategamekeys();
}

void game_grafix() {
	set_clip(page,0,0,SCREEN_W-1,SCREEN_W/2-1);
	rectfill(page,0,0,SCREEN_W-1,SCREEN_W/2-1,RGB555(0,0,0));
	map_draw(0,0,SCREEN_W-1,SCREEN_W/2-1);

	{  int dir=donkey->dir;
		if(sliding) {
			donkey->dir+=slidedir;
			donkey->dir&=255;
		}
		ob_draw(donkey,page,-mapx-70,-mapy-70);
		donkey->dir=dir;
	}

	drawparticles();

	set_clip(page,0,0,SCREEN_W-1,SCREEN_H-1);

	//rectfill(page,0,SCREEN_W/2,SCREEN_W-1,SCREEN_H-1,RGB555(2,1,0));
	blit(gamebar,page,0,0,0,SCREEN_W/2,SCREEN_W,SCREEN_H-SCREEN_W/2);

	text_mode(-1);
	textprintf_right(page,font,SCREEN_W-1,SCREEN_H-text_height(font),RGB555(2,2,2),
	"fps=%d",fps);

	textprintf_centre(page,truefont,SCREEN_W/2,SCREEN_W/2+5,-1,
	"Bombs left: %d",bombsleft);
	textprintf_centre(page,truefont,SCREEN_W/2,SCREEN_W/2+5+text_height(truefont),-1,
	"Score: %d",score);

	if(gameover)
		textprintf_centre(page,highfont,SCREEN_W/2,SCREEN_W/4,-1,
		"G A M E O V E R");
	else if(completed) {
		textprintf_centre(page,highfont,SCREEN_W/2,SCREEN_W/4,-1,
			"Congratulations !");
		textprintf_centre(page,highfont,
			SCREEN_W/2,SCREEN_W/4+text_height(highfont),-1,
			"You won the game !");
	} else if(bombsleft==0) {
		textprintf_centre(page,truefont,SCREEN_W/2,SCREEN_W/4,-1,
		"Level completed !");
		if(levelnum>0)
		textprintf_centre(page,truefont,SCREEN_W/2,SCREEN_W/4+40,-1,
		"Next Level: %d",levelnum+1);
	}
}

void game_end() {
	logmsg("Leaving Game Mode.\n");
	keyboard_lowlevel_callback=NULL;
	if(explosion) free(explosion);
	logmsg("Destroying graphics.\n");

	if(levelnum>0)
	{  int n;
		for(n=0;n<10;n++) {
			if(setupdata.highscorevals[n]<score) {
				setupdata.highscorevals[n]=score;
				sprintf(setupdata.highscores[n],"%d. %s %d",n+1,setupdata.name,score);
				break;
			}
		}
		menu_savesetup();
	}

	map_del();
}
