#ifndef _ANIM_H_
#define _ANIM_H_

#include <allegro.h>

#include "ball.h"

#define OBANIM 3
#define OBDIR 16
#define OBDIRMUL (256/OBDIR)

typedef struct ANIM {
	BALL **b;
	BITMAP *bmp[OBDIR*OBANIM];
} ANIM;

extern ANIM *anim_new(char *str);
extern void anim_del(ANIM *this);

extern void anim_parse(ANIM *this,char *str);
extern void anim_trace(ANIM *this,BITMAP *bmp);

extern void anim_rotate(ANIM *this,BALL *sb,BALL *eb,float x,float y,float z);
extern void anim_move(ANIM *this,BALL *sb,BALL *eb,float x,float y,float z);

#endif
