#include <allegro.h>
#include <math.h>

#include "anim.h"
#include "ball.h"
#include "pal.h"

#include "log.h"
#include "progress.h"

ANIM *anim_new(char *str) {
	ANIM *this;
	this=malloc(sizeof *this);
	{  int n;
		for(n=0;n<OBDIR*OBANIM;n++) this->bmp[n]=NULL;
	}
	this->b=NULL;

	anim_parse(this,str);

	return this;
}

void anim_del(ANIM *this) {
	int n;
	for(n=0;n<OBDIR*OBANIM;n++) {
		if(this->bmp[n]) destroy_bitmap(this->bmp[n]);
	}
	for(n=0;this->b&&this->b[n];n++) {
		ball_del(this->b[n]);
	}
	free(this);
}

void anim_addball(ANIM *this,BALL *b) {
	int n;
	for(n=0;this->b&&this->b[n];n++);
	this->b=realloc(this->b,(2+n)*sizeof(BALL *));
	this->b[n+1]=NULL;
	this->b[n]=b;
}

void anim_rotate(ANIM *this,BALL *sb,BALL *eb,float x,float y,float z) {
	int n;
	int s;
	if(sb==NULL) s=1; else s=0;
	for(n=0;this->b&&this->b[n];n++) {
		if(s) {
			ball_rotate(this->b[n],x,y,z);
		}
		if(this->b[n]==sb) s=1;
		if(this->b[n]==eb) break;
	}
}

void anim_move(ANIM *this,BALL *sb,BALL *eb,float x,float y,float z) {
	int n;
	int s;
	if(sb==NULL) s=1; else s=0;
	for(n=0;this->b&&this->b[n];n++) {
		if(s) {
			ball_move(this->b[n],x,y,z);
		}
		if(this->b[n]==sb) s=1;
		if(this->b[n]==eb) break;
	}
}

void anim_trace(ANIM *this,BITMAP *bmp) {
	int n;
	int pixelx,pixelz;
	float *zbuffer;
	float lx,ly,lz; // light vector

	logmsg("Starting trace (%d x %d).\n",bmp->w,bmp->h);

	zbuffer=malloc(bmp->w*bmp->h*sizeof(float));

	lx=-1;
	ly=3;
	lz=-5;
	// normalize light
	{  float l=sqrt(lx*lx+ly*ly+lz*lz);
		lx/=l;
		ly/=l;
		lz/=l;
	}

	for(n=0;n<bmp->w*bmp->h;n++) zbuffer[n]=0.0;

	anim_move(this,NULL,NULL,0,128,0);

	for(pixelz=0;pixelz<bmp->h;pixelz++) {
		for(pixelx=0;pixelx<bmp->w;pixelx++) {

			for(n=0;this->b&&this->b[n];n++) {
				float r=this->b[n]->r;
				int s;
				float bx,by,bz;
				float sx,sy,sz;

				sx=pixelx-bmp->w/2;
				sz=bmp->h/2-pixelz;

				bx=this->b[n]->x;
				bz=this->b[n]->z;
				by=this->b[n]->y;

				if(r*r-(sx-bx)*(sx-bx)-(sz-bz)*(sz-bz)>0) {
					float x,y,z;
					float buf;
					int bufpos;

					// - sign because we always want the near surface
					sy=-sqrt(r*r-(sx-bx)*(sx-bx)-(sz-bz)*(sz-bz))+by;
					x=bx-sx;
					z=bz-sz;
					y=by-sy;

					bufpos=pixelx+bmp->w*pixelz;

					{  float nx,ny,nz; // normal vector
						float dot;
						nx=x/r;
						ny=y/r;
						nz=z/r;

						dot=nx*lx+ny*ly+nz*lz;
						s=(1+dot)*15.0/2;
						if(s<0) s=0;
						if(s>15) s=15;
					}

					buf=zbuffer[bufpos];
					if(sy*buf<128.0) {
						zbuffer[bufpos]=128.0/sy;
						putpixel(bmp,pixelx,pixelz,s=COL555(this->b[n]->c,s));
					}
				}
			}
		}
	}

	free(zbuffer);

	anim_move(this,NULL,NULL,0,-128,0);

	progress++;
	progress_bar();
	logmsg("Done tracing.\n");
}

void anim_parse(ANIM *this,char *str) {
	char s;
	int n;
	int x=0,y=0,z=0,d=0,r=10,c=0;
	BALL *b=NULL;

	int parts=0;
	BALL *part[64];
	BALL *part_[64];
	int frames[64];
	int framemode[64];
	int rec=0;
	int par[64];
	int anum=0;
	int steps=1;
	int w=32,h=32;
	float rotx[64],roty[64],rotz[64];
	float tx[64],ty[64],tz[64];
	float tilt=0;


	logmsg("Start parsing.\n");

	for(n=0;n<64;n++) {
		rotx[n]=roty[n]=rotz[n]=0.0;
		tx[n]=ty[n]=tz[n]=0.0;
		frames[n]=1;
		framemode[n]=0;
	}

	d=0;
	for(n=0;(s=str[n]);n++) {
		if(s>='0'&&s<='9') {
			d=d*10+s-'0';
		}
		if(s=='w') {w=d;d=0;}
		if(s=='h') {h=d;d=0;}
		if(s=='x') {x=d;d=0;}
		if(s=='y') {y=d;d=0;}
		if(s=='z') {z=d;d=0;}
		if(s=='r') {r=d;d=0;}
		if(s=='c') {c=d;d=0;}
		if(s=='-') {d=-d;}
		if(s=='T') {tilt=d;d=0;}

		if(s=='b') {
			b=ball_new(x,y,z,r,c);
			anim_addball(this,b);
		}
		if(s=='{') {
			part[parts]=b;
			par[rec]=parts;
			rec++;
			parts++;
		}
		if(s=='}') {
			rec--;
			part_[par[rec]]=b;
		}

		if(s==':') {anum=d;d=0;}
		if(s=='/') {frames[anum]=d;framemode[anum]=0;d=0;}
		if(s=='%') {frames[anum]=d;framemode[anum]=1;d=0;}
		if(s=='X') {rotx[anum]=d;d=0;}
		if(s=='Y') {roty[anum]=d;d=0;}
		if(s=='Z') {rotz[anum]=d;d=0;}
		if(s=='O') {
			tx[anum]=-part_[anum]->x;
			ty[anum]=-part_[anum]->y;
			tz[anum]=-part_[anum]->z;
		}

		if(s=='[') {steps=d;d=0;}
	}

	logmsg("Done parsing. Found %d frames to render.\n",steps);
	logmsg("Animating %d objects.\n",parts);

	{  int a;
		for(a=0;a<steps;a++) {
			int i;

			anim_rotate(this,NULL,NULL,tilt,0,0);

			this->bmp[a]=create_bitmap(w,h);
			clear_to_color(this->bmp[a],0);
			anim_trace(this,this->bmp[a]);

			anim_rotate(this,NULL,NULL,-tilt,0,0);

			for(i=0;i<parts;i++) {

				anim_move(this,part[i],part_[i],tx[i],ty[i],tz[i]);

				if(framemode[i]==0) {
					if((a+1)%frames[i]==0)
						anim_rotate(this,part[i],part_[i],
						rotx[i],roty[i],rotz[i]);
				} else {
					anim_rotate(this,part[i],part_[i],
						rotx[i],roty[i],rotz[i]);
				}

				anim_move(this,part[i],part_[i],-tx[i],-ty[i],-tz[i]);
			}
		}
	}
	logmsg("Animation done.\n");
}
