/*
   * Based * on dc6con by Ryan Smith,
   for the understanding of the dc6 format,
   but none of his code is in there
   (just the structs)

   As for me, you can do whatever you want with this code

   Compiled fine with djgpp 2.95.2 and allegro 3.9.34 (wip)

   Paul Siramy, 15 March 2002
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mem.h>
#include <dir.h>

#include <allegro.h>

#define FAMILY  6
#define TINT   21

typedef struct
{
   long version;
   long unknown1;
   long unknown2;
   int  termination[4];
   long unknown3;
   long blockcount;
} DC6HEADER;

typedef struct
{
	long unknown1;
	long width;
	long height;
	long offset_x;
	long offset_y;
	long unknown2;
	long next_block;
	long length;
} DC6BLOCKHEADER;

PALETTE        dc6pal;
DC6HEADER      dc6header;
DC6BLOCKHEADER * dc6blockheader = NULL;
long           * block_ptr      = NULL;
BITMAP         * dc6bmp         = NULL,
               * finalbmp       = NULL;
int            colormap[FAMILY][TINT][256];

char cmap_name[FAMILY][80] = {
        {"grey.dat"},         // 1
        {"grey2.dat"},        // 2
        {"greybrown.dat"},    // 5
        {"invgrey.dat"},      // 6
        {"invgrey2.dat"},     // 7
        {"invgreybrown.dat"}  // 8
/*
        {"brown.dat"},
        {"gold.dat"},
*/
     };
int cmap_idx[FAMILY] = {1, 2, 5, 6, 7, 8};



// ==========================================================================
int read_dc6_header(FILE * in)
{
   long * lptr;
   int  i, nb;
   
   fread(&dc6header.version,        4, 1, in);
   fread(&dc6header.unknown1,       4, 1, in);
   fread(&dc6header.unknown2,       4, 1, in);
   fread(&dc6header.termination[0], 1, 1, in);
   fread(&dc6header.termination[1], 1, 1, in);
   fread(&dc6header.termination[2], 1, 1, in);
   fread(&dc6header.termination[3], 1, 1, in);
   fread(&dc6header.unknown3,       4, 1, in);
   fread(&dc6header.blockcount,     4, 1, in);
   
   nb = dc6header.blockcount;
   
   block_ptr = (long *) malloc(sizeof(long) * nb);
   if (block_ptr == NULL)
   {
      printf("not enough memory for %li block pointers\n", nb);
      return 1;
   }
   
   dc6blockheader = (DC6BLOCKHEADER *) malloc(sizeof(DC6BLOCKHEADER) * nb);
   if (dc6blockheader == NULL)
   {
      printf("not enough memory for %li block headers\n", nb);
      free(block_ptr);
      return 1;
   }

   lptr = block_ptr;
   for (i=0; i<nb; i++)
   {
      fread(lptr, 4, 1, in);
      lptr++;
   }
   return 0;
}



// ==========================================================================
void read_dc6_blockheader(FILE * in, int frame)
{
   DC6BLOCKHEADER * bh = dc6blockheader + frame;
   long tmp_off;
   int  x, c;
   long old_seek;
   
   fseek(in, * (block_ptr + frame), SEEK_SET);
   
   fread(&bh->unknown1,   4, 1, in);
   fread(&bh->width,      4, 1, in);
   fread(&bh->height,     4, 1, in);
   fread(&bh->offset_x,   4, 1, in);
   fread(&bh->offset_y,   4, 1, in);
   fread(&bh->unknown2,   4, 1, in);
   fread(&bh->next_block, 4, 1, in);
   fread(&bh->length,     4, 1, in);
}



// ==========================================================================
void decompress_dc6(FILE * in, int frame)
{
   DC6BLOCKHEADER * bh;
   long           i, i2;
   int            c, c2, x, y, color;
   
   bh = dc6blockheader + frame;
   dc6bmp = create_bitmap(bh->width, bh->height);
   clear(dc6bmp);
   fseek(in, (* (block_ptr + frame)) + 32, SEEK_SET);
   x = 0;
   y = bh->height - 1;

   for (i=0; i<bh->length; i++)
   {
      c = fgetc(in);

      if (c == 0x80)
      {
         x = 0;
         y--;
      }
      else if (c & 0x80)
         x += c & 0x7F;
      else
      {
         for (i2=0; i2<c; i2++)
         {
            c2 = fgetc(in);
            i++;
            putpixel(dc6bmp, x, y, c2);
            x++;
         }
      }
   }
}



// ==========================================================================
void load_palette(void)
{
   FILE * in;
   int  i, c0, c1, c2;
   char d2pal[] = "act1.dat";
   
   in = fopen(d2pal, "rb");
   if (in == NULL)
   {
      printf("\ncan't open palette : %s\n", d2pal);
      exit(1);
   }
   printf("load palette %s\n", d2pal);
   for (i=0; i<256; i++)
   {
      // order is BGR, not RGB
      dc6pal[i].b = fgetc(in) >> 2;
      dc6pal[i].g = fgetc(in) >> 2;
      dc6pal[i].r = fgetc(in) >> 2;
      /*
         >> 2 is needed because the internal range of the RGB componants
         in allegro (8 bpp mode) is from 0 to 63 (because of the mode 13h),
         not 0 to 255. Since this program only output bitmaps for the purpose
         of tests, and don't create dc6 files, it's ok.
      */
   }
   fclose(in);
}



// ==========================================================================
void make_finalbmp(char * filename)
{
   char tmp_str[80];
   int  w, h, ww, hh, x, y, f, t, c;

   w  = dc6bmp->w;
   h  = dc6bmp->h;
   ww = w * (TINT + 1) + 180;
   hh = h * FAMILY + 30;
   finalbmp = create_bitmap(ww, hh);
   clear(finalbmp);
   for (f=0; f<FAMILY; f++)
   {
      for (t=0; t<TINT + 1; t++)
      {
         if (t==0)
         {
            if (f==0)
               blit(dc6bmp, finalbmp, 0, 0, 0, 16, w, h);
         }
         else
         {
            for (y=0; y<h; y++)
            {
               for (x=0; x<w; x++)
               {
                  c = getpixel(dc6bmp, x, y);
                  if (c)
                     putpixel(finalbmp, w*t+x, h*f+y+16, colormap[f][t-1][c]);
               }
            }
         }
      }
      sprintf(tmp_str, "%i : %s", cmap_idx[f], cmap_name[f]);
      textout(finalbmp, font, tmp_str, w*t+8, h*f+h/2+12, 255);
   }
   for (t=1; t<TINT + 1; t++)
   {
      sprintf(tmp_str, "%02i", t-1);
      textout(finalbmp, font, tmp_str, w*t+(w/2)-8, h*f+20, 255);
   }
   textout(finalbmp, font, filename, 4, 4, 255);
}



// ==========================================================================
int main(void)
{
   struct ffblk ff;
   FILE   * in;

   char cmap_dir[] = "colormaps", tmp[80], tmp2[80];
   int  f, t, i, done;


   load_palette();
   printf("loading colormap :\n", tmp);
   for (f=0; f<FAMILY; f++)
   {
      sprintf(tmp, "%s\\%s", cmap_dir, cmap_name[f]);
      in = fopen(tmp, "rb");
      if (in == NULL)
      {
         printf("can't open %s\n", tmp);
         exit(1);
      }
      printf("   %s\n", tmp);
      for (t=0; t<TINT; t++)
      {
         for (i=0; i<256; i++)
            colormap[f][t][i] = fgetc(in);
      }
      fclose(in);
   }

   allegro_init();
   set_color_depth(8);
   
   strcpy(tmp, "dc6\\*.dc6");
   done = findfirst(tmp, &ff, FA_RDONLY | FA_HIDDEN | FA_SYSTEM | FA_ARCH);
   printf("processing :\n");
   while ( ! done)
   {
      sprintf(tmp2, "dc6\\%s", ff.ff_name);
      in = fopen(tmp2, "rb");
      if (in == NULL)
      {
         printf("can't open %s\n", tmp2);
         exit(1);
      }
      printf("   %s\n", tmp2);
      if (read_dc6_header(in))
      {
         fclose(in);
         exit(1);
      }
      read_dc6_blockheader(in, 0);
      decompress_dc6(in, 0);
      fclose(in);

//      make_finalbmp(tmp2);
      make_finalbmp(ff.ff_name);

      strcpy(tmp2, ff.ff_name);
      tmp2[strlen(tmp2)-4] = 0;
      strcat(tmp2, ".pcx"); // bmp / pcx / tga
      save_bitmap(tmp2, finalbmp, & dc6pal);

      free(dc6blockheader);
      free(block_ptr);
      destroy_bitmap(dc6bmp);
      destroy_bitmap(finalbmp);

      done = findnext(&ff);
   }
   printf("all done\n");
   return 0;
}

