/*
    Copyright (C) 2001 Hotwarez LLC, Goldtree Enterprises
  
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; 
    version 2 of the License.
  
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.
  
    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "timer.h"
#include "keys.h"
#include "input.h"
#include <time.h>

#include <allegro.h>

/*
#include <dpmi.h>
#include <go32.h>
*/
#include <string.h> /* For memset */

/* GLOBALS */


long TIMER_CLICKS_PER_SECOND = 220;
long GAME_CLICKS_PER_SECOND  = 15;



//_go32_dpmi_seginfo Old_Timer_Isr, New_Timer_Isr, Old_Real_Timer_Isr, New_Real_Timer_Isr;   
//_go32_dpmi_registers regs;      

long timer = 0;
unsigned long absolute_time = 0; /* Absolute number of clicks since the beginning of the game */


long click_threshold = 15; /* 15 is arbitrary */

/* */


void Timer( void ) {
    timer++; 
    absolute_time++;

/*
    // increment global time variable, note: we can do this since on entry
    //   DS points to global data segment 

    timer++; 
    absolute_time++;
    
    outportb( 0x20, 0x20 );
*/
} /* end Timer */




void Init_Timer( void ) {
	install_int(Timer, 3);

	/*
     disable(); 


     // Hook our function to the protected mode timer interrupt 
     _go32_dpmi_get_protected_mode_interrupt_vector( TIME_KEEPER_INT, &Old_Timer_Isr );
     New_Timer_Isr.pm_offset = (int)Timer;
     _go32_dpmi_allocate_iret_wrapper( &New_Timer_Isr );
     New_Timer_Isr.pm_selector = _go32_my_cs();
     _go32_dpmi_set_protected_mode_interrupt_vector( TIME_KEEPER_INT, &New_Timer_Isr );

     memset( &regs, 0, sizeof( regs ) );
     _go32_dpmi_get_real_mode_interrupt_vector( TIME_KEEPER_INT, &Old_Real_Timer_Isr );
     New_Real_Timer_Isr.pm_offset = (int)Timer;
     _go32_dpmi_allocate_real_mode_callback_iret( &New_Real_Timer_Isr, &regs ); 
     _go32_dpmi_set_real_mode_interrupt_vector( TIME_KEEPER_INT, &New_Real_Timer_Isr );
     
     enable(); 

     click_threshold = ( (float)TIMER_CLICKS_PER_SECOND / (float)GAME_CLICKS_PER_SECOND);
*/
}

void Kill_Timer( void ) {
	/*
     _go32_dpmi_set_real_mode_interrupt_vector( TIME_KEEPER_INT, &Old_Real_Timer_Isr );
     _go32_dpmi_set_protected_mode_interrupt_vector( TIME_KEEPER_INT, &Old_Timer_Isr );  
	 */
}

long Check_Timer( void )
    {
//	return(10000); //Johnm 12/2/2001

     return timer;
    }

void Set_Timer( long number )
    {
     timer = number;
    }

    
void Set_Timer_Speed( unsigned short new_count ) {
/*
    // send the control word, mode 2, binary, least/most 
    outportb(CONTROL_8253, CONTROL_WORD);

    // now write the least significant byte to the counter register 
    outportb(COUNTER_0,LOW_BYTE(new_count)); 

    // and now the hi byte 
    outportb(COUNTER_0,HI_BYTE(new_count));       

*/
} /* end Set_Timer_Speed */


int Test_Timer( void )
    {
     time_t time_one, time_two;
     time_t temp_time;
     int clicks_per_second = 0;


     time_one = time( &temp_time );
     Set_Timer(0);
     time_two = time( &temp_time );

     while( difftime( time_one, time_two ) < 1.0 )
         {
          time_two = time( &temp_time );
         }

     clicks_per_second = Check_Timer();

     fprintf(stderr, "%d clicks went by in one second \n", clicks_per_second);
     Get_Keypress();

     return clicks_per_second;

    } /* end of Test_Time() */
