#include "MainDlg.h"


int main(int argc, char *argv[]) {
	set_uformat(U_ASCII);
	allegro_init();
	install_keyboard(); 
	install_mouse();
	install_timer();

	if (argc > 1)
		set_config_file(argv[1]);
	else
		set_config_file("centi.ini");

	char skinPath[255];
	ustrncpy(skinPath, get_config_string("MAIN", "skin", "skins/QNXAmiga.ini"), 255);
	int gfxMode = GFX_AUTODETECT_FULLSCREEN;
	int gfx = get_config_int("MAIN", "fullscreen", 1);
	if (gfx == 0) gfxMode = GFX_AUTODETECT_WINDOWED;
	int refresh = get_config_int("MAIN", "refresh", 60);
	set_config_string("MAIN", "skin", skinPath);
	set_config_int("MAIN", "fullscreen", gfx);
	set_config_int("MAIN", "refresh", refresh);

	int sound = get_config_int("MUSIC", "disable", 0) ? 0 : 1;
	set_config_int("MUSIC", "disable", sound == 1 ? 0 : 1);
	if (sound) {
		install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
		int sound_volume = get_config_int("MUSIC", "sound_volume", 255);
		int midi_volume = get_config_int("MUSIC", "midi_volume", 255);
		set_volume(sound_volume, midi_volume);
		set_config_int("MUSIC", "sound_volume", sound_volume);
		set_config_int("MUSIC", "midi_volume", midi_volume);
	}

	flush_config_file();

	request_refresh_rate(refresh);
	int err = MASInstall(skinPath, 16, 640, 480, gfxMode, false);
	if (err == MASkin::ERR_SKIN_GFX_MODE)
		err = MASInstall(skinPath, 15, 640, 480, gfxMode, false);
	if (err == MASkin::ERR_SKIN_GFX_MODE)
		err = MASInstall(skinPath, 32, 640, 480, gfxMode, false);
	if (err == MASkin::ERR_SKIN_GFX_MODE)
		err = MASInstall(skinPath, 24, 640, 480, gfxMode, false);
	if (err == MASkin::ERR_SKIN_GFX_MODE)
		err = MASInstall(skinPath, 8, 640, 480, gfxMode, false);
	if (err == MASkin::ERR_SKIN_GFX_MODE || err == MASkin::ERR_SKIN_NO_MEM)
		MASError(err);
	set_mouse_speed(1, 1);

	SMainDlg *game = argc > 1 ? new SMainDlg(argv[1]) : new SMainDlg;
	game->Execute();
	delete game;

	MASExit();
	allegro_exit();
	return 0;
}
END_OF_MAIN();
