#ifndef		MAINDIALOG
#define		MAINDIALOG

#include <MASkinG.h>
#include "HighScore.h"
#include "PlayArea.h"


class SMainDlg : public MASDialog {
	private:
		HighScore hsc;

		// Dialog objects
		MASClearScreen clear;
		MASPanelRaised box;
		MASWinButton buttonPlay;
		MASWinButton buttonStop;
		MASWinButton buttonExit;
		MASSlider speedSlider;
		MASEditText speedText;
		MASText speedLabel;
		MASSlider growthSlider;
		MASEditText growthText;
		MASText growthLabel;
		MASText scoreLabel;
		MASEditText scoreText;
		MASText livesLabel;
		MASEditText livesText;
		MASText levelLabel;
		MASEditText levelText;
		MASText piecesLabel;
		MASEditText piecesText;
		MASWinButton editButton;
		MASWinButton loadButton;
		MASWinButton saveButton;
		MASEditText fileText;
		MASWinButton scoresButton;
		MASKeyboard keyEsc;

		SPlayArea playArea;
		MASMidiPlayer mPlayer;

		void PlayCentipede(void);
		void StopCentipede(void);
		void CloseDialog(void);
		void DrawSpeedSlider(void);
		void DrawGrowthSlider(void);
		void OnEdit(void);
		void OnLoad(void);
		void OnSave(void);
		void OnScores(void);
		void HandleTimer();

		// helper functions
		void UpdateHSC(void);

	public:
		SMainDlg(const char *ini = "centi.ini");
		~SMainDlg();

		void HandleEvent(MASDialogObject& obj, int msg, int arg=0);
		virtual MASDialogObject *Execute();
};

#endif
