#include "MainDlg.h"
#include "SHighScoreDlg.h"
#include "SCentipedeMessage.h"



////////////////////////////////////////////////////////////////////////////////
// Constructor
SMainDlg::SMainDlg(const char *file) :MASDialog(30) {
	buttonPlay.SetText("&Play");	buttonPlay.SetKey(KEY_P);
	buttonStop.SetText("&Stop");	buttonStop.SetKey(KEY_S);
	buttonStop.Disable();
	buttonExit.SetText("E&xit");	buttonExit.SetKey(KEY_X);
	speedSlider.SetRange(3, 10);
	speedSlider.Position(5);
	speedSlider.SetOrientation(1);
	speedLabel.SetText("Choose your speed");
	speedText.SetText("3");
	speedText.Disable();
	growthSlider.SetRange(1, 8);
	growthSlider.Position(3);
	growthSlider.SetOrientation(1);
	growthLabel.SetText("Choose growth level");
	growthText.SetText("3");
	growthText.Disable();
	scoreLabel.SetText("score");
	livesLabel.SetText("lives");
	levelLabel.SetText("level");
	piecesLabel.SetText("pieces");
	scoreText.SetText("---");
	livesText.SetText("---");
	levelText.SetText("--/--");
	piecesText.SetText("--/--");
	scoreText.Disable();
	livesText.Disable();
	levelText.Disable();
	piecesText.Disable();
	editButton.SetText("&Edit ON");		editButton.SetKey(KEY_E);
	loadButton.SetText("Load");
	loadButton.Disable();
	saveButton.SetText("Save");
	saveButton.Disable();
	fileText.SetText("level.bin");
	fileText.Disable();
	scoresButton.SetText("&High scores");	scoresButton.SetKey(KEY_H);
	keyEsc.Setup(KEY_ESC);

	playArea.LoadSettings(file);
	set_config_file(file);
	mPlayer.LoadPlaylist(get_config_string("MUSIC", "playlist", ""));
	mPlayer.SetLoop(1);
	mPlayer.SetRandom(1);

	// Add the objects to the dialog
	//					x,		y,		w,		h
	Add(clear);
	Add(box,			8,	  	8,		624,	464);
	Add(playArea,		15,	 	15,	 	450,	450);
	Add(loadButton,	   	475,	150,	70,	  	24);
	Add(saveButton,		555,	150,	70,	  	24);
	Add(fileText,		475,	180,	150,	22);
	Add(editButton,	   	475,	210,	150,	24);
	Add(speedLabel,	   	480,	270,	120,	12);
	Add(speedSlider,	480,	296,	110,	22);
	Add(speedText,		600,	294,	22,	  	22);
	Add(growthLabel,	480,	324,	120,	12);
	Add(growthSlider,	480,	350,	110,	22);
	Add(growthText,	   	600,	348,	22,	  	22);
	Add(buttonPlay,	   	475,	380,	150,	24);
	Add(buttonStop,	   	475,	410,	150,	24);
	Add(buttonExit,	   	475,	440,	150,	24);
	Add(scoreLabel,	   	485,	24,	  	55,	  	18);
	Add(scoreText,		525,	20,	  	75,	  	18);
	Add(livesLabel,	   	485,	48,	  	55,	  	18);
	Add(livesText,		525,	44,	  	75,	  	18);
	Add(levelLabel,	   	485,	72,	  	55,	  	18);
	Add(levelText,		525,	68,	  	75,	  	18);
	Add(piecesLabel,	485,	96,	  	55,	  	18);
	Add(piecesText,	   	525,	92,	  	75,	  	18);
	Add(scoresButton,	475,	116,	150,	24);
	Add(keyEsc);
	Add(mPlayer);

	_escape_exits = false;
}

////////////////////////////////////////////////////////////////////////////////
// Destructor
SMainDlg::~SMainDlg() {
}


MASDialogObject *SMainDlg::Execute() {
	MASDialogObject *ret = MASDialog::Execute();
	return ret;
}


void SMainDlg::HandleEvent(MASDialogObject& obj, int msg, int arg) {
	switch (msg) {
	case MSG_TIMER:
		if (obj == playArea)		HandleTimer();		break;
	case MSG_ACTIVATE:
		if (obj == buttonPlay)		PlayCentipede();	else
		if (obj == buttonStop)		StopCentipede();	else
		if (obj == keyEsc)
			if (buttonStop.Disabled())
				CloseDialog();
			else
				StopCentipede();							else
		if (obj == buttonExit)		CloseDialog();		else
		if (obj == editButton)		OnEdit();			else
		if (obj == loadButton)		OnLoad();			else
		if (obj == saveButton)		OnSave();			else
		if (obj == scoresButton)	OnScores();			break;
	case MSG_SCROLL:
		if (obj == speedSlider)		DrawSpeedSlider();	else
		if (obj == growthSlider)	DrawGrowthSlider();	break;
	};
}


void SMainDlg::CloseDialog(void) {
	SCentipedeMessage msgDlg("Do you really want to exit?");
    msgDlg.SetParent(this);
	bool isPlaying = playArea.isPlaying;
	playArea.isPlaying = false;
	if (msgDlg.Popup()) {
		Close();
	}
	else {
		playArea.isPlaying = isPlaying;
	}
}


void SMainDlg::PlayCentipede(void) {
	buttonStop.Enable();
	buttonPlay.Disable();
	buttonExit.Disable();
	speedSlider.Disable();
	growthSlider.Disable();
	editButton.Disable();
	playArea.speed = speedSlider.Position() - 2;
	playArea.growthLevel = growthSlider.Position();
	MASHideMouse();

	playArea.isPlaying = true;
	playArea.timer = InstallTimer((12 - speedSlider.Position())*10);
	simulate_keypress(KEY_LEFT<<8);
	mPlayer.SetLoop(0);
	mPlayer.Next();
	mPlayer.Play();
}


void SMainDlg::StopCentipede(void) {
	bool saved = playArea.isPlaying;
	playArea.isPlaying = false;
	MASShowMouse();
	SCentipedeMessage msgDlg("Do you really want to stop?");
    msgDlg.SetParent(this);
	if (msgDlg.Popup()) {
		KillTimer(playArea.timer);
		mPlayer.SetLoop(1);
		mPlayer.Play(0);
		UpdateHSC();
		buttonStop.Disable();
		buttonPlay.Enable();
		buttonExit.Enable();
		speedSlider.Enable();
		growthSlider.Enable();
		editButton.Enable();
		playArea.Reset();
		playArea.isPlaying = false;
	}
	else {
		playArea.isPlaying = saved;
		MASHideMouse();
	}
}


void SMainDlg::HandleTimer() {
	char buf[8];
	if (playArea.isPlaying) {
		if (playArea.gameOver) {
			buttonStop.Disable();
			buttonPlay.Enable();
			buttonExit.Enable();
			KillTimer(playArea.timer);
			mPlayer.SetLoop(1);
			mPlayer.Play(0);
			MASShowMouse();
			UpdateHSC();
			speedSlider.Enable();
			growthSlider.Enable();
			editButton.Enable();
			playArea.Reset();
			playArea.isPlaying = false;
			return;
		}
		playArea.MoveSnake();
		usprintf(buf, "%d", playArea.score);
		scoreText.SetText(buf);
		usprintf(buf, "%d", playArea.lives);
		livesText.SetText(buf);
		usprintf(buf, "%d/%d", playArea.level+1, MAXLEVEL+1);
		levelText.SetText(buf);
		usprintf(buf, "%d/%d", playArea.pieces, playArea.maxPieces);
		piecesText.SetText(buf);
	}
}


void SMainDlg::DrawSpeedSlider(void) {
	char buf[4];
	usprintf(buf, "%d", speedSlider.Position() - 2);
	speedText.SetText(buf);
	speedText.RedrawNow();
}


void SMainDlg::DrawGrowthSlider(void) {
	char buf[4];
	usprintf(buf, "%d", growthSlider.Position());
	growthText.SetText(buf);
	growthText.RedrawNow();
}


void SMainDlg::OnEdit(void) {
	if (playArea.editMode) {
		editButton.SetText("&Edit ON");
		playArea.editMode = false;
		saveButton.Disable();
		loadButton.Disable();
		fileText.Disable();
		growthSlider.Enable();
		speedSlider.Enable();
		buttonPlay.Enable();
	}
	else {
		editButton.SetText("&Edit OFF");
		playArea.editMode = true;
		saveButton.Enable();
		loadButton.Enable();
		fileText.Enable();
		growthSlider.Disable();
		speedSlider.Disable();
		buttonPlay.Disable();
	}

	playArea.MsgDraw();
}


void SMainDlg::OnSave(void) {
	playArea.Save(fileText.GetText());
}


void SMainDlg::OnLoad(void) {
	playArea.Load(fileText.GetText());
}


void SMainDlg::OnScores(void) {
	bool saved = playArea.isPlaying;
	playArea.isPlaying = false;
	if (saved == true) MASShowMouse();
	HighScore h;
	h.Load("centi.hsc");
	SHighScoreDlg hDlg(&h);
    hDlg.SetParent(this);
	hDlg.Popup();
	if (saved == true) MASHideMouse();
	playArea.isPlaying = saved;
}


void SMainDlg::UpdateHSC(void) {
	hsc.Load("centi.hsc");
	int place = hsc.GetPlacement(playArea.score);
	if (place != -1) {
		// popup a dialog and save hiscores
		SHighScoreDlg hDlg(&(hsc), place, playArea.score);
        hDlg.SetParent(this);
		hDlg.Popup();
		char buf[21];
		usprintf(buf, "%s\0", hDlg.GetName());
		hsc.Add(buf, playArea.score);
		hsc.Save("centi.hsc");
	}
	else {
		SCentipedeMessage msgDlg("Sorry, no highscore!\0", 1);
        msgDlg.SetParent(this);
		msgDlg.Popup();
	}
}
