// SHighScoreDlg.cpp: implementation of the SHighScoreDlg class.
//
//////////////////////////////////////////////////////////////////////

#include "SHighScoreDlg.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

SHighScoreDlg::SHighScoreDlg(HighScore *h, int o, int nsc)
	: MASWindow("HighScores", 40)
{
	hsc = h;
	offset = o;
	newscore = nsc;

	if (offset < 10)
		line1.SetText("You have a high score! Enter your name:\0");
	else {
		line1.SetText("Highscores so far:\0");
		offset = 10;
	}

	positionLabel[0].SetText(" 1.\0");
	positionLabel[1].SetText(" 2.\0");
	positionLabel[2].SetText(" 3.\0");
	positionLabel[3].SetText(" 4.\0");
	positionLabel[4].SetText(" 5.\0");
	positionLabel[5].SetText(" 6.\0");
	positionLabel[6].SetText(" 7.\0");
	positionLabel[7].SetText(" 8.\0");
	positionLabel[8].SetText(" 9.\0");
	positionLabel[9].SetText("10.\0");

	int i;
	char buf[21];
	buf[20] = '\0';
	for (i=0; i<offset; i++) {
		ustrncpy(buf, hsc->name[hsc->order[i]], 20);
		buf[20] = '\0';
		nameText[i].SetText(buf, 20);
		sprintf(buf, "%d\0", hsc->score[hsc->order[i]]);
		scoreText[i].SetText(buf);
		nameText[i].Disable();
		scoreText[i].Disable();
	}

	if (offset < 10) {
		nameText[offset].SetText("\0", 20);
		sprintf(buf, "%d\0", nsc);
		scoreText[offset].SetText(buf);
		scoreText[offset].Disable();
	}

	for (i=offset; i<9; i++) {
		ustrncpy(buf, hsc->name[hsc->order[i]], 20);
		buf[20] = '\0';
		nameText[i+1].SetText(buf, 20);
		sprintf(buf, "%d\0", hsc->score[hsc->order[i]]);
		scoreText[i+1].SetText(buf);
		nameText[i+1].Disable();
		scoreText[i+1].Disable();
	}

	buttonOK.SetText("&OK");	buttonOK.SetKey(KEY_O);
	buttonOK.MakeExit();

	// Add the objects to the dialog
	//					  x,	  y,	   w,	   h
	//Add(line1);
	for (i=0; i<10; i++) {
		Add(positionLabel[i]);
		Add(nameText[i]);
		Add(scoreText[i]);
	}
	Add(buttonOK);

	MsgResize(260, 220);
	Centre();
}

SHighScoreDlg::~SHighScoreDlg() { }


void SHighScoreDlg::MsgResize(int nw, int nh) {
	MASWindow::MsgResize(nw, nh);

	ShapeObject(&line1, 10, 6, 180, 16);
	for (int i=0; i<10; i++) {
		ShapeObject(&positionLabel[i], 6, 8 + i*18,  20,  16);
		ShapeObject(&nameText[i],     28, 8 + i*18, 170,  16);
		ShapeObject(&scoreText[i],   200, 8 + i*18,  50,  16);
	}
	ShapeObject(&buttonOK, 90, 192,	80, 24);
}


char *SHighScoreDlg::GetName() {
	return nameText[offset].GetText();
}
