#ifndef		PLAYAREA
#define		PLAYAREA

#define		FLOOR		0
#define		WALL		1
#define		SNAKE		2
#define		FOOD		3
#define		BORDER		4

#define		MOVE_LEFT	137
#define		MOVE_RIGHT	371
#define		MOVE_UP		149
#define		MOVE_DOWN	263

#define		MAXLEVEL	35

#include <MASkinG.h>

class SPlayArea :public MASDialogObject {
	private:
		void GetDxDy(int *dx, int *dy);
		bool CanMove();
		bool CanMoveNext();
		void DropFood();
		bool HaveFood();
		void Crashed();
		void RestartLevel(int level);
		void LoadArena(int level);
		int StringToColor(char *str);
		void LoadSamples();

		inline void DrawTile(int ix, int iy, int col, int sh1, int sh2, int animation, int frames) {
			MAS3DFrame(Parent()->dscreen, ix, iy, ix+8, iy+8, col, sh1, sh2);
			Parent()->DRSAddRect(ix, iy, ix+9, iy+9, animation, frames);
		}

		int color[5][3];
		int maxWait[8];

		int matrix[50][50];
		int startx, starty;
		int foodx, foody;
		int length;
		int direction, lastdir;
		int snake[1000][2];

		int growth;
		int drop;
		bool there_is_food;
		int steps;
		bool handledLastKey;
		int wait;

		enum { SAMPLE_CRASH=MASkin::N_OF_SAMPLES, SAMPLE_EAT, SAMPLE_START, SAMPLE_LIFE, SAMPLE_WALL };

	public:
		bool isPlaying;
		bool gameOver;
		int score;
		int lives;
		int speed;
		int growthLevel;
		bool editMode;
		int level;
		int pieces;
		int maxPieces;
		int timer;

	public:
		// Constructors and destructors
		SPlayArea();
		virtual ~SPlayArea(void);

		// Message functions
		virtual void MsgDraw(void);
		virtual bool MsgWantfocus(void);
		virtual bool MsgChar(int c);
		virtual void MsgClick(void);
		virtual void MsgTimer(int t);

		void MoveSnake();
		void Reset();
		void Load(char *file);
		void Save(char *file);
		void LoadSettings(const char *ini = "centi.ini");
};


#endif
