// SCentipedeMessage.cpp: implementation of the SCentipedeMessage class.
//
//////////////////////////////////////////////////////////////////////

#include "SCentipedeMessage.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

SCentipedeMessage::SCentipedeMessage(char *text, int b)
	: MASWindow("Centipede", 6)
{
	buttons = b;
	line1.SetText(text);
	buttonCancel.SetText("&Cancel");	buttonCancel.SetKey(KEY_C);
	buttonOK.SetText("&OK");			buttonOK.SetKey(KEY_O);
	buttonCancel.MakeExit();
	buttonOK.MakeExit();

	// Add the objects to the dialog
	//					x,	  y,	   w,	   h
	Add(line1);
	if (b == 2) {
		Add(buttonCancel);
		Add(buttonOK);
	}
	else
		Add(buttonOK);

	int width = MASStrlen(text, theSkin->GetFont(0)) + 20;
	width = width < 180 ? 180 : width;

	MsgResize(width, 60);
	Centre();
}

		
SCentipedeMessage::~SCentipedeMessage() { }


void SCentipedeMessage::MsgResize(int nw, int nh) {
	MASWindow::MsgResize(nw, nh);

	int bw = buttons == 2 ? (nw - 24)/2 : nw - 90;
	ShapeObject(&line1, 8, 8, nw-8, 16);
	if (buttons == 2) {
		ShapeObject(&buttonOK,         6, 32, bw, 24);
		ShapeObject(&buttonCancel, 12+bw, 32, bw, 24);
	}
	else
		ShapeObject(&buttonOK, 45, 32, bw, 24);
}


int SCentipedeMessage::Popup() {
	MASDialogObject *ret = MASWindow::Popup(&buttonOK);
	if (ret == (MASDialogObject *)&buttonOK)
		return 1;
	else
		return 0;
}
