// HighScore.cpp: implementation of the HighScore class.
//
//////////////////////////////////////////////////////////////////////

#include "HighScore.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

HighScore::HighScore() {
	for (int i=0; i<10; i++) {
		ustrncpy(name[i], " --- nobody ---    ", 20);
		score[i] = 0;
		order[i] = i;
	}
}

HighScore::~HighScore() { }


bool HighScore::Add(char n[20], int s) {
	int place = GetPlacement(s);

	if (place == -1)
		return false;
	else {
		ustrncpy(name[order[9]], n, 20);
		score[order[9]] = s;
		int temp = order[9];
		for (int i=9; i>place; i--)
			order[i] = order[i-1];
		order[place] = temp;
		return true;
	}
}


int HighScore::GetPlacement(int s) {
	for (int i=0; i<10; i++) {
		if (score[order[i]] < s)
			return i;
	}

	return -1;
}


void HighScore::Save(char *file) {
	FILE *f = fopen(file, "wb");
	if (!f) return;

	int hi, lo;
	long sc;
	char ch;

	for (int i=0; i<10; i++) {
		for (int j=0; j<20; j++) {
			ch = name[order[i]][j];
			if (ch >= 128)
				ch = 0x20;
			ch += 80;
			fputc(ch, f);
		}
		sc = score[order[i]] + 12345;
		hi = sc / 65536;
		lo = sc % 65536;
		fputc(hi/256, f);
		fputc(hi%256, f);
		fputc(lo/256, f);
		fputc(lo%256, f);
	}

	fclose(f);
}


void HighScore::Load(char *file) {
	FILE *f = fopen(file, "rb");
	if (!f) return;

	long sc;

	for (int i=0; i<10; i++) {
		order[i] = i;
		for (int j=0; j<20; j++)
			name[order[i]][j] = fgetc(f) - 80;
		sc = fgetc(f) << 24;
		sc += fgetc(f) << 16;
		sc += fgetc(f) << 8;
		sc += fgetc(f);
		score[order[i]] = sc - 12345;
	}

	fclose(f);
}
