#include "main.h"
#include "fstream.h"

DBitmap MapBmp;
DButton Button[NUM_BUTT];
DATAFILE *data,*butt,*misc,*cards;

CDeck MainDeck;
GAME_STRUCT M;

int	color[6]={144,13,54,10,63,14};

char city_name[50][14]={"Aberystwyth","Ayr","Barnstaple","Barrow","Berwick","Birmingham",
                 "Brighton","Bristol","Cambridge","Cardigan","Cardiff","Carlisle",
                 "Colchester","Coventry","Dolgellau","Dover","Dumfries","Dundee",
                 "Edinburgh","Exeter","Glasgow","Gloucester","Hereford","Holyhead",
                 "Hull","Ipswich","Lancaster","Leeds","Lincoln","Liverpool",
                 "London","Manchester","Middlesbrough","Newcastle","Northampton",
                 "Norwich","Nottingham","Reading","Pembroke","Penzance","Perth",
                 "Plymouth","Portsmouth","Sheffield","Southampton","Stoke",
                 "Stranraer","Swansea","York",""};
// Names of cities

char comm_name[27][10]={"Barley","Beer","Cars","Cattle","Chemical","China","Clay",
                 "Coal","Con.Mat.","Cotton","Fish","Fruit","Hops","Imports",
                 "Jute","Lead","Machinery","Oats","Oil","Pigs","Rubber",
                 "Sheep","Steel","Sugar","Textiles","Tobacco","Tourists"};
// Names of commodities
typedef struct NAME
{
	char tx[10][20];
} NAME;

int get_names(NAME &name)
{
	char k[20],l=0;
	int i;

	for (i=0; i<10; i++)
	{
		sprintf(k,"game_0%d.sav",i);
		if (exists(k))
		{
			l=1;
			strcpy(name.tx[i],k);
		}
		else
		{
			strcpy(name.tx[i],"Empty");
		}
	}
	return l;
}


void load_game(GAME_STRUCT &gm)
{
	char t[960][750],k[20];
	int i,j,p=100,l,dn=0;
	NAME name;
	DRadioGroup r;
	DButton button[2];

	l=get_names(name);	

	if (l==0)
	{
		Info_Box(Screen,"Load Game","  Ok  ",
			"There are no saved games",
			"to load.",END);
	}
	else
	{
		button[0].Create(240,260,60,20,"Load");
		button[1].Create(340,260,60,20,"Cancel");

		r.Create(140,140,0,20,240,0,name.tx[0],name.tx[1],name.tx[2],
			name.tx[3],name.tx[4],name.tx[5],name.tx[6],name.tx[7],
			name.tx[8],name.tx[9],END);

		while (!dn)
		{
			Title_Window(Screen,80,80,560,300,"Choose Which Slot");
			button[0].Draw(Screen);
			button[1].Draw(Screen);
			r.Draw(Screen);
			Draw_Screen();

			if (Mouse.Click())
			{
				r.Check_Button();
				if (button[0].Pressed())
				{
					switch(r.Which_Select())
					{
						p=100;
					case 0:p=0;break;
					case 1:p=1;break;
					case 2:p=2;break;
					case 3:p=3;break;
					case 4:p=4;break;
					case 5:p=5;break;
					case 6:p=6;break;
					case 7:p=7;break;
					case 8:p=8;break;
					case 9:p=9;break;
					}
					if (p!=100)
					{
						if (strcmp(name.tx[p],"Empty")!=0)
							dn=1;
					}
				}
				if (button[1].Pressed())
				{
					dn=1;
				}
			}
		}

		if (p!=100)
		{
			sprintf(k,"game_0%d.sav",p);

			ifstream fin(k,ios::binary);

			if (!fin)
			{
			Info_Box(Screen,"Error...","Ok",
				"Error reading file or",
				"File does not exist!",END);
			}
			else
			{
				fin.read((char*) &gm,sizeof gm);
				fin.read((char*) &t,sizeof t);
				fin.close();
				for (i=0; i<960; i++)
				{
					for (j=0; j<750; j++)
					{
						putpixel(MapBmp.Bitmap,i,j,t[i][j]);
					}
				}
			}
		}
		button[0].Delete();
		button[1].Delete();
	}
}

void save_game(GAME_STRUCT &gm)
{
	char t[960][750],k[20];
	int i,j,p=100,dn=0;
	NAME name;
	DRadioGroup r;
	DButton button[2];

	get_names(name);	

	button[0].Create(240,260,60,20,"Save");
	button[1].Create(340,260,60,20,"Cancel");

	r.Create(120,140,0,20,240,0,name.tx[0],name.tx[1],name.tx[2],
		name.tx[3],name.tx[4],name.tx[5],name.tx[6],name.tx[7],
		name.tx[8],name.tx[9],END);

	while (!dn)
	{
		Title_Window(Screen,80,80,560,300,"Choose Which Slot");
		button[0].Draw(Screen);
		button[1].Draw(Screen);
		r.Draw(Screen);
		Draw_Screen();

		if (Mouse.Click())
		{
			r.Check_Button();
			if (button[0].Pressed())
			{
				switch(r.Which_Select())
				{
					p=100;
				case 0:p=0;break;
				case 1:p=1;break;
				case 2:p=2;break;
				case 3:p=3;break;
				case 4:p=4;break;
				case 5:p=5;break;
				case 6:p=6;break;
				case 7:p=7;break;
				case 8:p=8;break;
				case 9:p=9;break;
				}
				if (p!=100)
				{
					if (strcmp(name.tx[p],"Empty")!=0)
					{
						if (Message(Screen,"Saved Games","Proceed","Cancel",
							"This file exists.",
							"Would you like to",
							"Overwrite?",END)==0)
							dn=1;
					}
					else
					{
						dn=1;
					}
				}
			}
			if (button[1].Pressed())
			{
				dn=1;
			}
		}
	}

	if (p!=100)
	{
		sprintf(k,"game_0%d.sav",p);

		ofstream fout(k,ios::binary);

		if (!fout)
		{
			Info_Box(Screen,"Error...","Ok",
				"Error writing file!",END);
		}
		else
		{
			for (i=0; i<960; i++)
			{
				for (j=0; j<750; j++)
				{
					t[i][j]=getpixel(MapBmp.Bitmap,i,j);
				}
			}

			fout.write((char*) &gm,sizeof gm);
			fout.write((char*) &t,sizeof t);
			fout.close();
		}
	}
	button[0].Delete();
	button[1].Delete();
}

void Show_Player_Info(DBitmap &bmp,PLAYER_STRUCT &pl)
{
	char msg[80];

	rectfill(bmp.Bitmap,480,25,580,74,COLOR_LIGHT);
	bmp.Text(pl.name,480,30); 
    sprintf(msg, " %d million ", pl.cash);
	bmp.Text(msg,480,45);
    sprintf(msg, " %d moves ", (long)(pl.move));
	bmp.Text(msg,480,60);

	if (pl.item1>0)
	{
		blit((BITMAP*)misc[pl.item1].dat,bmp.Bitmap,0,0,13,SCREEN_H-27,23,23);
		Make_Border(bmp,13,SCREEN_H-27,36,SCREEN_H-4,UP);
	}
	else
	{
		Make_Window(bmp,13,SCREEN_H-27,36,SCREEN_H-4,UP);
	}

	if (pl.item2>0)
	{
		blit((BITMAP*)misc[pl.item2].dat,bmp.Bitmap,0,0,51,SCREEN_H-27,23,23);
		Make_Border(bmp,51,SCREEN_H-27,74,SCREEN_H-4,UP);
	}
	else
	{
		Make_Window(bmp,51,SCREEN_H-27,74,SCREEN_H-4,UP);
	}
	if (pl.item3>0)
	{
		blit((BITMAP*)misc[pl.item3].dat,bmp.Bitmap,0,0,89,SCREEN_H-27,23,23);
		Make_Border(bmp,89,SCREEN_H-27,112,SCREEN_H-4,UP);
	}
	else
	{
		Make_Window(bmp,89,SCREEN_H-27,112,SCREEN_H-4,UP);
	}
	if (pl.train==0 || pl.train==2)
	{
		blit((BITMAP*)misc[COMM_28].dat,bmp.Bitmap,0,0,89,SCREEN_H-27,23,23);		
	}

	bmp.Text("1",5,SCREEN_H-19);
	bmp.Text("2",43,SCREEN_H-19);
	bmp.Text("3",81,SCREEN_H-19);
}

void Show_Players(DBitmap &bmp)
{
	int i;

	for (i=0; i<M.num_players; i++)
	{
		if (M.player[i].x-M.mapx>3 && M.player[i].x-M.mapx<SCREEN_W-10 &&
			M.player[i].y-M.mapy>3 && M.player[i].y-M.mapy<SCREEN_H-107)
		{
			draw_sprite(bmp.Bitmap,(BITMAP*)misc[PLAYER_1+i].dat,
                        M.player[i].x-M.mapx+3-4, M.player[i].y-M.mapy+73-4);
		}
	}
}


void Draw_Map(DBitmap &bmp)
{
	MapBmp.Draw(bmp,M.mapx,M.mapy,3,77,SCREEN_W-7,SCREEN_H-107);
	Show_Players(bmp);

}

void show()
{
	char msg[80];
	sprintf(msg,"%d %d",M.player->x,M.player->y);
	Info_Box(Screen,"","Ok",msg,"@@@");

}


void Init_Player()           // reset M.player values
{
	int s;
	for (s=0; s<M.num_players; s++)
	{
		sprintf(M.player[s].name,"Player %d",s+1);
        M.player[s].x         =  -9;
        M.player[s].y         =  -9;
        M.player[s].move      =  M.move[0];
        M.player[s].cash      =  M.start_cash;  // 60/beg or 80/adv
        M.player[s].train     =  0;           // begining train
        M.player[s].item1     =  0;           // 
        M.player[s].item2     =  0;           //  No items
        M.player[s].item3     =  0;           // 
        M.player[s].color     =  color[s];    // color of M.players indiv track

		do
		{
			M.player[s].card1     =  M.GameDeck.Pick();
		} while (M.GameDeck.card[M.player[s].card1].type>0);
		do
		{
			M.player[s].card2     =  M.GameDeck.Pick();
		} while (M.GameDeck.card[M.player[s].card2].type>0);
		do
		{
			M.player[s].card3     =  M.GameDeck.Pick();
		} while (M.GameDeck.card[M.player[s].card3].type>0);
		
		M.player[s].first_turn=  0;
        M.player[s].turn      =  20;          // can only spend 20 million
                                             // per turn building rails
        M.player[s].city[0]   =  0;
        M.player[s].city[1]   =  0;
        M.player[s].city[2]   =  0;
        M.player[s].city[3]   =  0;
        M.player[s].track[0]  =  0;
        M.player[s].track[1]  =  0;
        M.player[s].track[2]  =  0;
        M.player[s].track[3]  =  0;
        M.player[s].track[4]  =  0;
        M.player[s].track[5]  =  0;
        M.player[s].et        =  0;
        M.player[s].go        =  0;
	}
}

void New_Game()           
{
	int s;
	char msg[80];
	M.num_players=Edit_Value(Screen,"How Many Players",2,6,"Done",
					"Enter an Amount",
					"(2-6)","@@@");

	if (M.num_players<2 || M.num_players>6)
		M.num_players=2;

	Init_Player();
	for (s=0; s<M.num_players; s++)
	{
		sprintf(msg,"Number %d",s+1);
		Edit_Box(Screen,"Enter Name",M.player[s].name,20,"Done",
						"Enter Name of Player",msg,"@@@");	
	}
}


void set_blacks()
{
/*
   since I use different colors for my dots I need them to show up as black
*/

   static RGB black = { 0,  0,  0  };
   vsync();

   set_color(240, &black);  //  regular dot  England
   set_color(241, &black);  //  mountain       ""
   set_color(242, &black);  //  regular dot  Scotland
   set_color(243, &black);  //  mountain        ""
   set_color(244, &black);  //  regular dot  Wales
   set_color(245, &black);  //  mountain       ""
   set_color(246, &black);  //  small city
   set_color(247, &black);  //  med   city
   set_color(248, &black);  //  Glasgow
   set_color(249, &black);  //  Birmingham
   set_color(250, &black);  //  Manchester
   set_color(251, &black);  //  London

}


void Move_Map(int x,int y)
{
	int dn=0,ox,oy;
	ox=M.mapx;
	oy=M.mapy;
	while (!dn)
	{
		if (mouse_y>38 && mouse_y<SCREEN_H-30)
		{
			M.mapx=ox-(mouse_x-x);
			M.mapy=oy-(mouse_y-y);
			if (M.mapx<0)
			{
				M.mapx=ox=0;
				x=mouse_x;
			}
			if (M.mapy<10)
			{
				M.mapy=oy=10;
				y=mouse_y;
			}
			if (M.mapx>940-SCREEN_W)
			{
				M.mapx=ox=940-SCREEN_W;
				x=mouse_x;
			}
			if (M.mapy>856-SCREEN_H)
			{
				M.mapy=oy=856-SCREEN_H;
				y=mouse_y;
			}
			Draw_Map(Screen);
			Draw_Screen();
		}
		else
		{
			dn=1;
		}
		if (!(mouse_b & 1)) dn=1;
	}
}

void Discard_Cards(PLAYER_STRUCT &pl)
{
	pl.card1	=	M.GameDeck.Pick();
    pl.card2	=	M.GameDeck.Pick();
    pl.card3    =	M.GameDeck.Pick();

	if (M.GameDeck.card[pl.card1].type>0) 
	{
		Big_News(pl.card1);
	}
	if (M.GameDeck.card[pl.card2].type>0) 
	{
		Big_News(pl.card2);
	}
	if (M.GameDeck.card[pl.card3].type>0) 
	{
		Big_News(pl.card3);
	}
}

int Show_Card(PLAYER_STRUCT &pl)
{
	DButton	button;
	int dn=0,x1,x2,x3;
	char msg[80];
	DBitmap behind;

	x1=pl.card1;
	x2=pl.card2;
	x3=pl.card3;

	button.Create(289,299,60,12,"Done");


	behind.Create(290,154);
	behind.Grab(Screen,174,162,0,0,290,154);

	sprintf(msg,"%s's Demand Cards",pl.name);
	Title_Window(Screen,174,162,464,316,msg);

	text_mode(-1);

	if (M.GameDeck.card[x1].type>0)
	{
		stretch_blit((BITMAP*)cards[NEWS].dat,  Screen.Bitmap, 0, 0, 208,261, 179, 181, 90, 112);
	}
	else
	{
		blit((BITMAP*)cards[CARD].dat,Screen.Bitmap,0,0,179,181,90,112);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,city_name[M.GameDeck.card[x1].city_1-1], 224,186,0);
		sprintf(msg, "%ld million", (long)M.GameDeck.card[x1].valu_1);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,msg                         , 224,196,0);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,comm_name[M.GameDeck.card[x1].item_1-1], 224,206,0);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,city_name[M.GameDeck.card[x1].city_2-1], 224,221,0);
		sprintf(msg, "%ld million", (long)M.GameDeck.card[x1].valu_2);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,msg                         , 224,231,0);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,comm_name[M.GameDeck.card[x1].item_2-1], 224,241,0);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,city_name[M.GameDeck.card[x1].city_3-1], 224,256,0);
		sprintf(msg, "%ld million", (long)M.GameDeck.card[x1].valu_3);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,msg                         , 224,266,0);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,comm_name[M.GameDeck.card[x1].item_3-1], 224,276,0);
	}
	Make_Border(Screen,179,181,269,293,UP);


	if (M.GameDeck.card[x2].type>0)
	{	
		stretch_blit((BITMAP*)cards[NEWS].dat,  Screen.Bitmap, 0, 0, 208,261, 274, 181, 90, 112);
	}
	else
	{
		blit((BITMAP*)cards[CARD].dat,Screen.Bitmap,0,0,274,181,90,112);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,city_name[M.GameDeck.card[x2].city_1-1], 319,186,0);
		sprintf(msg, "%ld million", (long)M.GameDeck.card[x2].valu_1);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,msg                         , 319,196,0);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,comm_name[M.GameDeck.card[x2].item_1-1], 319,206,0);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,city_name[M.GameDeck.card[x2].city_2-1], 319,221,0);
		sprintf(msg, "%ld million", (long)M.GameDeck.card[x2].valu_2);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,msg                         , 319,231,0);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,comm_name[M.GameDeck.card[x2].item_2-1], 319,241,0);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,city_name[M.GameDeck.card[x2].city_3-1], 319,256,0);
		sprintf(msg, "%ld million", (long)M.GameDeck.card[x2].valu_3);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,msg                         , 319,266,0);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,comm_name[M.GameDeck.card[x2].item_3-1], 319,276,0);
	}
	Make_Border(Screen,274,181,364,293,UP);

	if (M.GameDeck.card[x3].type>0)
	{
		stretch_blit((BITMAP*)cards[NEWS].dat,  Screen.Bitmap, 0, 0, 208,261, 369, 181, 90, 112);
	}
	else
	{
		blit((BITMAP*)cards[CARD].dat,Screen.Bitmap,0,0,369,181,90,112);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,city_name[M.GameDeck.card[x3].city_1-1], 414,186,0);
		sprintf(msg, "%ld million", (long)M.GameDeck.card[x3].valu_1);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,msg						    , 414,196,0);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,comm_name[M.GameDeck.card[x3].item_1-1], 414,206,0);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,city_name[M.GameDeck.card[x3].city_2-1], 414,221,0);
		sprintf(msg, "%ld million", (long)M.GameDeck.card[x3].valu_2);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,msg                         , 414,231,0);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,comm_name[M.GameDeck.card[x3].item_2-1], 414,241,0);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,city_name[M.GameDeck.card[x3].city_3-1], 414,256,0);
		sprintf(msg, "%ld million", (long)M.GameDeck.card[x3].valu_3);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,msg                         , 414,266,0);
		textout_centre(Screen.Bitmap,(FONT*)data[FONT1].dat,comm_name[M.GameDeck.card[x3].item_3-1], 414,276,0);
	}
	Make_Border(Screen,369,181,459,293,UP);

	dn=0;

	do
	{
		

		if (key[KEY_ESC]) dn=1; 

		button.Draw(Screen);

		Draw_Screen();

		if (Mouse.Click())
		{
			if (button.Pressed())
			{
				dn=1;
			}
		}

	} while (!dn);

	button.Delete();
	behind.Draw(Screen,0,0,174,162,290,154);
	behind.Delete();

	return dn-1;

}

int Show_Comm(DBitmap &bmp)
{
	DButton	button;
	int dn=0;
	DBitmap behind;

	button.Create(289,434,60,12,"Done");

	behind.Create(450,410);
	behind.Grab(bmp,100,44,0,0,450,410);

	Title_Window(bmp,100,44,550,454,"The Commodities");

	blit((BITMAP*)data[CITY_LIST].dat,bmp.Bitmap,1,1,101,64,439,365);

	dn=0;

	do
	{
		

		if (key[KEY_ESC]) dn=1; 

		button.Draw(bmp);

		Draw_Screen();

		if (Mouse.Click())
		{
			if (button.Pressed())
			{
				dn=1;
			}
		}

	} while (!dn);

	button.Delete();
	behind.Draw(bmp,0,0,100,44,450,410);

	behind.Delete();

	return dn-1;

}

void upgrade_train(PLAYER_STRUCT &pl)
{
/*
   upgrade to a bigger or faster train
   cost $20+turn
   only if haven't done anything for that turn
*/
	int dn=0,s=0;

	if (pl.cash>19 && pl.train!=3)
	{
		if (pl.train==1 ||
			pl.train==2) 
		{
			pl.train=3;
			pl.cash-=20;
		}
		else
		{
			if (Message(Screen,"Upgrade Train",
								"Fast Train",
								"Heavy Train",
								"Which train do you want",
								"to upgrade to",
								"Fast Train has more moves",
								"Heavy Train can carry more",END)==0)
			{
				pl.train=1;
				pl.cash-=20;
			}
			else
			{
				pl.train=2;
				pl.cash-=20;
			}

			pl.move=M.move[pl.train];
		}
		Info_Box(Screen,"Upgrade Complete","Ok",
						"Your train has been",
						"Upgraded","@@@");
	}
	else
	{
		if (pl.cash<20)
		{
			Info_Box(Screen,"Upgrade","Ok",
							"You do not have enough",
							"cash!","@@@");
		}
		if (pl.train==3)
		{
			Info_Box(Screen,"Upgrade","Ok",
							"Your train has allready",
							"been fully Upgraded","@@@");
		}

	}
}



void unload_comm(PLAYER_STRUCT &pl)
{
/*
   unloads a commodity from a train
   if at a city, which has demand for it, turn in demand card
   collect $ and get new card
   optherwise just lose comm
*/
	int c,d=0,x,y,t=0,r=0,u=0,dn=0,p;
	M.undo_total=0;

	x=pl.x;
	y=pl.y;
	c=getpixel(MapBmp.Bitmap,x,y);
	
	if (c==246 || c==247) 
	{
        if (x==292 && y==473) {d=1;}       // ABERYSTWYTH
        if (x==355 && y==123) {d=2;}       // AYR
        if (x==238 && y==613) {d=3;}       // BARNSTAPLE
        if (x==454 && y==293) {d=4;}       // BARROW
        if (x==625 && y==123) {d=5;}       // BERWICK
                                           // BIRMINGHAM
        if (x==661 && y==703) {d=7;}       // BRIGHTON
        if (x==400 && y==593) {d=8;}       // BRISTOL
        if (x==733 && y==543) {d=9;}       // CAMBRIDGE
        if (x==220 && y==493) {d=10;}      // CARDIGAN
        if (x==337 && y==583) {d=11;}      // CARDIFF
        if (x==499 && y==203) {d=12;}      // CARLISLE
        if (x==796 && y==593) {d=13;}      // COLCHESTER
        if (x==571 && y==503) {d=14;}      // COVENTRY
        if (x==328 && y==433) {d=15;}      // DOLGELLAU
        if (x==823 && y==683) {d=16;}      // DOVER
        if (x==454 && y==173) {d=17;}      // DUMFRIES
        if (x==562 && y==33)  {d=18;}      // DUNDEE
        if (x==517 && y==83)  {d=19;}      // EDINBURGH
        if (x==283 && y==663) {d=20;}      // EXETER
                                           // GLASGOW
        if (x==454 && y==553) {d=22;}      // GLOUCESTER
        if (x==409 && y==523) {d=23;}      // HEREFORD
        if (x==265 && y==363) {d=24;}      // HOLYHEAD
        if (x==742 && y==373) {d=25;}      // HULL
        if (x==832 && y==573) {d=26;}      // IPSWICH
        if (x==499 && y==303) {d=27;}      // LANCASTER
        if (x==607 && y==343) {d=28;}      // LEEDS
        if (x==697 && y==423) {d=29;}      // LINCOLN
        if (x==445 && y==363) {d=30;}      // LIVERPOOL
                                           // LONDON
                                           // MANCHESTER
        if (x==661 && y==263) {d=33;}      // MIDDLESBROUGH
        if (x==643 && y==223) {d=34;}      // NEWCASTLE
        if (x==616 && y==533) {d=35;}      // NORTHHAMPTON
        if (x==868 && y==513) {d=36;}      // NORWICH
        if (x==616 && y==453) {d=37;}      // NOTTINGHAM
        if (x==580 && y==613) {d=38;}      // READING
        if (x==166 && y==533) {d=39;}      // PEMBROKE
        if (x==22  && y==693) {d=40;}      // PENZANCE
        if (x==526 && y==33)  {d=41;}      // PERTH
        if (x==193 && y==683) {d=42;}      // PLYMOUTH
        if (x==580 && y==693) {d=43;}      // PORTSMOUTH
        if (x==598 && y==393) {d=44;}      // SHEFFIELD
        if (x==526 && y==673) {d=45;}      // SOUTHAMPTON
        if (x==508 && y==433) {d=46;}      // STOKE
        if (x==274 && y==553) {d=47;}      // STRANRAER
        if (x==274 && y==553) {d=48;}      // SWANSEA
        if (x==652 && y==333) {d=49;}      // YORK
	}
    if (c==248)           {d=21;}      // GLASGOW    
    if (c==249)           {d=32;}      // MANCHESTER
    if (c==250)           {d=6;}       // BIRMINGHAM        
	if (c==251)           {d=31;}      // LONDON

	if (d>0)
	{
		if (M.GameDeck.card[pl.card1].city_1==d &&
			M.GameDeck.card[pl.card1].item_1==pl.item1) {t=1;r=1;u=1;}
		if (M.GameDeck.card[pl.card1].city_1==d &&
			M.GameDeck.card[pl.card1].item_1==pl.item2) {t=1;r=1;u=2;}
		if (M.GameDeck.card[pl.card1].city_1==d &&
			M.GameDeck.card[pl.card1].item_1==pl.item3) {t=1;r=1;u=3;}

		if (M.GameDeck.card[pl.card1].city_2==d &&
		    M.GameDeck.card[pl.card1].item_2==pl.item1) {t=1;r=2;u=1;}
		if (M.GameDeck.card[pl.card1].city_2==d &&
		     M.GameDeck.card[pl.card1].item_2==pl.item2) {t=1;r=2;u=2;}
		 if (M.GameDeck.card[pl.card1].city_2==d &&
		    M.GameDeck.card[pl.card1].item_2==pl.item3) {t=1;r=2;u=3;}

		 if (M.GameDeck.card[pl.card1].city_3==d &&
			M.GameDeck.card[pl.card1].item_3==pl.item1) {t=1;r=3;u=1;}
		if (M.GameDeck.card[pl.card1].city_3==d &&
			M.GameDeck.card[pl.card1].item_3==pl.item2) {t=1;r=3;u=2;}
		if (M.GameDeck.card[pl.card1].city_3==d &&
			M.GameDeck.card[pl.card1].item_3==pl.item3) {t=1;r=3;u=3;}

		 if (M.GameDeck.card[pl.card2].city_1==d &&
			M.GameDeck.card[pl.card2].item_1==pl.item1) {t=2;r=1;u=1;}
		if (M.GameDeck.card[pl.card2].city_1==d &&
			M.GameDeck.card[pl.card2].item_1==pl.item2) {t=2;r=1;u=2;}
		if (M.GameDeck.card[pl.card2].city_1==d &&
			M.GameDeck.card[pl.card2].item_1==pl.item3) {t=2;r=1;u=3;}

		if (M.GameDeck.card[pl.card2].city_2==d &&
			M.GameDeck.card[pl.card2].item_2==pl.item1) {t=2;r=2;u=1;}
		if (M.GameDeck.card[pl.card2].city_2==d &&
			M.GameDeck.card[pl.card2].item_2==pl.item2) {t=2;r=2;u=2;}
		if (M.GameDeck.card[pl.card2].city_2==d &&
			M.GameDeck.card[pl.card2].item_2==pl.item3) {t=2;r=2;u=3;}

		if (M.GameDeck.card[pl.card2].city_3==d &&
			M.GameDeck.card[pl.card2].item_3==pl.item1) {t=2;r=3;u=1;}
		if (M.GameDeck.card[pl.card2].city_3==d &&
			M.GameDeck.card[pl.card2].item_3==pl.item2) {t=2;r=3;u=2;}
		if (M.GameDeck.card[pl.card2].city_3==d &&
			M.GameDeck.card[pl.card2].item_3==pl.item3) {t=2;r=3;u=3;}

		if (M.GameDeck.card[pl.card3].city_1==d &&
		     M.GameDeck.card[pl.card3].item_1==pl.item1) {t=3;r=1;u=1;}
		if (M.GameDeck.card[pl.card3].city_1==d &&
			M.GameDeck.card[pl.card3].item_1==pl.item2) {t=3;r=1;u=2;}
		if (M.GameDeck.card[pl.card3].city_1==d &&
			M.GameDeck.card[pl.card3].item_1==pl.item3) {t=3;r=1;u=3;}

		if (M.GameDeck.card[pl.card3].city_2==d &&
			M.GameDeck.card[pl.card3].item_2==pl.item1) {t=3;r=2;u=1;}
		if (M.GameDeck.card[pl.card3].city_2==d &&
			M.GameDeck.card[pl.card3].item_2==pl.item2) {t=3;r=2;u=2;}
		if (M.GameDeck.card[pl.card3].city_2==d &&
			M.GameDeck.card[pl.card3].item_2==pl.item3) {t=3;r=2;u=3;}

		if (M.GameDeck.card[pl.card3].city_3==d &&
			M.GameDeck.card[pl.card3].item_3==pl.item1) {t=3;r=3;u=1;}
		if (M.GameDeck.card[pl.card3].city_3==d &&
			M.GameDeck.card[pl.card3].item_3==pl.item2) {t=3;r=3;u=2;}
		if (M.GameDeck.card[pl.card3].city_3==d &&
			M.GameDeck.card[pl.card3].item_3==pl.item3) {t=3;r=3;u=3;}

		if (t>0 && r>0 && u>0)
		{
			if (u==1) pl.item1=0;
			if (u==2) pl.item2=0;
			if (u==3) pl.item3=0;
			if (t==1 && r==1) pl.cash+=M.GameDeck.card[pl.card1].valu_1;
			if (t==1 && r==2) pl.cash+=M.GameDeck.card[pl.card1].valu_2;
			if (t==1 && r==3) pl.cash+=M.GameDeck.card[pl.card1].valu_3;
			if (t==2 && r==1) pl.cash+=M.GameDeck.card[pl.card2].valu_1;
			if (t==2 && r==2) pl.cash+=M.GameDeck.card[pl.card2].valu_2;
			if (t==2 && r==3) pl.cash+=M.GameDeck.card[pl.card2].valu_3;
			if (t==3 && r==1) pl.cash+=M.GameDeck.card[pl.card3].valu_1;
			if (t==3 && r==2) pl.cash+=M.GameDeck.card[pl.card3].valu_2;
			if (t==3 && r==3) pl.cash+=M.GameDeck.card[pl.card3].valu_3;
			if (t>0) 
			{
				if (t==1) 
				{
					pl.card1     =  M.GameDeck.Pick();
					if (M.GameDeck.card[pl.card1].type>0) {Big_News(pl.card1);} 
				}
				if (t==2) 
				{
					pl.card2     =  M.GameDeck.Pick();
					if (M.GameDeck.card[pl.card2].type>0) {Big_News(pl.card2);} 
				}
				if (t==3) 
				{
					pl.card3     =  M.GameDeck.Pick();
					if (M.GameDeck.card[pl.card3].type>0) {Big_News(pl.card3);} 
				}
			}
			else {d=0;}
		}
	}
	if (d==0 || u==0)
	{
		p=Edit_Value(Screen,"Which Commodity",0,3,"Done",
					"Enter the cargo load",
					"You want to drop!",
					"Remember you will lose",
					"this load forever!",
					"(1-3) or 0 to cancel!","@@@");
		if (p==1) pl.item1=0;
		if (p==2) pl.item2=0;
		if (p==3) pl.item3=0;		
	}
	if (d!=0) {M.undo_total=0;}

}



void load_comm(PLAYER_STRUCT &pl)
{
/*
   loads a commodity from a city if have room
*/
	int t1=0,t2=0,t3=100,t4=0,x,y,c,dn=0;

	if (M.load[pl.train]>2 && pl.item3==0) {t4=3;}
	if (pl.item2==0) {t4=2;}
	if (pl.item1==0) {t4=1;}

	if (t4>0)
	{
		x=pl.x;
		y=pl.y;
		c=getpixel(MapBmp.Bitmap,x,y);

		if (c==246 || c==247) 
		{
	        if (x==292 && y==473) {t1=8;t2=22;}
			if (x==355 && y==123) {t1=5;t2=0;}
			if (x==238 && y==613) {t1=6;t2=0;}
			if (x==454 && y==293) {t1=23;t2=0;}
			if (x==625 && y==123) {t1=22;t2=4;}
			if (x==400 && y==593) {t1=26;t2=0;}
	
		    if (x==733 && y==543) {t1=9;t2=0;}
			if (x==220 && y==493) {t1=9;t2=0;}

			if (x==499 && y==203) {t1=17;t2=0;}
			if (x==796 && y==593) {t1=4;t2=0;}
			if (x==571 && y==503) {t1=3;t2=0;}
			if (x==328 && y==433) {t1=16;t2=0;}
			if (x==823 && y==683) {t1=13;t2=0;}
			if (x==454 && y==173) {t1=18;t2=0;}
			if (x==562 && y==33)  {t1=15;t2=0;}
			if (x==517 && y==83)  {t1=8;t2=0;}
			if (x==283 && y==663) {t1=2;t2=0;}
			if (x==454 && y==553) {t1=17;t2=0;}
			if (x==409 && y==523) {t1=12;t2=13;}

			if (x==742 && y==373) {t1=11;t2=0;}
			if (x==832 && y==573) {t1=17;t2=0;}
			if (x==499 && y==303) {t1=20;t2=0;}
			if (x==607 && y==343) {t1=25;t2=0;}
			if (x==697 && y==423) {t1=24;t2=0;}
			if (x==445 && y==363) {t1=10;t2=14;}
			if (x==661 && y==263) {t1=19;t2=0;}
			if (x==643 && y==223) {t1=8;t2=0;}
			if (x==616 && y==533) {t1=2;t2=0;}
			if (x==868 && y==513) {t1=1;t2=0;}
			if (x==616 && y==453) {t1=25;t2=0;}
			if (x==580 && y==613) {t1=2;t2=0;}
			if (x==166 && y==533) {t1=11;t2=0;}

			if (x==526 && y==33) {t1=25;t2=0;}
			if (x==193 && y==683) {t1=7;t2=0;}
			if (x==580 && y==693) {t1=14;t2=19;}
			if (x==598 && y==393) {t1=17;t2=0;}
			if (x==526 && y==673) {t1=14;t2=21;}
			if (x==508 && y==433) {t1=6;t2=0;}
			if (x==274 && y==553) {t1=23;t2=0;}
	
			if (x==652 && y==333) {t1=4;t2=0;}
		}

		if (c==249) {t1=8;t2=25;}     // Manchester
		if (c==250) {t1=3;t2=23;}     // Birmingham
		if (c==251) {t1=14;t2=27;}    // London
		// Glasgow has no commodities

		if (t1>0 && t2==0) 
		{
			t3=t1;
		}

		if (t1>0 && t2>0)
		{
			if (Message(Screen,"Which Commodity",
							comm_name[t1-1],
							comm_name[t2-1],
							"This city has two commodities",
							"Choose the one you would like",
							"to load on to your train","@@@")==0)
			{
				t3=t1;
			}
			else
			{
				t3=t2;
			}
		}

		if (t3!=100)
		{
			if (t4==1) 
			{
				pl.item1=t3;
				M.undo[M.undo_total].x1=1;
				M.undo[M.undo_total].type=3;
				M.undo_total++;
			}
			if (t4==2) 
			{
				pl.item2=t3;
				M.undo[M.undo_total].x1=2;
				M.undo[M.undo_total].type=3;
				M.undo_total++;
			}
			if (t4==3) 
			{
				pl.item3=t3;
				M.undo[M.undo_total].x1=3;
				M.undo[M.undo_total].type=3;
				M.undo_total++;
			}
		}
	}
}

int check_event(int x1,int y1,int x2,int y2)
{
int i=0;
return(0);
x1=M.mapx-3+x1;y1=M.mapy-73+y1;
x2=M.mapx-3+x2;y2=M.mapy-73+y2;

if (M.event[1]>0)
   {if (
        (x1>=805 && y1>=543 && x2<=859 && y2<=603) ||
        (x1>=481 && y1>=403 && x2<=534 && y2<=463) ||
        (x1>=580 && y1>=313 && x2<=634 && y2<=373) ||
        (x1>=706 && y1>=513 && x2<=760 && y2<=573) ||
        (x1>=796 && y1>=653 && x2<=850 && y2<=713) ) i=1;
   }
if (M.event[2]>0)
   {if ( (y1>=73 && y1<613) &&
         (getpixel(MapBmp.Bitmap,x1-90,y1)==1 ||
          getpixel(MapBmp.Bitmap,x1-90,y1)==1)
       ) i=1;
    if ( (y2>=73 && y2<613) &&
         (getpixel(MapBmp.Bitmap,x2-90,y2)==1 ||
          getpixel(MapBmp.Bitmap,x2-90,y2)==1)
       ) i=1;
   }
if (M.event[3]>0) {}
if (M.event[4]>0) {} //no event
if (M.event[5]==(M.player_num+1)) {i=1;}
if (M.event[6]>0)
   {if (
       (getpixel(MapBmp.Bitmap,x1,y1)==242 ||
        getpixel(MapBmp.Bitmap,x2,y2)==243) ) i=1;
    if (
       (getpixel(MapBmp.Bitmap,x1,y1)==242 ||
        getpixel(MapBmp.Bitmap,x2,y2)==243) ) i=1;
   }
if (M.event[7]>0)
   {if (
       (getpixel(MapBmp.Bitmap,x1,y1)==240 ||
        getpixel(MapBmp.Bitmap,x2,y2)==241) ) i=1;
    if (
       (getpixel(MapBmp.Bitmap,x1,y1)==240 ||
        getpixel(MapBmp.Bitmap,x2,y2)==241) ) i=1;
   }
if (M.event[8]>0) {}
if (M.event[9]>0)
   {if ( (x1>=193 && x1<823) &&
         (getpixel(MapBmp.Bitmap,x1,y1+50)==1 ||
          getpixel(MapBmp.Bitmap,x1,y1+50)==1)
       ) i=1;
    if ( (x2>=193 && x2<823) &&
         (getpixel(MapBmp.Bitmap,x2,y2+50)==1 ||
          getpixel(MapBmp.Bitmap,x2,y2+50)==1)
       ) i=1;
   }
if (M.event[10]>0)
   {if (
        (x1>=266 && y1>=633 && x2<=310 && y2<=693) ||
        (x1>=571 && y1>=363 && x2<=625 && y2<=423) ||
        (x1>=499 && y1>=463 && x2<=553 && y2<=523) ||
        (x1>=616 && y1>=193 && x2<=670 && y2<=253) ||
        (x1>=472 && y1>=273 && x2<=527 && y2<=333) ) i=1;
   }
if (M.event[11]>0)
   {if (
       (getpixel(MapBmp.Bitmap,x1,y1)==241 ||
        getpixel(MapBmp.Bitmap,x2,y2)==241) ) i=1;
    if (
       (getpixel(MapBmp.Bitmap,x1,y1)==243 ||
        getpixel(MapBmp.Bitmap,x2,y2)==243) ) i=1;
    if (
       (getpixel(MapBmp.Bitmap,x1,y1)==245 ||
        getpixel(MapBmp.Bitmap,x2,y2)==245) ) i=1;
   }
if (M.event[12]>0) {} //no event
if (M.event[13]>0)
   {if (
        (x1>=841 && y1>=483 && x2<=895 && y2<=543) ||
        (x1>=625 && y1>=303 && x2<=679 && y2<=363) ||
        (x1>=382 && y1>=493 && x2<=436 && y2<=553) ||
        (x1>=715 && y1>=343 && x2<=769 && y2<=403) ||
        (x1>=418 && y1>=333 && x2<=472 && y2<=393) ||
        (x1>=472 && y1>=173 && x2<=526 && y2<=233) ||
        (x1>=553 && y1>=663 && x2<=607 && y2<=723) ) i=1;
   }

if (i==1) {return(1);}

return(0);
}

void flood(int s)
{
int x,y;

  for (x=0; x<960; x++)
  for (y=0; y<750; y++)
  {  
	  if (getpixel((BITMAP*)data[FLOOD].dat, x,y)==s)
	  {
		putpixel(MapBmp.Bitmap, x,y,getpixel((BITMAP*)data[MAPSCREEN].dat, x,y));
	  }
  }
}


void Big_News(int s)   /// Event cards
{
	int p;
	p=M.GameDeck.card[s].type;

	flood(p);

	switch(p)
	{
	case 1:
		{
			Info_Box(Screen,"Daily News!","Ok",
							"Big News","Done",
							"Derailment!",
							"",
							"All trains within three",
							"mileposts of Ipswich,",
							"Stoke,Leeds,",
							"Cambrisge,and Dover",
							"",
							"Lose one turn",
							"and",
							"one load.","@@@");
		} break;
   case 2:
		{
			Info_Box(Screen,"Daily News!","Ok",
							"Gale!",
							"",
							"No train within five",
							"mileposts of the Irish",
							"and Celtic Seas from",
							"Barnstaple to Glasgow",
							"may move.","@@@");
		} break;
   case 3:
		{
			Info_Box(Screen,"Daily News!","Ok",
							"Flood!",
							"",
							"No train may cross the",
							"Trent, Eden, and Tyne",
							"Rivers.",
							"",
							"All rail lines over",
							"these rivers are",
							"destroyed, but may",
							"be rebuilt.","@@@");
		} break;
   case 4:
		{
			Info_Box(Screen,"Daily News!","Ok",
							"Derailment!",
							"",
							"All trains in Wales,",
							"",
							"Lose one turn",
							"and",
							"one load.","@@@");
		} break;
   case 5:
		{
			Info_Box(Screen,"Daily News!","Ok",
							"Wildcat Strike!",
							"",
							"No train may move on",
							"the drawing M.player's",
							"rail line",
							"",
							"Drawing M.player may",
							"not build track.","@@@");
		} break;
   case 6:
		{
			Info_Box(Screen,"Daily News!","Ok",
							"Rail Strike!",
							"",
							"No train in Scotland",
							"may move.",
							"",
							"No train may enter",
							"Scotland.","@@@");
		} break;
   case 7:
		{
			Info_Box(Screen,"Daily News!","Ok",
							"Rail Strike!",
							"",
							"No train in England",
							"may move.",
							"",
							"No train may enter",
							"England","@@@");
		} break;
   case 8:
		{
			Info_Box(Screen,"Daily News!","Ok",
							"Flood!",
							"",
							"No train may cross the",
							"Ouse and Welland",
							"Rivers.",
							"",
							"All rail lines over",
							"these rivers are",
							"destroyed, but may",
							"be rebuilt.","@@@");
		} break;
   case 9:
		{
			Info_Box(Screen,"Daily News!","Ok",
							"Gale!",
							"",
							"No train within five",
							"mileposts of the",
							"Channel Coast from",
							"Plymouth to Dover",
							"may move.","@@@");
		} break;
   case 10:
		{
			Info_Box(Screen,"Daily News!","Ok",
							"Derailment!"
							"",
							"All trains within three",
							"mileposts of Exeter,",
							"Sheffield,",
							"Birmingham,",
							"Newcastle, and",
							"Lancaster.",
							"",
							"Lose one turn",
							"and",
							"one load.","@@@");
		} break;
   case 11:
		{
			Info_Box(Screen,"Daily News!","Ok",
							"Heavy Snow!",
							"",
							"No rail building or",
							"movement permitted on",
							"mountain mileposts.","@@@");
		} break;
   case 12:
		{
			Info_Box(Screen,"Daily News!","Ok",
							"Derailment!",
							"",
							"All trains in Scotland.",
							"",
							"Lose one turn",
							"and",
							"one load.","@@@");
		} break;
   case 13:
		{
			Info_Box(Screen,"Daily News!","Ok",
							"Derailment!",
							"",
							"All trains within three",
							"mileposts of Norwich",
							"York,Hereford,Hull,",
							"Liverpool,Carlisle,",
							"and Potsmouth,",
							"",
							"Lose one turn",
							"and",
							"one load.","@@@");
		} break;
   case 14:
		{
			Info_Box(Screen,"Daily News!","Ok",
							"Heavy Fog!",
							"",
							"All trains within five",
							"mileposts of the",
							"Thames River move at",
							"half rate.",
							"",
							"No rail building in",
							"this area.","@@@");
		} break;
   case 15:
		{
			Info_Box(Screen,"Daily News!","Ok",
							"Flood!",
							"",
							"No train may cross the",
							"Wye and Severn",
							"Rivers.",
							"",
							"All rail lines over",
							"these rivers are",
							"destroyed, but may",
							"be rebuilt.","@@@");
		} break;
   case 16:
		{
			Info_Box(Screen,"Daily News!","Ok",
							"Rail Strike!",
							"",
							"No train in Wales",
							"may move.",
							"",
							"No train may enter",
							"Wales.","@@@");
		} break;
   case 17:
		{
			Info_Box(Screen,"Daily News!","Ok",
							"Lorry Drivers",
							"Strike!",
							"No pickups or",
							"deliveries to any city",
							"more than two",
							"mileposts from the",
							"coast.","@@@");
		} break;
   case 18:
		{
			Info_Box(Screen,"Daily News!","Ok",
							"Dockers Strike!",
							"",
							"No pickups or",
							"deliveries to London or",
							"any city within two",
							"mileposts of the",
							"coast.","@@@");
		} break;
   case 19:
		{
			Info_Box(Screen,"Daily News!","Ok",
							"Bridge",
							"Collapse",
							"No train may cross the",
							"Thames River",
							"",
							"All bridges over",
							"this river are",
							"destroyed, but may",
							"be rebuilt.","@@@");
		} break;
   case 20:
		{
			Info_Box(Screen,"Daily News!","Ok",
							"Gale!",
							"",
							"No train within five",
							"mileposts of the",
							"North Sea coast from",
							"Dover to Dundee may",
							"move.","@@@");
		} break;
   case 21:
		{
			Info_Box(Screen,"Daily News!","Ok",
							"Derailment!",
							"",
							"All trains within",
							"three mileposts of",
							"Barnstaple, Coventry,",
							"Gloucester, Reading,",
							"London, and Berwick",
							"",
							"Lose one turn",
							"and",
							"one load.","@@@");
		} break;
   case 22:
		{
			Info_Box(Screen,"Daily News!","Ok",
							"Derailment!",
							"",
							"All trains within",
							"three mileposts of",
							"Barrow, Lincoln,",
							"Manchester, Brighton,",
							"Southampton, and",
							"Nottingham.",
							"",
							"Lose one turn",
							"and",
							"one load.","@@@");
		} break;
   default:break;
	}		
}



void Init_Game()
{
	int i;	
	strcpy(M.name,"None");
	M.mouse_spr=0;
	M.undo_total=0;
	M.round=0;
	M.end_turn=0;
	M.player_num=0;
	M.num_players=2;
	M.start_cash=60;

	M.mapx=940-SCREEN_W;
	M.mapy=852-SCREEN_H;

	M.move[0]=9;
	M.move[1]=9;
	M.move[2]=12;
	M.move[3]=12;

	M.load[0]=2;
	M.load[1]=3;
	M.load[2]=2;
	M.load[3]=3;


	for (i=0; i<23; i++)
	{
		M.event[i]=0;
	}

	Button[3].flag=1;
	Button[4].flag=0;
	Button[5].flag=0;

	M.GameDeck.Shuffle(MainDeck);

	MapBmp.Grab((BITMAP*)data[MAPSCREEN].dat,0,0,0,0,960,750);
}

int connected_to_dot(int x1, int y1)
{
/*
   this checks to see if the mile marker you are building
   from is connected to your track.
   returns(FALSE) if you are not connected to that dot
*/
if (getpixel(Screen.Bitmap, x1+1,y1-2)==color[M.player_num] ||
    getpixel(Screen.Bitmap, x1+2,y1  )==color[M.player_num] ||
    getpixel(Screen.Bitmap, x1+1,y1+1)==color[M.player_num] ||
    getpixel(Screen.Bitmap, x1-1,y1+1)==color[M.player_num] ||
    getpixel(Screen.Bitmap, x1-2,y1  )==color[M.player_num] ||
    getpixel(Screen.Bitmap, x1-1,y1-2)==color[M.player_num]) {return(1);}
if (getpixel(Screen.Bitmap, x1 , y1)==248 &&
    M.player[M.player_num].city[0]==1) {return(1);}
if (getpixel(Screen.Bitmap, x1 , y1)==249 &&
    M.player[M.player_num].city[1]==1) {return(1);}
if (getpixel(Screen.Bitmap, x1 , y1)==250 &&
    M.player[M.player_num].city[2]==1) {return(1);}
if (getpixel(Screen.Bitmap, x1 , y1)==251 &&
    M.player[M.player_num].city[3]==1) {return(1);}
return(0);
}

int open_path_to_move(int x1, int y1, int e)

{
/*
   this checks to see if the way is clear to build across mile markers
   197,198,200 colors of land
   12 color of city
   9 color of river
   6 color of border
   1 color of ocean
   0 color of mountain
   returns FALSE if the path someone has already drawn a line there
*/

if (e==1 &&  (getpixel(Screen.Bitmap, x1+1,y1-2)!=197  &&
              getpixel(Screen.Bitmap, x1+1,y1-2)!=198  &&
              getpixel(Screen.Bitmap, x1+1,y1-2)!=200  &&
              getpixel(Screen.Bitmap, x1+1,y1-2)!=9    &&
              getpixel(Screen.Bitmap, x1+1,y1-2)!=6    &&
              getpixel(Screen.Bitmap, x1+1,y1-2)!=1    &&
              getpixel(Screen.Bitmap, x1+1,y1-2)!=0    &&
              getpixel(Screen.Bitmap, x1+1,y1-2)!=12)) {return(0);}

if (e==2 &&  (getpixel(Screen.Bitmap, x1+2,y1  )!=197  &&
              getpixel(Screen.Bitmap, x1+2,y1  )!=198  &&
              getpixel(Screen.Bitmap, x1+2,y1  )!=200  &&
              getpixel(Screen.Bitmap, x1+2,y1  )!=9    &&
              getpixel(Screen.Bitmap, x1+2,y1  )!=6    &&
              getpixel(Screen.Bitmap, x1+2,y1  )!=1    &&
              getpixel(Screen.Bitmap, x1+2,y1  )!=0    &&
              getpixel(Screen.Bitmap, x1+2,y1  )!=12)) {return(0);}

if (e==3 &&  (getpixel(Screen.Bitmap, x1+1,y1+1)!=197  &&
              getpixel(Screen.Bitmap, x1+1,y1+1)!=198  &&
              getpixel(Screen.Bitmap, x1+1,y1+1)!=200  &&
              getpixel(Screen.Bitmap, x1+1,y1+1)!=9    &&
              getpixel(Screen.Bitmap, x1+1,y1+1)!=6    &&
              getpixel(Screen.Bitmap, x1+1,y1+1)!=1    &&
              getpixel(Screen.Bitmap, x1+1,y1+1)!=0    &&
              getpixel(Screen.Bitmap, x1+1,y1+1)!=12)) {return(0);}

if (e==4 &&  (getpixel(Screen.Bitmap, x1-1,y1+1)!=197  &&
              getpixel(Screen.Bitmap, x1-1,y1+1)!=198  &&
              getpixel(Screen.Bitmap, x1-1,y1+1)!=200  &&
              getpixel(Screen.Bitmap, x1-1,y1+1)!=9    &&
              getpixel(Screen.Bitmap, x1-1,y1+1)!=6    &&
              getpixel(Screen.Bitmap, x1-1,y1+1)!=1    &&
              getpixel(Screen.Bitmap, x1-1,y1+1)!=0    &&
              getpixel(Screen.Bitmap, x1-1,y1+1)!=12)) {return(0);}

if (e==5 &&  (getpixel(Screen.Bitmap, x1-2,y1  )!=197  &&
              getpixel(Screen.Bitmap, x1-2,y1  )!=198  &&
              getpixel(Screen.Bitmap, x1-2,y1  )!=200  &&
              getpixel(Screen.Bitmap, x1-2,y1  )!=9    &&
              getpixel(Screen.Bitmap, x1-2,y1  )!=6    &&
              getpixel(Screen.Bitmap, x1-2,y1  )!=1    &&
              getpixel(Screen.Bitmap, x1-2,y1  )!=0    &&
              getpixel(Screen.Bitmap, x1-2,y1  )!=12)) {return(0);}

if (e==6 &&  (getpixel(Screen.Bitmap, x1-1,y1-2)!=197  &&
              getpixel(Screen.Bitmap, x1-1,y1-2)!=198  &&
              getpixel(Screen.Bitmap, x1-1,y1-2)!=200  &&
              getpixel(Screen.Bitmap, x1-1,y1-2)!=9    &&
              getpixel(Screen.Bitmap, x1-1,y1-2)!=6    &&
              getpixel(Screen.Bitmap, x1-1,y1-2)!=1    &&
              getpixel(Screen.Bitmap, x1-1,y1-2)!=0    &&
              getpixel(Screen.Bitmap, x1-1,y1-2)!=12)) {return(0);}
return(1);
}


int check_cross_water(int x1, int y1, int x2, int y2, int e)
{
/*
   this checks to see you are building across water
   if so returns value of additional fees to build
    +2 river (color 9)
    +3 inlet (color 1)
*/

if (e==1)
      {
          if (getpixel(Screen.Bitmap, x1+1,y1-2)==9  ||
              getpixel(Screen.Bitmap, x1+2,y1-3)==9  ||
              getpixel(Screen.Bitmap, x1+3,y1-4)==9  ||
              getpixel(Screen.Bitmap, x1+4,y1-5)==9  ||
              getpixel(Screen.Bitmap, x1+5,y1-6)==9  ||
              getpixel(Screen.Bitmap, x1+6,y1-7)==9  ||
              getpixel(Screen.Bitmap, x1+7,y1-8)==9  ||
              getpixel(Screen.Bitmap, x1+8,y1-9)==9) {return(2);}
          if (getpixel(Screen.Bitmap, x1+1,y1-2)==1  ||
              getpixel(Screen.Bitmap, x1+2,y1-3)==1  ||
              getpixel(Screen.Bitmap, x1+3,y1-4)==1  ||
              getpixel(Screen.Bitmap, x1+4,y1-5)==1  ||
              getpixel(Screen.Bitmap, x1+5,y1-6)==1  ||
              getpixel(Screen.Bitmap, x1+6,y1-7)==1  ||
              getpixel(Screen.Bitmap, x1+7,y1-8)==1  ||
              getpixel(Screen.Bitmap, x1+8,y1-9)==1) {return(3);}
    }
if (e==2)
      {
          if (getpixel(Screen.Bitmap, x1+2,y1)==9  ||
              getpixel(Screen.Bitmap, x1+3,y1)==9  ||
              getpixel(Screen.Bitmap, x1+4,y1)==9  ||
              getpixel(Screen.Bitmap, x1+5,y1)==9  ||
              getpixel(Screen.Bitmap, x1+6,y1)==9  ||
              getpixel(Screen.Bitmap, x1+7,y1)==9  ||
              getpixel(Screen.Bitmap, x1+8,y1)==9  ||
              getpixel(Screen.Bitmap, x1+9,y1)==9  ||
              getpixel(Screen.Bitmap, x1+10,y1)==9  ||
              getpixel(Screen.Bitmap, x1+11,y1)==9  ||
              getpixel(Screen.Bitmap, x1+12,y1)==9  ||
              getpixel(Screen.Bitmap, x1+13,y1)==9  ||
              getpixel(Screen.Bitmap, x1+14,y1)==9  ||
              getpixel(Screen.Bitmap, x1+15,y1)==9  ||
              getpixel(Screen.Bitmap, x1+16,y1)==9) {return(2);}
          if (getpixel(Screen.Bitmap, x1+2,y1)==1  ||
              getpixel(Screen.Bitmap, x1+3,y1)==1  ||
              getpixel(Screen.Bitmap, x1+4,y1)==1  ||
              getpixel(Screen.Bitmap, x1+5,y1)==1  ||
              getpixel(Screen.Bitmap, x1+6,y1)==1  ||
              getpixel(Screen.Bitmap, x1+7,y1)==1  ||
              getpixel(Screen.Bitmap, x1+8,y1)==1  ||
              getpixel(Screen.Bitmap, x1+9,y1)==1  ||
              getpixel(Screen.Bitmap, x1+10,y1)==1  ||
              getpixel(Screen.Bitmap, x1+11,y1)==1  ||
              getpixel(Screen.Bitmap, x1+12,y1)==1  ||
              getpixel(Screen.Bitmap, x1+13,y1)==1  ||
              getpixel(Screen.Bitmap, x1+14,y1)==1  ||
              getpixel(Screen.Bitmap, x1+15,y1)==1  ||
              getpixel(Screen.Bitmap, x1+16,y1)==1) {return(3);}
    }
if (e==3)
      {
          if (getpixel(Screen.Bitmap, x1+1,y1+1)==9  ||
              getpixel(Screen.Bitmap, x1+2,y1+2)==9  ||
              getpixel(Screen.Bitmap, x1+3,y1+3)==9  ||
              getpixel(Screen.Bitmap, x1+4,y1+4)==9  ||
              getpixel(Screen.Bitmap, x1+5,y1+5)==9  ||
              getpixel(Screen.Bitmap, x1+6,y1+6)==9  ||
              getpixel(Screen.Bitmap, x1+7,y1+7)==9  ||
              getpixel(Screen.Bitmap, x1+8,y1+8)==9) {return(2);}
          if (getpixel(Screen.Bitmap, x1+1,y1+1)==1  ||
              getpixel(Screen.Bitmap, x1+2,y1+2)==1  ||
              getpixel(Screen.Bitmap, x1+3,y1+3)==1  ||
              getpixel(Screen.Bitmap, x1+4,y1+4)==1  ||
              getpixel(Screen.Bitmap, x1+5,y1+5)==1  ||
              getpixel(Screen.Bitmap, x1+6,y1+6)==1  ||
              getpixel(Screen.Bitmap, x1+7,y1+7)==1  ||
              getpixel(Screen.Bitmap, x1+8,y1+8)==1) {return(3);}
    }
if (e==4)
      {
          if (getpixel(Screen.Bitmap, x1-1,y1+1)==9  ||
              getpixel(Screen.Bitmap, x1-2,y1+2)==9  ||
              getpixel(Screen.Bitmap, x1-3,y1+3)==9  ||
              getpixel(Screen.Bitmap, x1-4,y1+4)==9  ||
              getpixel(Screen.Bitmap, x1-5,y1+5)==9  ||
              getpixel(Screen.Bitmap, x1-6,y1+6)==9  ||
              getpixel(Screen.Bitmap, x1-7,y1+7)==9  ||
              getpixel(Screen.Bitmap, x1-8,y1+8)==9) {return(2);}
          if (getpixel(Screen.Bitmap, x1-1,y1+1)==1  ||
              getpixel(Screen.Bitmap, x1-2,y1+2)==1  ||
              getpixel(Screen.Bitmap, x1-3,y1+3)==1  ||
              getpixel(Screen.Bitmap, x1-4,y1+4)==1  ||
              getpixel(Screen.Bitmap, x1-5,y1+5)==1  ||
              getpixel(Screen.Bitmap, x1-6,y1+6)==1  ||
              getpixel(Screen.Bitmap, x1-7,y1+7)==1  ||
              getpixel(Screen.Bitmap, x1-8,y1+8)==1) {return(3);}
    }
if (e==5)
      {
          if (getpixel(Screen.Bitmap, x1-2,y1)==9  ||
              getpixel(Screen.Bitmap, x1-3,y1)==9  ||
              getpixel(Screen.Bitmap, x1-4,y1)==9  ||
              getpixel(Screen.Bitmap, x1-5,y1)==9  ||
              getpixel(Screen.Bitmap, x1-6,y1)==9  ||
              getpixel(Screen.Bitmap, x1-7,y1)==9  ||
              getpixel(Screen.Bitmap, x1-8,y1)==9  ||
              getpixel(Screen.Bitmap, x1-9,y1)==9  ||
              getpixel(Screen.Bitmap, x1-10,y1)==9  ||
              getpixel(Screen.Bitmap, x1-11,y1)==9  ||
              getpixel(Screen.Bitmap, x1-12,y1)==9  ||
              getpixel(Screen.Bitmap, x1-13,y1)==9  ||
              getpixel(Screen.Bitmap, x1-14,y1)==9  ||
              getpixel(Screen.Bitmap, x1-15,y1)==9  ||
              getpixel(Screen.Bitmap, x1-16,y1)==9) {return(2);}
          if (getpixel(Screen.Bitmap, x1-2,y1)==1  ||
              getpixel(Screen.Bitmap, x1-3,y1)==1  ||
              getpixel(Screen.Bitmap, x1-4,y1)==1  ||
              getpixel(Screen.Bitmap, x1-5,y1)==1  ||
              getpixel(Screen.Bitmap, x1-6,y1)==1  ||
              getpixel(Screen.Bitmap, x1-7,y1)==1  ||
              getpixel(Screen.Bitmap, x1-8,y1)==1  ||
              getpixel(Screen.Bitmap, x1-9,y1)==1  ||
              getpixel(Screen.Bitmap, x1-10,y1)==1  ||
              getpixel(Screen.Bitmap, x1-11,y1)==1  ||
              getpixel(Screen.Bitmap, x1-12,y1)==1  ||
              getpixel(Screen.Bitmap, x1-13,y1)==1  ||
              getpixel(Screen.Bitmap, x1-14,y1)==1  ||
              getpixel(Screen.Bitmap, x1-15,y1)==1  ||
              getpixel(Screen.Bitmap, x1-16,y1)==1) {return(3);}
    }
if (e==6)
      {
          if (getpixel(Screen.Bitmap, x1-1,y1-2)==9  ||
              getpixel(Screen.Bitmap, x1-2,y1-3)==9  ||
              getpixel(Screen.Bitmap, x1-3,y1-4)==9  ||
              getpixel(Screen.Bitmap, x1-4,y1-5)==9  ||
              getpixel(Screen.Bitmap, x1-5,y1-6)==9  ||
              getpixel(Screen.Bitmap, x1-6,y1-7)==9  ||
              getpixel(Screen.Bitmap, x1-7,y1-8)==9  ||
              getpixel(Screen.Bitmap, x1-8,y1-9)==9) {return(2);}
          if (getpixel(Screen.Bitmap, x1-1,y1-2)==1  ||
              getpixel(Screen.Bitmap, x1-2,y1-3)==1  ||
              getpixel(Screen.Bitmap, x1-3,y1-4)==1  ||
              getpixel(Screen.Bitmap, x1-4,y1-5)==1  ||
              getpixel(Screen.Bitmap, x1-5,y1-6)==1  ||
              getpixel(Screen.Bitmap, x1-6,y1-7)==1  ||
              getpixel(Screen.Bitmap, x1-7,y1-8)==1  ||
              getpixel(Screen.Bitmap, x1-8,y1-9)==1) {return(3);}
    }

return(0);
}




int draw_line(int x1, int y1, int x2, int y2, int e)
{
/*
   Checks to see if there is an open_path to move and if you are
   connected_to_dot. Also checks to see if you've crossed a river
   then builds a track across two mile markers
   var f is the cost of building
*/

	int c,d,f=0,p=0,xx1,xx2,yy1,yy2,px,py;

	px=x1;py=y1;
	
	c=getpixel(Screen.Bitmap, x1, y1);
	d=getpixel(Screen.Bitmap, x2, y2);
	
             
	if (e==1)                 
	{
		if (  (d>=248 && c>=248) || (!open_path_to_move(x1,y1,1)) ) 
		{
			e=0;
		}
        else
		{
			if (connected_to_dot(x1,y1)) 
			{
                if (d==240) {f=1;}
                if (d==241) {f=2;}
                if (d==242) {f=1;}
                if (d==243) {f=2;}
                if (d==244) {f=1;}
                if (d==245) {f=2;}
                if (d==246) {f=3;}
                if (d==247) {f=3;}
                if (d>=248) {f=5;}
            }                                         
			else
			{
				if (!connected_to_dot(x1,y1) && M.player[M.player_num].first_turn==0 && c>245)
                {
					M.player[M.player_num].first_turn=1;p=1;
                    if (d==240) {f=1;}                                      
					if (d==241) {f=2;}                    
					if (d==242) {f=1;}                    
					if (d==243) {f=2;}                    
					if (d==244) {f=1;}                    
					if (d==245) {f=2;}                    
					if (d==246) {f=3;}                    
					if (d==247) {f=3;}                    
					if (d>=248) {f=5;}                    
				}
				else 
				{
					e=0;
				}
			}
		}                   
	}         
	
	
    if (e==2)                   
	{
		if (  (d>=248 && c>=248) || !(open_path_to_move(x1,y1,2)) ) 
		{
			e=0;
		}            
		else     
		{            
			if (connected_to_dot(x1,y1)) 
			{                
				if (d==240) {f=1;}                    
				if (d==241) {f=2;}                    
				if (d==242) {f=1;}                    
				if (d==243) {f=2;}                    
				if (d==244) {f=1;}                    
				if (d==245) {f=2;}                    
				if (d==246) {f=3;}                    
				if (d==247) {f=3;}                    
				if (d>=248) {f=5;}                    
			}                
			else
			{                 
				if (!connected_to_dot(x1,y1) && M.player[M.player_num].first_turn==0 && c>245)                    
				{
					M.player[M.player_num].first_turn=1;p=1;                        
					if (d==240) {f=1;}                        
					if (d==241) {f=2;}                        
					if (d==242) {f=1;}                        
					if (d==243) {f=2;}                        
					if (d==244) {f=1;}                        
					if (d==245) {f=2;}                        
					if (d==246) {f=3;}                        
					if (d==247) {f=3;}                        
					if (d>=248) {f=5;}                        
                   }                    
				else 
				{
					e=0;
				}
			}
		}	      
	}                  
	               
	
	    
    if (e==3)                 
	{
		if (   (d>=248 && c>=248) || (!open_path_to_move(x1,y1,3)) ) 
		{
			e=0;
		}                         
		else
		{
			if (connected_to_dot(x1,y1)) 
			{                
				if (d==240) {f=1;}                    
				if (d==241) {f=2;}                    
				if (d==242) {f=1;}                    
				if (d==243) {f=2;}                    
				if (d==244) {f=1;}                    
				if (d==245) {f=2;}                    
				if (d==246) {f=3;}                    
				if (d==247) {f=3;}                    
				if (d>=248) {f=5;}                    
			}                
			else
               {
				if (!connected_to_dot(x1,y1) && M.player[M.player_num].first_turn==0 && c>245)                                               
				{
					M.player[M.player_num].first_turn=1;p=1;                        
					if (d==240) {f=1;}                        
					if (d==241) {f=2;}                        
					if (d==242) {f=1;}                        
					if (d==243) {f=2;}                        
					if (d==244) {f=1;}                        
					if (d==245) {f=2;}                        
					if (d==246) {f=3;}                        
					if (d==247) {f=3;}                        
					if (d>=248) {f=5;}                        
                }                    
				else 
				{
					e=0;
				}
			}                 			
		}
	}

	
        if (e==4)                   
		{
			if (  (d>=248 && c>=248) || (!open_path_to_move(x1,y1,4)) ) 
			{
				e=0;
			}
			else
			{
				if (connected_to_dot(x1,y1)) 
				{
					if (d==240) {f=1;}                       
                    if (d==241) {f=2;}
					if (d==242) {f=1;}
					if (d==243) {f=2;}
					if (d==244) {f=1;}
					if (d==245) {f=2;}
					if (d==246) {f=3;}
					if (d==247) {f=3;}
					if (d>=248) {f=5;}
				}
				else
				{
					if (!connected_to_dot(x1,y1) && M.player[M.player_num].first_turn==0 && c>245)
					{
						M.player[M.player_num].first_turn=1;p=1;
						if (d==240) {f=1;}
						if (d==241) {f=2;}
						if (d==242) {f=1;}
						if (d==243) {f=2;}
						if (d==244) {f=1;}
						if (d==245) {f=2;}
						if (d==246) {f=3;}
						if (d==247) {f=3;}
						if (d>=248) {f=5;}
					}
					else 
					{
						e=0;
					}
				}
			} 
		}

		if (e==5)                   
		{
			if (  (d>=248 && c>=248) || (!open_path_to_move(x1,y1,5)) ) 
			{
				e=0;
			}
			else
			{
				if (connected_to_dot(x1,y1)) 
				{
					if (d==240) {f=1;}					
					if (d==241) {f=2;}                    
					if (d==242) {f=1;}                    
					if (d==243) {f=2;}                    
					if (d==244) {f=1;}                    
					if (d==245) {f=2;}                    
					if (d==246) {f=3;}                    
					if (d==247) {f=3;}                    
					if (d>=248) {f=5;}                    
				}                
				else
                {
					if (!connected_to_dot(x1,y1) && M.player[M.player_num].first_turn==0 && c>245)
                    {
						M.player[M.player_num].first_turn=1;p=1;                        
						if (d==240) {f=1;}                        
						if (d==241) {f=2;}                        
						if (d==242) {f=1;}                        
						if (d==243) {f=2;}                        
						if (d==244) {f=1;}                        
						if (d==245) {f=2;}                        
						if (d==246) {f=3;}                        
						if (d==247) {f=3;}                        
						if (d>=248) {f=5;}                        
                    }                    
					else 
					{
						e=0;
					}
				}
			}
		}

		if (e==6)
        {
			if (  (d>=248 && c>=248) || (!open_path_to_move(x1,y1,6)) ) 
			{
				e=0;
			}
			else
			{
				if (connected_to_dot(x1,y1)) 
				{            
					if (d==240) {f=1;}                
					if (d==241) {f=2;}                
					if (d==242) {f=1;}                
					if (d==243) {f=2;}                
					if (d==244) {f=1;}                
					if (d==245) {f=2;}                
					if (d==246) {f=3;}                
					if (d==247) {f=3;}                
					if (d>=248) {f=5;}                
				}
				else
				{
					if (!connected_to_dot(x1,y1) && M.player[M.player_num].first_turn==0 && c>245)
					{
						M.player[M.player_num].first_turn=1;p=1;                
						if (d==240) {f=1;}                
						if (d==241) {f=2;}                
						if (d==242) {f=1;}                
						if (d==243) {f=2;}                
						if (d==244) {f=1;}                
						if (d==245) {f=2;}                
						if (d==246) {f=3;}                
						if (d==247) {f=3;}                
						if (d>=248) {f=5;}  
					}
					else 
					{
						e=0;
					}
				}
			}
		}
	
		
/*

          6 - - - - - - - 1             0 starting point
        /   \           /   \           1-6 ending point
      /       \       /       \
    /           \   /           \
  5 - - - - - - - 0 - - - - - - - 2
    \           /   \           /
      \       /       \       /
        \   /           \   /
          4 - - - - - - - 3

*/

	if (e>0)
    {
		f+=check_cross_water(x1,y1,x2,y2,e);
	} 
     

	if (M.player[M.player_num].cash>=f && M.player[M.player_num].turn>=f)
    {
		if (e==1) 
		{
			xx1=M.mapx-3+x1+1;yy1=M.mapy-77+y1-2;
			xx2=M.mapx-3+x1+8 ;yy2=M.mapy-77+y1-9;
		}
		if (e==2) 
		{
			xx1=M.mapx-3+x1+2;yy1=M.mapy-77+y1;
			xx2=M.mapx-3+x1+16;yy2=M.mapy-77+y1;
		}
		if (e==3) 
		{	
			xx1=M.mapx-3+x1+1;yy1=M.mapy-77+y1+1;
			xx2=M.mapx-3+x1+8 ;yy2=M.mapy-77+y1+8;
		}
		if (e==4) 
		{	
			xx1=M.mapx-3+x1-1;yy1=M.mapy-77+y1+1;
			xx2=M.mapx-3+x1-8 ;yy2=M.mapy-77+y1+8;
		}
		if (e==5) 
		{
			xx1=M.mapx-3+x1-2;yy1=M.mapy-77+y1  ;
			xx2=M.mapx-3+x1-16;yy2=M.mapy-77+y1  ;
		}
		if (e==6) 
		{
			xx1=M.mapx-3+x1-1;yy1=M.mapy-77+y1-2;
			xx2=M.mapx-3+x1-8 ;yy2=M.mapy-77+y1-9;
		}

		if (e>0)
		{
			if (d==248) 
			{
				M.player[M.player_num].city[0]=1;
				M.undo[M.undo_total].city=1;
			}
			if (d==249) 
			{
				M.player[M.player_num].city[1]=1;
				M.undo[M.undo_total].city=2;
			}
			if (d==250) 
			{
				M.player[M.player_num].city[2]=1;
				M.undo[M.undo_total].city=3;
			}
			if (d==251) 
			{
				M.player[M.player_num].city[3]=1;
				M.undo[M.undo_total].city=4;
			}
		
			if (p==1) 
			{
				M.player[M.player_num].x=M.mapx-3+x1;
				M.player[M.player_num].y=M.mapy-73+y1;
			}
			
			M.undo[M.undo_total].type=1;
			M.undo[M.undo_total].dir=e;
			M.undo[M.undo_total].cost=f;
			M.undo[M.undo_total].x1=xx1;
			M.undo[M.undo_total].y1=yy1;
			M.undo[M.undo_total].x2=xx2;
			M.undo[M.undo_total].y2=yy2;
			M.undo_total++;

			line(MapBmp.Bitmap,xx1,yy1,xx2,yy2,color[M.player_num]);

			M.player[M.player_num].turn-=f;
			M.player[M.player_num].cash-=f;
		}      
	}
	
	return(0);
}

int find_closest(DBitmap &bmp,int &x,int &y)
{
	int i,j,ox,oy,cx,cy;
	float p,l=100;
	
	for (i=-8; i<9; i++)
    {
        for (j=-8; j<9; j++)
        {
			if (getpixel(bmp.Bitmap,x+i,y+j)>239) 
			{
				cx=ABS(i);
				cy=ABS(j);

				p=sqrt(cx*cx+cy*cy);
				if (p<l)
				{
					ox=i;oy=j;
					l=p;
				}
			}
		}
	} 
	x+=ox;
	y+=oy;
	if (l<100) return 1;
	return 0;
}




void Build_Track(int x1, int y1)
{
	int x2,y2,flag=0;	
	Mouse.Change((BITMAP*)data[MOUSE_1].dat);

	do
	{
		Draw_Screen();

	} while (mouse_b & 1);
 
	x2=mouse_x;
    y2=mouse_y;


	if (find_closest(Screen,x1,y1)==1)
	{
		flag++;
	}
	if (find_closest(Screen,x2,y2)==1)
	{
		flag++;
	}

    if (flag==2)
    {
        if (x2>x1)
        {
			if (y2==y1) {draw_line(x1,y1,x2,y2,2);}
            if (y2>y1) {draw_line(x1,y1,x2,y2,3);}
            if (y2<y1) {draw_line(x1,y1,x2,y2,1);}
		}

        if (x2<x1)                  
		{
			if (y2==y1) {draw_line(x1,y1,x2,y2,5);}
            if (y2>y1) {draw_line(x1,y1,x2,y2,4);}
            if (y2<y1) {draw_line(x1,y1,x2,y2,6);}
		}
    }
}

int check_color(int ccx, int ccy)
{
/*
   when moving train from one dot to next dot
   checks to see if there is track or if traveling in big city
*/
	int c,i,d=0;
	
	c=getpixel(MapBmp.Bitmap,ccx,ccy);

	if (c==M.player[M.player_num].color) 
	{
		return(1);
	}

	for (i=0; i<M.num_players+1; i++)
	{
		if (c==M.player[i].color) 
		{
			d=c;
		}

		if (d==0) 
		{
			return(0);
		}
		else
		{
			if (M.player[M.player_num].track[i]==1) 
			{
				return(1);
			}
            else
            {
				if (M.player[M.player_num].cash<4) 
				{
					return(0);
				}                
				else                 
				{                    
					M.undo[M.undo_total].dir=i;                    
					M.undo[M.undo_total].city=4;                    
					M.player[M.player_num].cash-=4;                    
					M.player[i].cash=M.player[i].cash+4;                    
					M.player[M.player_num].track[i]=1;                    
					return(1);
                }
           }
		}
	}
	
	return(0);
}

void move_train(int xx, int yy)
{
	int r=0,x1,y1,x2,y2,e=0;   
	
	if (M.player[M.player_num].move>0)
	{
		x1=M.player[M.player_num].x;
		y1=M.player[M.player_num].y;

		r=find_closest(Screen,xx,yy);

	
		x2=M.mapx-3+xx;
		y2=M.mapy-73+yy;


	    if (r==1) 
		{
			if (x2>x1)
	        {
				if (y2==y1) {e=2;}
			    if (y2<y1) {e=1;}
				if (y2>y1) {e=3;}
			}
			if (x2<x1)
			{
				if (y2==y1) {e=5;}
	            if (y2<y1) {e=6;}
		        if (y2>y1) {e=4;}
			}
		}
	}

	if (e>0) 
	{
		M.undo[M.undo_total].type=2;
		M.undo[M.undo_total].x1=x1;
		M.undo[M.undo_total].y1=y1;
		M.undo[M.undo_total].dir=M.player_num;
		M.undo[M.undo_total].city=0;
	}

	if (e==1 && ( check_color(x1+1,y1-2)==1 ||
                ( getpixel(MapBmp.Bitmap, x1   ,y1   )>247 &&
                  getpixel(MapBmp.Bitmap, x1+9 ,y1-10)>247) ) )
                  {M.player[M.player_num].x=x1+9 ;
                   M.player[M.player_num].y=y1-10;
                   M.player[M.player_num].move--;} else
	if (e==2 &&
              ( check_color(x1+2,y1)==1 ||
                ( getpixel(MapBmp.Bitmap, x1   ,y1   )>247 &&
                  getpixel(MapBmp.Bitmap, x1+18,y1)>247) ) )
                  {M.player[M.player_num].x=x1+18;
                   M.player[M.player_num].move--;} else
	if (e==3 &&
              ( check_color(x1+1,y1+1)==1 ||
                ( getpixel(MapBmp.Bitmap, x1   ,y1   )>247 &&
                  getpixel(MapBmp.Bitmap, x1+9 ,y1+10)>247) ) )
                  {M.player[M.player_num].x=x1+9 ;
                   M.player[M.player_num].y=y1+10;
                   M.player[M.player_num].move--;} else
	if (e==4 &&
              ( check_color(x1-1,y1+1)==1 ||
                ( getpixel(MapBmp.Bitmap, x1   ,y1   )>247 &&
                  getpixel(MapBmp.Bitmap, x1-9 ,y1+10)>247) ) )
                  {M.player[M.player_num].x=x1-9 ;
                   M.player[M.player_num].y=y1+10;
                   M.player[M.player_num].move--;} else
	if (e==5 &&
              ( check_color(x1-2,y1)==1 ||
                ( getpixel(MapBmp.Bitmap, x1   ,y1   )>247 &&
                  getpixel(MapBmp.Bitmap, x1-18,y1)>247) ) )
                  {M.player[M.player_num].x=x1-18;
                   M.player[M.player_num].move--;} else
	if (e==6 &&
              ( check_color(x1-1,y1-2)==1 ||
                ( getpixel(MapBmp.Bitmap, x1   ,y1   )>247 &&
                  getpixel(MapBmp.Bitmap, x1-9 ,y1-10)>247) ) )
                  {M.player[M.player_num].x=x1-9 ;
                   M.player[M.player_num].y=y1-10;
                   M.player[M.player_num].move--;} else {e=0;}

	if (e>0) 
	{
		M.undo[M.undo_total].x2=x2;
		M.undo[M.undo_total].y2=y2;
		M.undo_total++;
	}

}



void undo_erase()
{
/*
   undos the last previous actions ie:build,move,upgrade
*/
	int i,x1,x2,y1,y2,dir,type=0,cost;

	if (M.undo_total>0)
	{
		M.undo_total--;
		type=M.undo[M.undo_total].type;
		cost=M.undo[M.undo_total].cost;
		dir=M.undo[M.undo_total].dir;
		x1=M.undo[M.undo_total].x1;
		y1=M.undo[M.undo_total].y1;
		x2=M.undo[M.undo_total].x2;
		y2=M.undo[M.undo_total].y2;

		if (type==1) 
		{
			if (M.undo[M.undo_total].city==1) 
			{
				M.player[M.player_num].city[0]=1;
			}
			if (M.undo[M.undo_total].city==2) 
			{
				M.player[M.player_num].city[1]=1;
			}
			if (M.undo[M.undo_total].city==3) 
			{
				M.player[M.player_num].city[2]=1;
			}
			if (M.undo[M.undo_total].city==4) 
			{
				M.player[M.player_num].city[3]=1;
			}

			M.player[M.player_num].turn+=cost;
			M.player[M.player_num].cash+=cost;
		/*
          6 - - - - - - - 1
        /   \           /   \
      /       \       /       \
    /           \   /           \
  5 - - - - - - - 0 - - - - - - - 2
    \           /   \           /
      \       /       \       /
        \   /           \   /
          4 - - - - - - - 3

		*/
			if (dir==1) 
			{
				for (i=x1; i<=x2; i++)
				{
					putpixel(MapBmp.Bitmap,i,y1-(i-x1),getpixel((BITMAP*)data[MAPSCREEN].dat,i,y1-(i-x1)));
				}
			}
			if (dir==2) 
			{
				for (i=x1; i<=x2; i++)
				{
					putpixel(MapBmp.Bitmap,i,y1,getpixel((BITMAP*)data[MAPSCREEN].dat,i,y1));
				}
			}
			if (dir==3) 
			{
				for (i=x1; i<=x2; i++)
				{     
					putpixel(MapBmp.Bitmap,i,y1+(i-x1),getpixel((BITMAP*)data[MAPSCREEN].dat,i,y1+(i-x1)));
				}
			}
			if (dir==4) 
			{
				for (i=x2; i<=x1; i++)
				{	
					putpixel(MapBmp.Bitmap,i,y2-(i-x2),getpixel((BITMAP*)data[MAPSCREEN].dat,i,y2-(i-x2)));
				}
			}
			if (dir==5) 
			{
				for (i=x2; i<=x1; i++)
				{
					putpixel(MapBmp.Bitmap,i,y2,getpixel((BITMAP*)data[MAPSCREEN].dat,i,y2));
				}
			}
			if (dir==6) 
			{
				for (i=x2; i<=x1; i++)
				{
					putpixel(MapBmp.Bitmap,i,y2+(i-x2),getpixel((BITMAP*)data[MAPSCREEN].dat,i,y2+(i-x2)));
				}
			}
		}
		if (type==2) 
		{
			M.player[M.player_num].x=M.undo[M.undo_total].x1;
			M.player[M.player_num].y=M.undo[M.undo_total].y1;
			M.player[M.player_num].cash+=M.undo[M.undo_total].city;
			M.player[M.player_num].track[M.undo[M.undo_total].dir]=0;
	        M.player[M.player_num].move++;
		}
		if (type==3) 
		{
			if (x1==1) {M.player[M.player_num].item1=0;}
			if (x1==2) {M.player[M.player_num].item2=0;}
	        if (x1==3) {M.player[M.player_num].item3=0;}
		}
		if (type==4) 
		{
			if (x1==1) {M.player[M.player_num].item1=x2;}
			if (x1==2) {M.player[M.player_num].item2=x2;}
			if (x1==3) {M.player[M.player_num].item3=x2;}
		}

		if (M.undo_total==0 && M.round==0)
		{
			M.player[M.player_num].x=-9;
			M.player[M.player_num].y=-9;
			M.player[M.player_num].first_turn=0;
		}
	}
}

void Init_All()
{
	int l;
	l=text_height(font);;



	install_dlib(800,600);

	COLOR_TITLE=166;

	COLOR_TOP=15;
	COLOR_LIGHT=7;
	COLOR_DARK=8;
	COLOR_BOTTOM=31;

	COLOR_TEXT_UP=15;
	COLOR_TEXT_DOWN=31;

	MOUSE_WHITE=15;
	MOUSE_BLACK=31;

    clear(Mouse.Mouse_Bitmap.Bitmap);
	Mouse.Change(M_HAND);
	Mouse.Show();

	game_name("British Rails");

	data=load_datafile("british.dat");
	butt=load_datafile("buttons.dat");
	misc=load_datafile("misc.dat");
	cards=load_datafile("cards.dat");

	set_palette((RGB*)data[MY_PAL].dat);
	set_blacks();


	text_mode(-1);

	MainDeck.Init();


	MapBmp.Create(960,750);

	Title_Window(Screen,0,0,SCREEN_W,SCREEN_H,GAME_TITLE);
	Make_Window(Screen,2,76,SCREEN_W-2,SCREEN_H-29,DOWN);

	Button[0].Create(4,BOTTOM_OF_TITLE+4,50,l+4,"File");
	Button[1].Create(56,BOTTOM_OF_TITLE+4,50,l+4,"Help");
	Button[2].Create(SCREEN_W-18,BOTTOM_OF_TITLE+4,14,l+4,"X");

	Button[3].Create(2,42,32,32,"",(BITMAP*)butt[BUTTON_01].dat);
	Button[4].Create(35,42,32,32,"",(BITMAP*)butt[BUTTON_02].dat);
	Button[5].Create(68,42,32,32,"",(BITMAP*)butt[BUTTON_03].dat);
	Button[6].Create(111,42,32,32,"",(BITMAP*)butt[BUTTON_04].dat);
	Button[7].Create(144,42,32,32,"",(BITMAP*)butt[BUTTON_05].dat);
	Button[8].Create(187,42,32,32,"",(BITMAP*)butt[BUTTON_06].dat);
	Button[9].Create(230,42,32,32,"",(BITMAP*)butt[BUTTON_07].dat);
	Button[10].Create(263,42,32,32,"",(BITMAP*)butt[BUTTON_08].dat);
	Button[11].Create(306,42,32,32,"",(BITMAP*)butt[BUTTON_09].dat);
	Button[12].Create(339,42,32,32,"",(BITMAP*)butt[BUTTON_10].dat);
	Button[13].Create(372,42,32,32,"",(BITMAP*)butt[BUTTON_11].dat);

	Init_Game();
}

void Draw_All()
{
	int i;
	for (i=0; i<NUM_BUTT; i++)
	{
		Button[i].Draw(Screen);
	}

	Draw_Map(Screen);	

	Show_Player_Info(Screen,M.player[M.player_num]);


	Draw_Screen();
}

void Delete_All()
{
	int i;
	for (i=0; i<NUM_BUTT; i++)
	{
		Button[i].Delete();
	}

	MapBmp.Delete();
	unload_datafile(data);
	unload_datafile(butt);
	unload_datafile(misc);
	unload_datafile(cards);
	uninstall_dlib();
}


int Which_Button()
{
	int i,h=100;
	for (i=0; i<NUM_BUTT; i++)
	{
		if (Button[i].Pressed()) h=i;
	}
	return h;
}

int main()
{
	int dn=0,p,l,mouse_state=UP;	
	PopupStruct Pop1,Pop2;

	Init_All();

	Pop1.Create("New Game","---","Load Game","Save Game","---","Quit",END);
	Pop2.Create("Help","---","About",END);
	
	Draw_All();

	Screen.Splash((BITMAP*)data[OPENSCREEN].dat,468,282);

	Draw_All();

	Init_Player();

	do
	{

		if (key[KEY_E]) 
		{
			show();
		}

		Draw_All();

		if (mouse_y>72 && mouse_y<450)
		{
			if (M.mouse_spr!=1 && Button[3].flag==1)
			{
				Mouse.Change((BITMAP*)data[MOUSE_2].dat);
				M.mouse_spr=1;
			}
		}
		else
		{
			if (M.mouse_spr!=0)
			{
				Mouse.Change((BITMAP*)data[MOUSE_1].dat);
				M.mouse_spr=0;
			}
		}

		if (mouse_b & 1)			
		{
			p=Which_Button();
			if (p<100)
			{
				Draw_All();
			}
			else
			{
				if (mouse_y>38)
				{
					if (Button[3].flag)
						Move_Map(mouse_x,mouse_y);
					if (Button[4].flag)
						Build_Track(mouse_x,mouse_y);
					if (Button[5].flag)
						move_train(mouse_x,mouse_y);				
				}
			}
			if (p==0)
			{
				l=Popup(Screen,Button[p],Pop1);
				if (l==0)
				{
					if (Message(Screen,"New Game?","Ok","Cancel","Are you sure you","Start a New Game?","@@@")==0)
					{
						if (Message(Screen,"Type of Game?","Regular","Fast","What type of Game","do you want to Start?","@@@")==0)
						{
							Init_Game();
							M.move[0]=9;
							M.move[1]=9;
							M.move[2]=12;
							M.move[3]=12;
							M.start_cash=60;
							New_Game();
						}						
						else
						{
							Init_Game();
							M.move[0]=12;
							M.move[1]=12;
							M.move[2]=16;
							M.move[3]=16;
							M.start_cash=80;
							New_Game();
						}					
					}
				}
				if (l==2)
				{
					if (Message(Screen,"Load Game?","Yes","No","Are you sure you","Want to Load Game?","You will end current game!","@@@")==0)
					{
						load_game(M);					
					}
				}				
				if (l==3)
				{
					save_game(M);
				}				
				if (l==5)
				{
					if (Message(Screen,"Quit?","Ok","Cancel","Are you sure you","Want to Quit?","@@@")==0)
					{
						dn=1;
					}
				}
				
			}
			if (p==1)
			{
				l=Popup(Screen,Button[p],Pop2);
				if (l==0)
				{
					/*
					if (Message(Screen,"Help","Next","Done",
						"1Blah,Blah,Blah","@@@")==0)

					if (Message(Screen,"Help","Next","Done",
						"2Blah,Blah,Blah","@@@")==0)

					if (Message(Screen,"Help","Next","Done",
						"3Blah,Blah,Blah","@@@")==0)  */

					Info_Box(Screen,"Help","Done",
						"(Short Version)",
						"Build Railroads to cities",
						"pick up commodities and deliver",
						"to other cities. Collect Payment",
						"First Player to 250 million and",
						"builds to the four Major cities",
						"wins the game!",
						"@@@");

				}				
				if (l==2)
				{
					about(1998);	
				}				
			}
			if (p==3)
			{
				Button[3].flag=1;
				Button[4].flag=0;
				Button[5].flag=0;
			}
			
			if (p==4)
			{
				Button[3].flag=0;
				Button[4].flag=1;
				Button[5].flag=0;
			}
			
			if (p==5 && M.round>=2)
			{
				Button[3].flag=0;
				Button[4].flag=0;
				Button[5].flag=1;
			}	

		}

		if (Mouse.Click())
		{
			p=Which_Button();
			if (p==2)
			{
				if (Message(Screen,"Quit?","Ok","Cancel","Are you sure you","Want to Quit?","@@@")==0)
				{
					dn=1;
				}
			}
			if (p==6)
			{
				load_comm(M.player[M.player_num]);
			}
			if (p==7)
			{
				unload_comm(M.player[M.player_num]);
			}
			if (p==8)
			{
				upgrade_train(M.player[M.player_num]);
			}
			if (p==9)
			{
				Show_Card(M.player[M.player_num]);
			}
			if (p==10)
			{
				Show_Comm(Screen);
			}
			if (p==11)
			{
				if (Message(Screen,"Discard Demand Cards?","Yes","No",
									"Are you sure you",
									"Discard you cards?",
									"This will end your turn!","@@@")==0)
				{
					Discard_Cards(M.player[M.player_num]);
				}
			}
			if (p==12)
			{
				undo_erase();
			}
			if (p==13)
			{
				if (Message(Screen,"End Turn?","Yes","No",
									"Are you sure you",
									"want to End your turn?","@@@")==0)
				{
					M.player_num++;
					if (M.player_num==M.num_players)
					{
						M.player_num=0;
					}
					M.player[M.player_num].move=M.move[M.player[M.player_num].train];
					M.player[M.player_num].turn=20;
					M.round++;					
					M.player[M.player_num].track[0]=0;
					M.player[M.player_num].track[1]=0;
					M.player[M.player_num].track[2]=0;
					M.player[M.player_num].track[3]=0;
					M.player[M.player_num].track[4]=0;
					M.player[M.player_num].track[5]=0;

					M.undo_total=0;

					Button[3].flag=1;
					Button[4].flag=0;
					Button[5].flag=0;

				}	
			}				
		}

	} while (!dn);

	Delete_All();

	return 1;
}

END_OF_MAIN();