#include <dlgraph.h>
#include "british.h"
#include "buttons.h"
#include "misc.h"
#include "cards.h"


#define GAME_TITLE		"British Rails"

#define  MAX_PLAYER_NUM       6
#define  MAX_CARD            136
#define  MAX_UNDO             40
#define  WIN_COLOR            7
#define  TOP_COLOR            15
#define  BOT_COLOR            8

#define NUM_BUTT			14

typedef struct PLAYER_STRUCT
{
    char     name[20];             // Players
    int      x;                    // Players Coordinates
    int      y;                    // Players Coordinates
    int      move;                 // How Many Movements left
    int      cash;                 // How much Money
    int      color;                // What Color track
    int      train;                // What type of Train
    int      item1;                // Which item player is carrying
    int      item2;                // Which item player is carrying
    int      item3;                // Which item player is carrying 
    int      card1;                // What cards player is holding
    int      card2;                // What cards player is holding
    int      card3;                // What cards player is holding
    int      turn;                 // How many drawing turns
    int      first_turn;           // If this is first turn
    int      city[4];              // Which major cities drawn to
    int      track[6];             // If crossed other players' tracks
    int      et;                   // If 1 you lose next turn (event cards)
                                   // If 2 you've crossed players_track
    int      go;                   // If player has reached 250 and all
                                   // 4 major cities game over

} PLAYER_STRUCT;

typedef struct CARD_TYPE
{
    int type;                      // 0 Normal , 1+ Daily News
    int city_1;                    // City name
    int valu_1;                    // Cash Value of Delivery
    int item_1;                    // Delivery needed

    int city_2;                    // City name
    int valu_2;                    // Cash Value of Delivery
    int item_2;                    // Delivery needed

    int city_3;                    // City name
    int valu_3;                    // Cash Value of Delivery
    int item_3;                    // Delivery needed

} CARD_TYPE;

class CDeck
{
public:
	void Init();
	void Shuffle(CDeck &);
	int Pick();
	CARD_TYPE card[MAX_CARD];
	int top;
};

typedef struct UNDO
{
    int      type;    // 1 track, 2 move
    int      x1;      // from x1,y1 to x2,y2
    int      y1;
    int      x2;
    int      y2;
    int      dir;     // only used with drawing track dir of track
    int     cost;     // only used with drawing track cost of track
    int     city;     // used for major cities

} UNDO;

typedef struct GAME_STRUCT
{
	char			name[20]; // name used for loading and saving
	PLAYER_STRUCT	player[MAX_PLAYER_NUM],
					undoplayer;
	CDeck			GameDeck;
	UNDO			undo[MAX_UNDO];

	int				mapx,mapy,mouse_spr,
					undo_total,                // used with undoing drawing or moving
					round,                   // round of game
                               // cannot discard or upgrade unless 0
					end_turn,                // Used with 'Lose a turn'
					player_num,              // currenct player number
					num_players,     // total number of players
					start_cash,     // beginning stats cash
					move[4],		// movement
					load[4],        // regular freight 9 spaces 2 loads
									//   heavy    "    9 spaces 3 loads
									//    fast    "   12 spaces 2 loads
									//   super    "   12 spaces 3 loads
									// in advanced the movement is greater
									// 12,12,16,16 loads are the same
					event[23];      // tells game which event cards are 1-active or 0-not
} GAME_STRUCT;

int Random(int);
void Screen_Draw(DBitmap &Sc);
void Init_All();
void Draw_All();
void Delete_All();
int Which_Button();
int main();

void Big_News(int);
