///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
//  functions included in this file:
//  int collision(int x[4], int y[4]);
//  void delete_lines();
//  int unchecked_vline(int);
//  int full_hline(int);
//  void change_coords(int x[4], int y[4]);
//  int inv_x_nxt(int);
//  int inv_y_nxt(int);
//  int inv_x_coord(int);
//  int inv_y_coord(int);
//  void arrange(int x[4]);
//  void shift_bloxxi(int rows_to_delete[4], int);
//  void scoring(int);
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

int collision(int x[4], int y[4])  {
    for (n=0; n<4; n++) {
        // game field border checks
        if ((x[n] < 0) || (y[n] < 0) || (x[n] >= COLS) || (y[n] >= ROWS))
                return 1;
       
        // game field static tile checks
        if (field[x[n]] [y[n]] != NOTILE)
            return 1;
    }
    return 0;
}


///////////////////////////////////////////////////////////////////////////////

void delete_lines() {
    int i, inv_y, lines_deleted = 0, rows_to_delete[4] = {ROWS, ROWS, ROWS, ROWS};
    for (n=0; n<4; n++) {
        if (unchecked_vline(n) && full_hline(cur_bloxxi.y[n]))    {
            // delete entire line
            lines_deleted++;
            rows_to_delete[n] = cur_bloxxi.y[n];
            inv_y = inv_y_coord(rows_to_delete[n]); 
            rectfill(buffer, BORDER_L,  inv_y, BORDER_R, inv_y+TILE_SIZE-1, makecol(0,0,0));
        }
    }

    if (lines_deleted)            {
        arrange(rows_to_delete);
        blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
        rest(150);
        play_sample(delete_line_sound, VOL, PAN, FREQ, 0);
        shift_bloxxi(rows_to_delete, lines_deleted);
        scoring(lines_deleted);
    }
}


///////////////////////////////////////////////////////////////////////////////

int unchecked_vline(int i) {
    int j;
    for (j=0; j<i; j++)    {
        if (cur_bloxxi.y[i] == cur_bloxxi.y[j])
            return 0;
    }
    return 1;
}


///////////////////////////////////////////////////////////////////////////////

int full_hline(int i) {
    int j;
    for (j=0; j<COLS; j++)  {
        if (field[j][i] == NOTILE)
            return 0;
    }

    return 1;
}


///////////////////////////////////////////////////////////////////////////////

void change_coords(int x[4], int y[4], bloxxi_t *the_bloxxi)  {
    for (n=0; n<4; n++)   {
        the_bloxxi->x[n] = x[n];
        the_bloxxi->y[n] = y[n];
    }
}

///////////////////////////////////////////////////////////////////////////////


int inv_x_nxt(int x)  {
    return (x - START_X + 1) * TILE_SIZE + BORDER_L_NXT;
}


///////////////////////////////////////////////////////////////////////////////

int inv_y_nxt(int y)  {
    return ((ROWS - 1 - y) * TILE_SIZE) + BORDER_U_NXT;
}

///////////////////////////////////////////////////////////////////////////////


int inv_x_coord(int x)  {
    return x * TILE_SIZE + BORDER_L;
}


///////////////////////////////////////////////////////////////////////////////

int inv_y_coord(int y)  {
    return ((ROWS - 1 - y) * TILE_SIZE) + BORDER_U;
}


///////////////////////////////////////////////////////////////////////////////
// function arranges array from low to high

void arrange(int x[4])  {
    int i, temp;
    for (n=4;n>=0;n--)   {
        for (i=0;i<n-1;i++)   {
            if (x[i] > x[i+1])        {
                temp = x[i+1];
                x[i+1] = x[i];
                x[i] = temp;
            }
        }
    }    
}


///////////////////////////////////////////////////////////////////////////////

void shift_bloxxi(int rows_to_delete[4], int lines_deleted)            {
    int i, index = 1;
    
    for (n=rows_to_delete[0]; n<ROWS-lines_deleted; n++)    {
        while ((n+index)==rows_to_delete[index])    {
            index++;
        }
        for (i=0; i<COLS; i++)  {
            field[i][n] = field[i][n+index];
            blit(tiles_bmp[field[i][n]], buffer, 0, 0, 
                inv_x_coord(i), inv_y_coord(n), TILE_SIZE, TILE_SIZE);
        }
    }
    rectfill(buffer, BORDER_L, BORDER_U, BORDER_R, 
    inv_y_coord(ROWS-lines_deleted), makecol(0,0,0));
    blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
   
}


///////////////////////////////////////////////////////////////////////////////

void scoring(int lines_deleted) {
    rows_cleared += lines_deleted;
    score += lines_deleted*lines_deleted*10;
    if ((level < 9) && (rows_cleared >= level_requirement[level+1]))    {
        level++;
        play_sample(lvlup_sound, VOL, PAN, FREQ, 0);
        }
    textprintf_centre_ex(buffer, diamond_font, (BORDER_R+screen->w)/2, 135, makecol(0, 0, 0), makecol(100, 100, 100), " %d ", score);
    textprintf_centre_ex(buffer, diamond_font, (BORDER_R+screen->w)/2, 235, makecol(0, 0, 0), makecol(100, 100, 100), " %d ", level);
    textprintf_centre_ex(buffer, diamond_font, (BORDER_R+screen->w)/2, 335, makecol(0, 0, 0), makecol(100, 100, 100), " %d ", rows_cleared);

}


