///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
//  functions included in this file:
//  void setup_bloxxi(int);
//  void rotate_bloxxi(int);
//  void bloxxi_STRAIGHT(int next_phase, int pivotx, int pivoty, int x[4], int y[4]); 
//  void bloxxi_L(int next_phase, int pivotx, int pivoty, int x[4], int y[4]); 
//  void bloxxi_J(int next_phase, int pivotx, int pivoty, int x[4], int y[4]); 
//  void bloxxi_S(int next_phase, int pivotx, int pivoty, int x[4], int y[4]); 
//  void bloxxi_Z(int next_phase, int pivotx, int pivoty, int x[4], int y[4]); 
//  void bloxxi_T(int next_phase, int pivotx, int pivoty, int x[4], int y[4]); 
//  void setup_SQUARE(int x[4], int y[4]);
//  void setup_BOMB(int x[4], int y[4]);
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

/*  Blox mapping of shapes(from blox 0->3) in each rotation phase:

STRAIGHT: grey
    0)    1-0-2-3  *bloxxi clkwise around 0 for next phase 
    
SQUARE: green 
         0-1
         2-3
L: blue
    0)   1-0-2       1)   3-1        2)        3        3)    2
         3                  0              2-0-1              0
                            2                                 1-3
                            
J: voilet
    0)   1-0-2       1)     1        2)    3            3)    2-3
             3              0              2-0-1              0
                          3-2                                 1                          

S: orange
    0)     0-1       1)   2        2)        3-2        3)    1  
         2-3              3-0              1-0                0-3
                            1                                   2
                            
Z: yellow
    0)   1-0         1)     1      2)      2-3          3)      2
           3-2            3-0                0-1              0-3  
                          2                                   1

T: red
    0)   3-0-1       1)     3      2)        2          3)    1
           2              2-0              1-0-3              0-2
                            1                                 3                          

BOMB: rainbow
    (single tile only)
*/

///////////////////////////////////////////////////////////////////////////////

void setup_bloxxi(int shape)    {
    int x[4], y[4], temp_color;
    switch(shape)   {
        case STRAIGHT:
            bloxxi_STRAIGHT(0, START_X, START_Y, x, y);
            temp_color = GREYBLOX;
            break;
        case SQUARE:
            setup_SQUARE(x, y);
            temp_color = GREENBLOX;
            break;
        case L:
            bloxxi_L(0, START_X, START_Y, x, y);
            temp_color = BLUEBLOX;
            break;
        case J:
            bloxxi_J(0, START_X, START_Y, x, y);
            temp_color = VIOLETBLOX;
            break;
        case S:
            bloxxi_S(0, START_X, START_Y, x, y);
            temp_color = ORANGEBLOX;
            break;
        case Z:
            bloxxi_Z(0, START_X, START_Y, x, y);
            temp_color = YELLOWBLOX; 
            break;
        case T:
            bloxxi_T(0, START_X, START_Y, x, y);
            temp_color = REDBLOX;
            break;
        case BOMB:
            setup_BOMB(x, y);
            temp_color = RAINBOWBLOX;
            break;
    }
    change_coords(x, y, &next_bloxxi);    
    next_bloxxi.tile_color = temp_color;
    next_bloxxi.shape = shape;
    next_bloxxi.rotation_phase = 0;
}

///////////////////////////////////////////////////////////////////////////////

void rotate_bloxxi(int dir)   {
    int next_phase = (cur_bloxxi.rotation_phase+4+dir)%4;
    int x[4], y[4];
    switch (cur_bloxxi.shape)        {
        case STRAIGHT:
                bloxxi_STRAIGHT(next_phase, cur_bloxxi.x[0], cur_bloxxi.y[0], x, y);
                break;
        case L:
                bloxxi_L(next_phase, cur_bloxxi.x[0], cur_bloxxi.y[0], x, y);
                break;
        case J:
                bloxxi_J(next_phase, cur_bloxxi.x[0], cur_bloxxi.y[0], x, y);
                break;
        case S:
                bloxxi_S(next_phase, cur_bloxxi.x[0], cur_bloxxi.y[0], x, y);
                break;
        case Z:
                bloxxi_Z(next_phase, cur_bloxxi.x[0], cur_bloxxi.y[0], x, y);
                break;
        case T:
                bloxxi_T(next_phase, cur_bloxxi.x[0], cur_bloxxi.y[0], x, y);
                break;
    }
                
    if (!collision(x, y))            {
        play_sample(sweep_sound, VOL, PAN, FREQ, 0);
        clear_bloxxi();
        change_coords(x,y, &cur_bloxxi);
        cur_bloxxi.rotation_phase = next_phase;
        display_bloxxi(FIELD_AREA);
    }
}    


///////////////////////////////////////////////////////////////////////////////

void bloxxi_STRAIGHT(int next_phase, int pivotx, int pivoty, int x[4], int y[4])    {
    switch (next_phase) {
        case 0:
            x[0] = pivotx;
            x[1] = pivotx-1;
            x[2] = pivotx+1;
            x[3] = pivotx+2;       
            y[0] = y[1] = y[2] = y[3] = pivoty;
            break;
        case 1:
            x[0] = x[1] = x[2] = x[3] = pivotx; 
            y[0] = pivoty;
            y[1] = pivoty+1;
            y[2] = pivoty-1;
            y[3] = pivoty-2;
            break;
        case 2:
            x[0] = pivotx;
            x[1] = pivotx+1;
            x[2] = pivotx-1;
            x[3] = pivotx-2;       
            y[0] = y[1] = y[2] = y[3] = pivoty;
            break;
        case 3:
            x[0] = x[1] = x[2] = x[3] = pivotx; 
            y[0] = pivoty;
            y[1] = pivoty-1;
            y[2] = pivoty+1;
            y[3] = pivoty+2;
            break;
    }
}


///////////////////////////////////////////////////////////////////////////////

void bloxxi_L(int next_phase, int pivotx, int pivoty, int x[4], int y[4])    {
    switch (next_phase) {
        case 0:
            x[0] = pivotx;
            x[1] = x[3] = pivotx-1;
            x[2] = pivotx+1;
            y[0] = y[1] = y[2] = pivoty;
            y[3] = pivoty-1;
            break;
        case 1:
            x[1] = x[0] = x[2] = pivotx;
            x[3] = pivotx-1;
            y[0] = pivoty;
            y[1] = y[3] = pivoty+1;
            y[2] = pivoty-1;
            break;
    case 2:
            x[0] = pivotx;
            x[1] = x[3] = pivotx+1;
            x[2] = pivotx-1;
            y[0] = y[1] = y[2] = pivoty;
            y[3] = pivoty+1;
            break;
        case 3:
            x[1] = x[0] = x[2] = pivotx;
            x[3] = pivotx+1;
            y[0] = pivoty;
            y[1] = y[3] = pivoty-1;
            y[2] = pivoty+1;
            break;
    }
}


///////////////////////////////////////////////////////////////////////////////

void bloxxi_J(int next_phase, int pivotx, int pivoty, int x[4], int y[4])    {
    switch (next_phase) {
        case 0:
            x[0] = pivotx;
            x[1] = pivotx-1;
            x[2] = x[3] = pivotx+1;
            y[0] = y[1] = y[2] = pivoty;
            y[3] = pivoty-1;
            break;
        case 1:
            x[0] = x[1] = x[2] = pivotx;
            x[3] = pivotx-1;
            y[0] = pivoty;
            y[1] = pivoty+1;
            y[2] = y[3] = pivoty-1;
            break;
        case 2:
            x[0] = pivotx;
            x[1] = pivotx+1;
            x[2] = x[3] = pivotx-1;
            y[0] = y[1] = y[2] = pivoty;
            y[3] = pivoty+1;
            break;
        case 3:
            x[0] = x[1] = x[2] = pivotx;
            x[3] = pivotx+1;
            y[0] = pivoty;
            y[1] = pivoty-1;
            y[2] = y[3] = pivoty+1;
            break;
        }
}


///////////////////////////////////////////////////////////////////////////////

void bloxxi_S(int next_phase, int pivotx, int pivoty, int x[4], int y[4])    {
    switch (next_phase) {
        case 0:
            x[0] = x[3] = pivotx;
            x[1] = pivotx+1;
            x[2] = pivotx-1;
            y[0] = y[1] = pivoty;
            y[2] = y[3] = pivoty-1;
            break;
        case 1:
            x[0] = x[1] = pivotx;
            x[2] = x[3] = pivotx-1;
            y[0] = y[3] = pivoty;
            y[1] = pivoty-1;
            y[2] = pivoty+1;
            break;
        case 2:
            x[0] = x[3] = pivotx;
            x[1] = pivotx-1;
            x[2] = pivotx+1;
            y[0] = y[1] = pivoty;
            y[2] = y[3] = pivoty+1;
            break;
        case 3:
            x[0] = x[1] = pivotx;
            x[2] = x[3] = pivotx+1;
            y[0] = y[3] = pivoty;
            y[1] = pivoty+1;
            y[2] = pivoty-1;
            break;
    }
}


///////////////////////////////////////////////////////////////////////////////

void bloxxi_Z(int next_phase, int pivotx, int pivoty, int x[4], int y[4])    {
    switch (next_phase) {
        case 0:
            x[0] = x[3] = pivotx;
            x[1] = pivotx-1;
            x[2] = pivotx+1;
            y[0] = y[1] = pivoty;
            y[2] = y[3] = pivoty-1;
            break;
        case 1:
            x[0] = x[1] = pivotx;
            x[2] = x[3] = pivotx-1;
            y[0] = y[3] = pivoty;
            y[1] = pivoty+1;
            y[2] = pivoty-1;
            break;
        case 2:
            x[0] = x[3] = pivotx;
            x[1] = pivotx+1;
            x[2] = pivotx-1;
            y[0] = y[1] = pivoty;
            y[2] = y[3] = pivoty+1;
            break;
        case 3:
            x[0] = x[1] = pivotx;
            x[2] = x[3] = pivotx+1;
            y[0] = y[3] = pivoty;
            y[1] = pivoty-1;
            y[2] = pivoty+1;
            break;
    }
}


///////////////////////////////////////////////////////////////////////////////

void bloxxi_T(int next_phase, int pivotx, int pivoty, int x[4], int y[4])    {
    switch (next_phase) {
        case 0:
            x[0] = x[2] = pivotx;
            x[1] = pivotx+1;
            x[3] = pivotx-1;
            y[0] = y[1] = y[3] = pivoty;
            y[2] = pivoty-1;
            break;
        case 1:
            x[0] = x[1] = x[3] = pivotx;
            x[2] = pivotx-1;
            y[0] = y[2] = pivoty;
            y[1] = pivoty-1;
            y[3] = pivoty+1;
            break;
        case 2:
            x[0] = x[2] = pivotx;
            x[1] = pivotx-1;
            x[3] = pivotx+1;
            y[0] = y[1] = y[3] = pivoty;
            y[2] = pivoty+1;
            break;
        case 3:
            x[0] = x[1] = x[3] = pivotx;
            x[2] = pivotx+1;
            y[0] = y[2] = pivoty;
            y[1] = pivoty+1;
            y[3] = pivoty-1;
            break;
    }
}

///////////////////////////////////////////////////////////////////////////////

void setup_SQUARE(int x[4], int y[4])        {
    for (n=0; n<4; n++) {
        x[n] = START_X + (n % 2);
        y[n] = START_Y - (n / 2);
    }
}


///////////////////////////////////////////////////////////////////////////////

void setup_BOMB(int x[4], int y[4])        {
    for (n=0; n<4; n++) {       
        x[n] = START_X;
        y[n] = START_Y;
    }
}

