///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
//  functions included in this file:
//  void new_hiscore();
//  void display_hiscore();
//  void display_howtoplay();
//  void blinking_ESC();
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

void new_hiscore()  {
    char new_name[20] = "                   ";
    int next_char, key_pressed, mid_pivot, left_pivot, right_pivot;
    
    next_char = 0;
    key_pressed = 0;
    mid_pivot = 4;
    left_pivot = 0;
    right_pivot = 9;

    rectfill(screen, 125, 200, 675, 360, makecol(0,0,255));
    rect(screen, 125, 200, 675, 360, makecol(255,255,255));
    rect(screen, 124, 199, 676, 361, makecol(255,255,255));
    rect(screen, 123, 198, 677, 362, makecol(255,255,255));  

    textprintf_centre_ex(screen, diamond_font, 400, 220, makecol(0, 0, 0), -1, "You have reached a new high score!");
    textprintf_centre_ex(screen, diamond_font, 400, 250, makecol(0, 0, 0), -1, "Type your name below (max 19 characters):");
    textprintf_centre_ex(screen, diamond_font, 400, 280, makecol(0, 0, 0), -1, "Press ENTER when done");

    clear_keybuf();
    while ((key_pressed >> 8) != KEY_ENTER)    {
        if (((key_pressed >> 8) == KEY_BACKSPACE) && next_char)    {
            new_name[--next_char] = ' ';
        } else if ((key_pressed >> 8) == KEY_ESC)        {
        } else if ((next_char < 19) && ((key_pressed & 0xff) >= 32) && ((key_pressed & 0xff) <= 126)) {
            new_name[next_char++] = (key_pressed & 0xff);
        }
        rectfill(screen, 200, 315, 600, 345, makecol(0,0,255));
        textprintf_ex(screen, diamond_font, 300, 315, makecol(255, 255, 255), makecol(0, 0, 255), "%s", new_name);
        key_pressed = readkey();
    }
    
    for (n=next_char; n<19; n++)        {
        new_name[n] = ' ';
    }
    
    while (left_pivot != right_pivot)        {
        mid_pivot = (left_pivot+right_pivot)/2;
        if (score < hiscore[mid_pivot].score)    {
            left_pivot = mid_pivot+1;
        } else if (score >= hiscore[mid_pivot].score)    {
            right_pivot = mid_pivot;
        }
    }
    
    for (n=9;n>left_pivot;n--)    {
        hiscore[n].score = hiscore[n-1].score;
        strcpy(hiscore[n].name, hiscore[n-1].name);
    }
        hiscore[left_pivot].score = score;
        strcpy(hiscore[left_pivot].name, new_name);  
}


///////////////////////////////////////////////////////////////////////////////

void display_hiscore()    {
    clear_bitmap(buffer);

    textprintf_centre_ex(buffer, stencil_font, 400, 60, makecol(255, 255, 255), -1, "bloxxi: high scores");

    textprintf_centre_ex(buffer, diamond_font, 212, 132, makecol(100, 100, 100), makecol(0, 0, 0), "Rank:");
    textprintf_ex(buffer, diamond_font, 312, 132, makecol(100, 100, 100), makecol(0, 0, 0), "Name:");
    textprintf_centre_ex(buffer, diamond_font, 582, 132, makecol(100, 100, 100), makecol(0, 0, 0), "Score:");
    textprintf_centre_ex(buffer, diamond_font, 212, 130, makecol(255, 255, 255), -1, "Rank:");
    textprintf_ex(buffer, diamond_font, 310, 130, makecol(255, 255, 255), -1, "Name:");
    textprintf_centre_ex(buffer, diamond_font, 580, 130, makecol(255, 255, 255), -1, "Score:");

    rect(buffer, 171, 121, 631, 166, makecol(100, 100, 100));
    rect(buffer, 171, 166, 631, 476, makecol(100, 100, 100));
    rect(buffer, 256, 121, 526, 476, makecol(100, 100, 100));
    rect(buffer, 170, 120, 630, 165, makecol(200, 200, 200));
    rect(buffer, 170, 165, 630, 475, makecol(200, 200, 200));
    rect(buffer, 255, 120, 525, 475, makecol(200, 200, 200));

    for (n=0; n<10; n++)    {
        textprintf_centre_ex(buffer, diamond_font, 210, 170+30*n, makecol(255, 255, 255), -1, "%d", n+1);
        textprintf_ex(buffer, diamond_font, 280, 170+30*n, makecol(255, 255, 255), -1, "%s", hiscore[n].name);
        textprintf_centre_ex(buffer, diamond_font, 580, 170+30*n, makecol(255, 255, 255), -1, "%d", hiscore[n].score);
    }

    blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);

    blinking_ESC();

}


///////////////////////////////////////////////////////////////////////////////

void display_howtoplay()    {
    clear_bitmap(screen);

    textprintf_centre_ex(screen, stencil_font, 400, 15, makecol(255, 255, 255), -1, "bloxxi: how to play");

    textprintf_ex(screen, diamond_font, 115, 75, makecol(255, 255, 255), -1, "blox(n):- (singular and plural) A colored cube.");
    textprintf_ex(screen, diamond_font, 115, 100, makecol(255, 255, 255), -1, "bloxxi(n):- A set of 4 blox that falls from above.");

    textprintf_ex(screen, diamond_font, 115, 150, makecol(255, 255, 255), -1, "Objective: To get as many points as possible by");
    textprintf_ex(screen, diamond_font, 130, 175, makecol(255, 255, 255), -1, "filling a row (or multiple rows) full of blox.");

    textprintf_ex(screen, diamond_font, 115, 225, makecol(255, 255, 255), -1, "Keys:");
    textprintf_ex(screen, diamond_font, 115, 250, makecol(255, 255, 255), -1, "LEFT/RIGHT/DOWN - move the current bloxxi.");
    textprintf_ex(screen, diamond_font, 115, 275, makecol(255, 255, 255), -1, "UP - hyperdrop the bloxxi.");
    textprintf_ex(screen, diamond_font, 115, 300, makecol(255, 255, 255), -1, "left CTRL/ALT - rotate bloxxi.");
    textprintf_ex(screen, diamond_font, 115, 325, makecol(255, 255, 255), -1, "F1 - pause game & open the How To Play page.");
    textprintf_ex(screen, diamond_font, 115, 350, makecol(255, 255, 255), -1, "F2 - toggle sound on/off.");
    textprintf_ex(screen, diamond_font, 115, 375, makecol(255, 255, 255), -1, "F9 - ends current game.");

    textprintf_ex(screen, diamond_font, 115, 425, makecol(255, 255, 255), -1, "Other useful information:");
    textprintf_ex(screen, diamond_font, 115, 450, makecol(255, 255, 255), -1, "The rainbow blox is a bomb that clears its");
    textprintf_ex(screen, diamond_font, 130, 475, makecol(255, 255, 255), -1, "surrounding blox.");
    textprintf_ex(screen, diamond_font, 115, 500, makecol(255, 255, 255), -1, "Filling several rows at a single drop provides");
    textprintf_ex(screen, diamond_font, 130, 525, makecol(255, 255, 255), -1, "a greater increase in score.");

    blinking_ESC();
}


///////////////////////////////////////////////////////////////////////////////

void blinking_ESC() {
    int dir = 1;
    n = 255;

    while (!key[KEY_ESC])    {
        if (n == 255)
            dir = -1;
        if (n == 5)
            dir = 1;
        
        n = (n + dir*25);
        if (game_over)        {
            textprintf_centre_ex(screen, diamond_font, 400, 570, makecol(n, n, n), -1, "Press ESC to return to the main menu.");    
        } else {
            textprintf_centre_ex(screen, diamond_font, 400, 570, makecol(n, n, n), -1, "Press ESC to return to the game.");    
        }        
        rest(50);
    }
}
