///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
//  functions included in this file:
//  int menu();
//  void setup_splash();
//  void bounce_arrow(void*);
//  void redraw_text(int);
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

int menu() {
    static int cur_select = SEL_NEWGAME;
    int keylock[3] = {0, 0, 1};
    int done = 0;
    int one_tick = ticks-1;
    
    clear_bitmap(buffer);
    setup_splash();
    textprintf_centre_ex(buffer, data[D_stencil_font].dat, buffer->w/2, 200, makecol(255, 255, 255), -1, "bloxxi : a Tetris clone");
    textprintf_right_ex(buffer, diamond_font, 9 * buffer->w / 10, 240, makecol(175, 175, 175), -1, "- A Han Games Studio production");

    rect(buffer, 150, 280, 650, 570, makecol(255, 255, 255));
    rect(buffer, 145, 275, 655, 575, makecol(255, 255, 255));
    
    textprintf_ex(buffer, stencil_font, 280, 300, makecol(100, 100, 100), makecol(0, 0, 0), "New game");
    textprintf_ex(buffer, stencil_font, 280, 370, makecol(100, 100, 100), makecol(0, 0, 0), "How to play");
    textprintf_ex(buffer, stencil_font, 280, 440, makecol(100, 100, 100), makecol(0, 0, 0), "High scores");
    textprintf_ex(buffer, stencil_font, 280, 510, makecol(100, 100, 100), makecol(0, 0, 0), "Exit");
    redraw_text(cur_select);

    while(!done)    {
        if (one_tick != ticks)    {
            if (key[KEY_DOWN] || key[KEY_2_PAD])        {
                 if(!keylock[0])        {
                    play_sample(sweep_sound, VOL, PAN, FREQ, 0);
                    cur_select = (cur_select+NUM_SELECT+1) % NUM_SELECT;
                    keylock[0] = KEYLOCK_TICK2;
                    redraw_text(cur_select);
                } else {
                    keylock[0]--;
                }
            } else if (keylock[0]) {
                keylock[0] = 0;
            }
    
            if (key[KEY_UP] || key[KEY_8_PAD])        {
                 if(!keylock[1])        {
                    play_sample(sweep_sound, VOL, PAN, FREQ, 0);
                    cur_select = (cur_select+NUM_SELECT-1) % NUM_SELECT;
                    keylock[1] = KEYLOCK_TICK2;
                    redraw_text(cur_select);                
                } else {
                    keylock[1]--;
                }
            } else if (keylock[1]) {
                keylock[1] = 0;
            }        
            
            if (key[KEY_ESC])    {
                if (!keylock[2])
                    done = 1;
            } else if (keylock[2]) {
                keylock[2] = 0;
            }
            
            if (key[KEY_ENTER] || key[KEY_SPACE])    {
                play_sample(select_sound, VOL, PAN, FREQ, 0);
                done = 1;
            }
        bounce_arrow(cur_select);
        one_tick = ticks;        
        }
    }
    return cur_select;
}


///////////////////////////////////////////////////////////////////////////////

void setup_splash() {
    int start_splash_x = TILE_SIZE*3;
    int start_splash_y = 20;
    int x[4], y[4];

    bloxxi_J(0, 0, 0, x, y);
    for (n=0; n<4; n++)    {
        blit(tiles_bmp[VIOLETBLOX], buffer, 0, 0, (x[n])*TILE_SIZE+start_splash_x, start_splash_y-y[n]*TILE_SIZE, TILE_SIZE, TILE_SIZE);
    }
    
    start_splash_y += TILE_SIZE*4; 
    bloxxi_L(2, 0, 0, x, y);
    for (n=0; n<4; n++)    {
        blit(tiles_bmp[BLUEBLOX], buffer, 0, 0, (x[n])*TILE_SIZE+start_splash_x, start_splash_y-y[n]*TILE_SIZE, TILE_SIZE, TILE_SIZE);
    }

    start_splash_x -= TILE_SIZE; 
    start_splash_y -= TILE_SIZE*2; 
    bloxxi_T(3, 0, 0, x, y);
    for (n=0; n<4; n++)    {
        blit(tiles_bmp[REDBLOX], buffer, 0, 0, (x[n])*TILE_SIZE+start_splash_x, start_splash_y-y[n]*TILE_SIZE, TILE_SIZE, TILE_SIZE);
    }

    start_splash_x += TILE_SIZE*4; 
    bloxxi_STRAIGHT(1, 0, 0, x, y);
    for (n=0; n<4; n++)    {
        blit(tiles_bmp[GREYBLOX], buffer, 0, 0, (x[n])*TILE_SIZE+start_splash_x, start_splash_y-y[n]*TILE_SIZE, TILE_SIZE, TILE_SIZE);
    }

    start_splash_x += TILE_SIZE*2; 
    start_splash_y += TILE_SIZE;
    setup_SQUARE(x, y);
    for (n=0; n<4; n++)    {
        blit(tiles_bmp[GREENBLOX], buffer, 0, 0, (x[n]-START_X)*TILE_SIZE+start_splash_x, start_splash_y-(y[n]-START_Y)*TILE_SIZE, TILE_SIZE, TILE_SIZE);
    }

    start_splash_x += TILE_SIZE*5; 
    bloxxi_S(1, 0, 0, x, y);
    for (n=0; n<4; n++)    {
        blit(tiles_bmp[ORANGEBLOX], buffer, 0, 0, (x[n])*TILE_SIZE+start_splash_x, start_splash_y-y[n]*TILE_SIZE, TILE_SIZE, TILE_SIZE);
    }
    blit(tiles_bmp[ORANGEBLOX], buffer, 0, 0, (x[0]-2)*TILE_SIZE+start_splash_x, start_splash_y-(y[0]-1)*TILE_SIZE, TILE_SIZE, TILE_SIZE);
    blit(tiles_bmp[ORANGEBLOX], buffer, 0, 0, (x[0]+1)*TILE_SIZE+start_splash_x, start_splash_y-(y[0]+1)*TILE_SIZE, TILE_SIZE, TILE_SIZE);
    blit(tiles_bmp[ORANGEBLOX], buffer, 0, 0, (x[0]+1)*TILE_SIZE+start_splash_x, start_splash_y-(y[0])*TILE_SIZE, TILE_SIZE, TILE_SIZE);

    start_splash_x += TILE_SIZE*5; 
    bloxxi_Z(1, 0, 0, x, y);
    for (n=0; n<4; n++)    {
        blit(tiles_bmp[YELLOWBLOX], buffer, 0, 0, (x[n])*TILE_SIZE+start_splash_x, start_splash_y-y[n]*TILE_SIZE, TILE_SIZE, TILE_SIZE);
    }
    blit(tiles_bmp[YELLOWBLOX], buffer, 0, 0, (x[0]-2)*TILE_SIZE+start_splash_x, start_splash_y-(y[0]+1)*TILE_SIZE, TILE_SIZE, TILE_SIZE);
    blit(tiles_bmp[YELLOWBLOX], buffer, 0, 0, (x[0]-2)*TILE_SIZE+start_splash_x, start_splash_y-(y[0])*TILE_SIZE, TILE_SIZE, TILE_SIZE);
    blit(tiles_bmp[YELLOWBLOX], buffer, 0, 0, (x[0]+1)*TILE_SIZE+start_splash_x, start_splash_y-(y[0]-1)*TILE_SIZE, TILE_SIZE, TILE_SIZE);

    start_splash_x += TILE_SIZE*4; 
    bloxxi_L(1, 0, 0, x, y);
    for (n=0; n<4; n++)    {
        blit(tiles_bmp[RAINBOWBLOX], buffer, 0, 0, (x[n])*TILE_SIZE+start_splash_x, start_splash_y-y[n]*TILE_SIZE, TILE_SIZE, TILE_SIZE);
    }
    blit(tiles_bmp[RAINBOWBLOX], buffer, 0, 0, (x[0])*TILE_SIZE+start_splash_x, start_splash_y-(y[0]+3)*TILE_SIZE, TILE_SIZE, TILE_SIZE);


}


///////////////////////////////////////////////////////////////////////////////

void bounce_arrow(int cur_select) {
    static int speed_start = -7, t = 0;
    static int x = 210, y = 300, x_start = 210;
    float acceleration = 0.5;

    rectfill(buffer, x, y, x+arrow->w-1, y+arrow->h-1, makecol(0, 0, 0));
    t++;

    x = (acceleration*t*t) / 2 +  (speed_start*t) + x_start;
    y = cur_select*70+300;


    if (x >= 210)    {
        x = x_start;
        t = 0;
    }
    
    draw_sprite(buffer, arrow, x, y);
    blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
}


///////////////////////////////////////////////////////////////////////////////

void redraw_text(int cur_select)    {
    static int past_select = SEL_NEWGAME;

    switch (past_select)   {
        case SEL_NEWGAME:
            textprintf_ex(buffer, stencil_font, 280, 300, makecol(100, 100, 100), makecol(0, 0, 0), "New game");
            break;
        case SEL_HOWTOPLAY:
            textprintf_ex(buffer, stencil_font, 280, 370, makecol(100, 100, 100), makecol(0, 0, 0), "How to play");
            break;
        case SEL_HISCORE:
            textprintf_ex(buffer, stencil_font, 280, 440, makecol(100, 100, 100), makecol(0, 0, 0), "High scores");
            break;
        case SEL_EXIT:
            textprintf_ex(buffer, stencil_font, 280, 510, makecol(100, 100, 100), makecol(0, 0, 0), "Exit");
            break;
    }
    
    switch (cur_select)   {
        case SEL_NEWGAME:
            textprintf_ex(buffer, stencil_font, 280, 300, makecol(255, 255, 255), makecol(0, 0, 0), "New game");
            break;
        case SEL_HOWTOPLAY:
            textprintf_ex(buffer, stencil_font, 280, 370, makecol(255, 255, 255), makecol(0, 0, 0), "How to play");
            break;
        case SEL_HISCORE:
            textprintf_ex(buffer, stencil_font, 280, 440, makecol(255, 255, 255), makecol(0, 0, 0), "High scores");
            break;
        case SEL_EXIT:
            textprintf_ex(buffer, stencil_font, 280, 510, makecol(255, 255, 255), makecol(0, 0, 0), "Exit");
            break;
    }
    
    past_select = cur_select;
    blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
}
