///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
//  functions included in this file:
//  void add_tick();
//  void getinput();
//  void setup();
//  void new_game();
//  void lose_game();
//  void game_loop();
//  void main(void);
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

#include "bloxxi.h"
#include "setup_rotate.c"
#include "bloxxi.c"
#include "menu.c"
#include "other_screens.c"
#include "misc.c"

///////////////////////////////////////////////////////////////////////////////

void add_tick() {
    ticks = (ticks+1) % 1000;
}


///////////////////////////////////////////////////////////////////////////////

void getinput() {
    static int sound_on = 1;
    static int keylock[7] = {0, 0, 0, 0, 0, 0, 0};
    static int first_press[2] = {1, 1};

    if(key[KEY_F1])
            display_howtoplay();
            blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
    
    if(key[KEY_F9])
            lose_game();

    if (key[KEY_ALT])    {
        if (keylock[0] == 0)    {
            rotate_bloxxi(DIR_CLK);
            keylock[0] = KEYLOCK_TICK2;
        } else {
            keylock[0]--;
        }
    } else if (keylock[0]) {
        keylock[0] = 0;
    }
    
    if (key[KEY_LCONTROL])    {
        if (keylock[1] == 0)    {
            rotate_bloxxi(DIR_ACLK);
            keylock[1] = KEYLOCK_TICK2;
        } else {
            keylock[1]--;
        }
    } else if (keylock[1]) {
        keylock[1] = 0;
    }
    
    if (key[KEY_LEFT] || key[KEY_4_PAD])    {
        if (keylock[2] == 0)    {
            move_bloxxi(DIR_LEFT, 0);
            if (first_press[0])   {
                first_press[0] = 0;
                keylock[2] = KEYLOCK_TICK2;
            } else {
                keylock[2] = KEYLOCK_TICK1;
            }            
        } else {
            keylock[2]--;
        }
    } else  {
        first_press[0] = 1;
        keylock[2] = 0;
    }       
    
    if (key[KEY_RIGHT] || key[KEY_6_PAD])    {
        if (keylock[3] == 0)    {
            move_bloxxi(DIR_RIGHT, 0);
            if (first_press[1])   {
                first_press[1] = 0;
                keylock[3] = KEYLOCK_TICK2;
            } else {
                keylock[3] = KEYLOCK_TICK1;
            }
        } else {
            keylock[3]--;
        }
    } else   {
        first_press[1] = 1;
        keylock[3] = 0;
    } 
                  
    if (key[KEY_UP] || key[KEY_8_PAD])    {
        if (keylock[4] == 0)    {
            move_bloxxi(0, 1);
            keylock[4] = KEYLOCK_TICK2;
        } else {
            keylock[4]--;
        }
    } else if (keylock[4])   {
        keylock[4] = 0;
    } 
                     
    if (key[KEY_DOWN] || key[KEY_2_PAD])    {
        if (keylock[5] == 0)    {
            move_bloxxi(DIR_DOWN, 0);
            keylock[5] = KEYLOCK_TICK2;
        } else {
            keylock[5]--;
        }
    } else if (keylock[5])   {
        keylock[5] = 0;
    }
    
    if (key[KEY_F2])    {
        if (keylock[6] == 0)    {    
            keylock[6] = KEYLOCK_TICK2;
            if (sound_on)    {
                set_volume(0, -1);
            } else {
                set_volume(VOL, -1);
            }
            sound_on = !sound_on;
        } 
    } else if (keylock[6])   {
        keylock[6] = 0;
    }

}


///////////////////////////////////////////////////////////////////////////////

void setup()            {
    int i, width, height, color_depth;
    allegro_init();
    install_keyboard();
    install_timer();
    srand(time(NULL));

    get_desktop_resolution(&width, &height);
    color_depth = desktop_color_depth();

    if (color_depth >= 24)    {
        set_color_depth(color_depth);
    } else if (color_depth == 16)    {
        set_color_depth(color_depth);
        set_color_conversion(COLORCONV_24_TO_16);
    }
    
    if (height > 600)    {
        set_gfx_mode(GFX_AUTODETECT_WINDOWED, 800, 600, 0, 0);
    } else {
        set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 800, 600, 0, 0);
    }

    set_window_title("Bloxxi: A Han Game Studios production");
    
    if (install_sound(DIGI_AUTODETECT, MIDI_NONE, "") != 0) {
        allegro_message("Error initialising sound system.");
        exit(1);
    }

    data = load_datafile("data.dat");

    stencil_font = data[D_stencil_font].dat;
    diamond_font = data[D_diamond_font].dat;

  
    LOCK_FUNCTION(keylock_timer);
    LOCK_VARIABLE(ticks);
    LOCK_FUNCTION(add_tick);

    buffer = create_bitmap(screen->w, screen->h);

// grabbing the picture for explosions
    blam = data[D_blam].dat;
    
// grabbing the pictures for the different tiles
    for (n=0; n<8; n++)    { 
        tiles_bmp[n] = create_bitmap(TILE_SIZE, TILE_SIZE);
        blit(data[D_alltiles].dat, tiles_bmp[n], n*TILE_SIZE, 0, 0, 0, TILE_SIZE, TILE_SIZE);
    }
    tiles_bmp[NOTILE] = create_bitmap(TILE_SIZE, TILE_SIZE);
    clear_bitmap(tiles_bmp[NOTILE]);

// grabbing the picture for an arrow
    arrow = data[D_arrow].dat;
    

// grabbing sound effects
    select_sound = data[D_select_sound].dat;
    sweep_sound = data[D_sweep_sound].dat;
    drop_sound = data[D_drop_sound].dat;
    explode_sound = data[D_explode_sound].dat;
    delete_line_sound = data[D_delete_line_sound].dat;
    lvlup_sound = data[D_lvlup_sound].dat;
    boo_sound = data[D_boo_sound].dat;
    cheer_sound = data[D_cheer_sound].dat;


//  setting fresh new high score or opening existing one.
    if (!exists("score.dat"))    {
        for (n=0; n<10; n++)    {
            strcpy(hiscore[n].name, "-------------------");
            hiscore[n].score = 0;
        }
    } else {
        score_pack = pack_fopen("score.dat", "rp");
        for (n=0; n<10; n++)    {
            hiscore[n].score = pack_igetl(score_pack);
            pack_getc(score_pack);
            pack_fgets(hiscore[n].name, sizeof(hiscore[n].name), score_pack);
            pack_getc(score_pack);
        }
        pack_fclose(score_pack);

    }

    install_int(add_tick, TIME_PER_TICK);
        
    game_over = 1;
    ticks = 0;
}


///////////////////////////////////////////////////////////////////////////////

void new_game()    {
//coloring the play field
    clear_bitmap(buffer);
    floodfill(buffer, 1, 1, makecol(100,100,100));

    rectfill(buffer, BORDER_L, BORDER_U, BORDER_R, BORDER_D, makecol(0,0,0));
    rect(buffer, BORDER_L-1, BORDER_U-1, BORDER_R+1, BORDER_D+1, makecol(150,150,150));    
    rect(buffer, BORDER_L-2, BORDER_U-2, BORDER_R+2, BORDER_D+2, makecol(200,200,200));   
    rect(buffer, BORDER_L-3, BORDER_U-3, BORDER_R+3, BORDER_D+3, makecol(255,255,255));   

    rectfill(buffer, BORDER_L_NXT, BORDER_U_NXT, BORDER_R_NXT, BORDER_D_NXT, makecol(0,0,0));
    rect(buffer, BORDER_L_NXT-1, BORDER_U_NXT-1, BORDER_R_NXT+1, BORDER_D_NXT+1, makecol(150,150,150));    
    rect(buffer, BORDER_L_NXT-2, BORDER_U_NXT-2, BORDER_R_NXT+2, BORDER_D_NXT+2, makecol(200,200,200));   
    rect(buffer, BORDER_L_NXT-3, BORDER_U_NXT-3, BORDER_R_NXT+3, BORDER_D_NXT+3, makecol(255,255,255));   

    textprintf_centre_ex(buffer, stencil_font, (BORDER_R+screen->w)/2 + 7, 35, makecol(0, 0, 0), -1, "bloxxi");
    textprintf_centre_ex(buffer, stencil_font, (BORDER_R+screen->w)/2, 30, makecol(255, 255, 255), -1, "bloxxi");

    textprintf_ex(buffer, diamond_font, BORDER_L_NXT+2, BORDER_U_NXT-34, makecol(0, 0, 0), -1, "Next bloxxi:");
    textprintf_ex(buffer, diamond_font, BORDER_L_NXT, BORDER_U_NXT-35, makecol(255, 255, 255), -1, "Next bloxxi:");

    rect(buffer, BORDER_R+50, 114, screen->w-50, 180, makecol(0, 0, 0));    
    rect(buffer, BORDER_R+50, 214, screen->w-50, 280, makecol(0, 0, 0));
    rect(buffer, BORDER_R+50, 314, screen->w-50, 380, makecol(0, 0, 0));   
    rect(buffer, BORDER_R+51, 115, screen->w-49, 181, makecol(255, 255, 255));    
    rect(buffer, BORDER_R+51, 215, screen->w-49, 281, makecol(255, 255, 255));
    rect(buffer, BORDER_R+51, 315, screen->w-49, 381, makecol(255, 255, 255));   

    textprintf_ex(buffer, diamond_font, 452, 101, makecol(0, 0, 0), -1, "Score");
    textprintf_ex(buffer, diamond_font, 452, 201, makecol(0, 0, 0), -1, "Level");
    textprintf_ex(buffer, diamond_font, 452, 301, makecol(0, 0, 0), -1, "Rows cleared");
    textprintf_ex(buffer, diamond_font, 450, 100, makecol(255, 255, 255), -1, "Score");
    textprintf_ex(buffer, diamond_font, 450, 200, makecol(255, 255, 255), -1, "Level");
    textprintf_ex(buffer, diamond_font, 450, 300, makecol(255, 255, 255), -1, "Rows cleared");

    blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);

// initialise tiles on field
    int j;
    for (j=0; j<COLS; j++)    
        for (n=0; n<ROWS; n++) 
            field[j][n] = NOTILE;
    

// timer initialisations for falling bloxxi
    fall_countdown = fall_timer[0];
    
    game_over = 0;
    score = 0;
    level = 0;
    rows_cleared = 0;
    scoring(0);
}


///////////////////////////////////////////////////////////////////////////////

void lose_game()    {
    game_over = 1;
    if (score >= hiscore[9].score)    {
        play_sample(cheer_sound, VOL, PAN, FREQ, 0);
        new_hiscore();
        display_hiscore();
    } else {        
        play_sample(boo_sound, VOL, PAN, FREQ, 0);
        rectfill(buffer, 130, 200, 650,  270, makecol(0,0,255));
        rect(buffer, 130, 200, 650,  270, makecol(255,255,255));
        rect(buffer, 129, 199, 651,  271, makecol(255,255,255));
        rect(buffer, 128, 198, 652,  272, makecol(255,255,255));

        textprintf_centre_ex(buffer, diamond_font, 400, 205, makecol(0, 0, 0), makecol(0, 0, 255), "Sorry, game over!");
        textprintf_centre_ex(buffer, diamond_font, 390, 235, makecol(0, 0, 0), makecol(0, 0, 255), "Press ESC to return to the main menu.");
        blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
    }
}


///////////////////////////////////////////////////////////////////////////////

void game_loop()    {
    int one_tick = ticks-1;
    while(!game_over)        {
        if (one_tick != ticks)    {
            getinput();
            if (fall_countdown == 0)    {
                play_sample(select_sound, VOL, PAN, FREQ, 0);
                fall_countdown = fall_timer[level];
                move_bloxxi(DIR_DOWN, 0);  
            } else {
                fall_countdown--;
            }
            one_tick = ticks;
        }
    }
}


///////////////////////////////////////////////////////////////////////////////

void main(void)  {
    int selected_opt;
    setup();
    selected_opt = menu();
    
    while (!key[KEY_ESC] && (selected_opt != SEL_EXIT))    {
        switch (selected_opt)    {
            case SEL_NEWGAME:
                new_game();
                setup_bloxxi(rand() % 7);
                new_bloxxi();
                display_bloxxi(FIELD_AREA);
                display_bloxxi(NEXT_AREA);
                game_loop();
                while (!key[KEY_ESC]);
                break;
            case SEL_HOWTOPLAY:
                display_howtoplay();
                while (!key[KEY_ESC]);
                break;
            case SEL_HISCORE:
                display_hiscore();
                while (!key[KEY_ESC]);
                break;
        }
        selected_opt = menu();
    }        
    
// clean up bitmaps
    destroy_bitmap(buffer);

    for (n=0; n<8; n++)    { 
        destroy_bitmap(tiles_bmp[n]);
    }

// update high scores data    
    score_pack = pack_fopen("score.dat", "wp");
    for (n=0; n<10; n++)    {
        pack_iputl(hiscore[n].score, score_pack);
        pack_putc('|',score_pack); 
        pack_fputs(hiscore[n].name, score_pack);
        pack_putc('|',score_pack);
    }
    pack_fclose(score_pack);

    unload_datafile(data);

    remove_int(add_tick);
        
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    allegro_exit();
    return;
}

END_OF_MAIN();

///////////////////////////////////////////////////////////////////////////////

