/*  8 Types of blox: square, straight, L, J, S, Z, T, BOMB
    BOMB is a single tile that destroys the surrounding 8 tiles
*/


#include <allegro.h>
#include <stdlib.h>
#include "data.h"

///////////////////////////////////////////////////////////////////////////////

#define TILE_SIZE 32

// for menu selection
#define NUM_SELECT 4
#define SEL_NEWGAME 0
#define SEL_HOWTOPLAY 1
#define SEL_HISCORE 2
#define SEL_EXIT 3

// for dealing with time delays between taking action for a key being held down
#define TIME_PER_TICK 20
#define KEYLOCK_TICK1 1
#define KEYLOCK_TICK2 200/TIME_PER_TICK

// labels for display_bloxxi to show tiles at the correct destination
#define FIELD_AREA 0
#define NEXT_AREA 1

// field size (in terms of number of tiles)
#define ROWS 18
#define COLS 11

// starting coordinates for new bloxxis
#define START_X 4
#define START_Y 17

// directional constants for use in bloxxi movement
#define DIR_CLK 1
#define DIR_ACLK -1
#define DIR_LEFT -1
#define DIR_RIGHT 1
#define DIR_DOWN 0

//play field border coordinates
#define BORDER_L 61
#define BORDER_R 412
#define BORDER_U 11
#define BORDER_D 586

// next bloxxi border coordinates
#define BORDER_L_NXT 622
#define BORDER_R_NXT 749
#define BORDER_U_NXT 486
#define BORDER_D_NXT 549

// references to tile image
#define BLUEBLOX 0
#define GREENBLOX 1
#define GREYBLOX 2
#define ORANGEBLOX 3
#define RAINBOWBLOX 4
#define REDBLOX 5
#define VIOLETBLOX 6
#define YELLOWBLOX 7
#define NOTILE 8

// references to bloxxi style
#define SQUARE 0
#define STRAIGHT 1
#define L 2
#define J 3
#define S 4
#define Z 5
#define T 6
#define BOMB 7

// values for sound effects
#define VOL 255
#define PAN 127
#define FREQ 1000

///////////////////////////////////////////////////////////////////////////////

DATAFILE *data;

SAMPLE *select_sound;
SAMPLE *sweep_sound;
SAMPLE *drop_sound;
SAMPLE *explode_sound;
SAMPLE *delete_line_sound;
SAMPLE *lvlup_sound;
SAMPLE *boo_sound;
SAMPLE *cheer_sound;


int field[COLS][ROWS];
int n;
int game_over;

volatile int ticks;
int fall_countdown;
int score;
int level;
int rows_cleared;

// number of rows required to level up
int level_requirement[10] = {0, 10, 15, 20, 30, 45, 65, 80, 90, 100};
// bloxxi drop speed at different levels
int fall_timer[10] = {95, 80, 65, 50, 35, 20, 13, 8, 6, 4};




BITMAP *tiles_bmp[9];
BITMAP *buffer;
BITMAP *blam;
BITMAP *arrow;

typedef struct {
    int x[4];
    int y[4];
    int tile_color;
    int shape;
    int rotation_phase;
} bloxxi_t;

bloxxi_t cur_bloxxi;
bloxxi_t next_bloxxi;


PACKFILE *score_pack;

typedef struct {
    char name[20];
    int score;
}    HISCORE_t;

HISCORE_t hiscore[10];

FONT *stencil_font;
FONT *diamond_font;

///////////////////////////////////////////////////////////////////////////////

// bloxxi.c
void move_bloxxi(int, int);
void clear_bloxxi();
void display_bloxxi(int);
void done_bloxxi();
void new_bloxxi();
void bomb_explode();
int smaller(int, int);
int bigger(int, int);

// setup_rotate.c
void setup_bloxxi(int);
void rotate_bloxxi(int);
void bloxxi_STRAIGHT(int next_phase, int pivotx, int pivoty, int x[4], int y[4]); 
void bloxxi_L(int next_phase, int pivotx, int pivoty, int x[4], int y[4]); 
void bloxxi_J(int next_phase, int pivotx, int pivoty, int x[4], int y[4]); 
void bloxxi_S(int next_phase, int pivotx, int pivoty, int x[4], int y[4]); 
void bloxxi_Z(int next_phase, int pivotx, int pivoty, int x[4], int y[4]); 
void bloxxi_T(int next_phase, int pivotx, int pivoty, int x[4], int y[4]); 
void setup_SQUARE(int x[4], int y[4]);
void setup_BOMB(int x[4], int y[4]);

// misc.c
int collision(int x[4], int y[4]);
void delete_lines();
int unchecked_vline(int);
int full_hline(int);
void change_coords(int x[4], int y[4], bloxxi_t *the_bloxxi);
int inv_x_nxt(int);
int inv_y_nxt(int);
int inv_x_coord(int);
int inv_y_coord(int);
void arrange(int x[4]);
void shift_bloxxi(int rows_to_delete[4], int);
void scoring(int);

// menu.c
int menu();
void setup_splash();
void bounce_arrow(int);
void redraw_text(int);

// other_screens.c
void new_hiscore();
void display_hiscore();
void display_howtoplay();
void blinking_ESC();

// main.c
void add_tick();
void getinput();
void setup();
void new_game();
void lose_game();
void game_loop();
void main(void);


