///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
//  functions included in this file:
//  void move_bloxxi(int, int);
//  void clear_bloxxi();
//  void display_bloxxi(int);
//  void done_bloxxi();
//  void new_bloxxi();
//  void bomb_explode();
//  int smaller(int, int);
//  int bigger(int, int);
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

void move_bloxxi(int dir, int hyperdrop)  {
    int x[4], y[4];
    
    for (n=0; n<4; n++) {
        x[n] = cur_bloxxi.x[n] + dir;
        y[n] = cur_bloxxi.y[n] - (!dir);        
    }
    
    clear_bloxxi();
                
    if (!collision(x, y))    {
        change_coords(x,y, &cur_bloxxi);
        if (hyperdrop)        {
            move_bloxxi(0, 1);
        } 
    } else {
        if (dir == DIR_DOWN) {
            display_bloxxi(FIELD_AREA);
            done_bloxxi();
            if (collision(next_bloxxi.x, next_bloxxi.y)) {
                lose_game(); }
            else   {
                new_bloxxi();
                setup_bloxxi(rand() % 8);
                rectfill(buffer, BORDER_L_NXT, BORDER_U_NXT, BORDER_R_NXT, 
                    BORDER_D_NXT, makecol(0,0,0));
                display_bloxxi(NEXT_AREA);
            }
        }
    }
    if (!game_over)
    display_bloxxi(FIELD_AREA);
}


///////////////////////////////////////////////////////////////////////////////

void clear_bloxxi()    {
    int inv_x, inv_y;
    for (n=0; n<4; n++) {
        inv_x = inv_x_coord(cur_bloxxi.x[n]);
        inv_y = inv_y_coord(cur_bloxxi.y[n]);
        rectfill(buffer, inv_x,  inv_y, inv_x+TILE_SIZE-1, inv_y+TILE_SIZE-1, makecol(0,0,0));
    }
}


///////////////////////////////////////////////////////////////////////////////

void display_bloxxi(int dest)    {
    int x, y, tile_color;

    for (n=0; n<4; n++) {
        if (dest == FIELD_AREA) {
            x = inv_x_coord(cur_bloxxi.x[n]);
            y = inv_y_coord(cur_bloxxi.y[n]);
            tile_color = cur_bloxxi.tile_color;
        } else if (dest == NEXT_AREA) {
            x = inv_x_nxt(next_bloxxi.x[n]);
            y = inv_y_nxt(next_bloxxi.y[n]);     
            tile_color = next_bloxxi.tile_color;  
        }
        blit(tiles_bmp[tile_color], buffer, 0, 0, x, y, TILE_SIZE, TILE_SIZE);
    }

    blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
}


///////////////////////////////////////////////////////////////////////////////

void done_bloxxi()  {
    static int temp = 0;
    for (n=0; n<4; n++) {
        field[cur_bloxxi.x[n]][cur_bloxxi.y[n]] = cur_bloxxi.tile_color;
    }
    if (cur_bloxxi.shape != BOMB)    {
        play_sample(drop_sound, VOL, PAN, FREQ, 0);
        delete_lines();
    } else {
        play_sample(explode_sound, VOL, PAN, FREQ, 0);
        bomb_explode();
    }
}

///////////////////////////////////////////////////////////////////////////////

void new_bloxxi()  {
    for (n=0; n<4; n++) {
        cur_bloxxi.x[n] = next_bloxxi.x[n];
        cur_bloxxi.y[n] = next_bloxxi.y[n];
    }
    cur_bloxxi.rotation_phase = next_bloxxi.rotation_phase;
    cur_bloxxi.shape = next_bloxxi.shape;
    cur_bloxxi.tile_color = next_bloxxi.tile_color;
}


///////////////////////////////////////////////////////////////////////////////

void bomb_explode() {
    int x = cur_bloxxi.x[0];
    int y = cur_bloxxi.y[0];
    int inv_x, inv_y, j;
    
    for (n=bigger(x-1, 0); n<=smaller(x+1, COLS-1); n++)    {
        for(j=bigger(y-1, 0); j<=smaller(y+1, ROWS-1); j++)    {
            inv_x = inv_x_coord(n);
            inv_y = inv_y_coord(j);
            field[n][j] = NOTILE;
            rectfill(buffer, inv_x,  inv_y, inv_x+TILE_SIZE-1, inv_y+TILE_SIZE-1, makecol(0,0,0));
        }
    }
    blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
    stretch_sprite(screen, blam, inv_x_coord(x)+TILE_SIZE/2-blam->w/6, 
        inv_y_coord(y)+TILE_SIZE/2-blam->h/6, blam->w/3, blam->h/3);
    rest(25);
    stretch_sprite(screen, blam, inv_x_coord(x)+TILE_SIZE/2-blam->w/3, 
        inv_y_coord(y)+TILE_SIZE/2-blam->h/3, blam->w*2/3, blam->h*2/3);
    rest(25);
    stretch_sprite(screen, blam, inv_x_coord(x)+TILE_SIZE/2-blam->w/2, 
        inv_y_coord(y)+TILE_SIZE/2-blam->h/2, blam->w, blam->h);
    rest(100);        
}    


///////////////////////////////////////////////////////////////////////////////

int smaller(int a, int b)  {
    if (a < b)
        return a;
    else 
        return b;
}


///////////////////////////////////////////////////////////////////////////////

int bigger(int a, int b)  {
    if (a > b)
        return a;
    else 
        return b;
}
