
#ifndef CNUMBER_H_INCLUDED
#define CNUMBER_H_INCLUDED

#include <allegro.h>
#include <vector>
#include "CMainObject.h"

 
class CNumber : public CMainObject
{
    public:
        CNumber();
        virtual ~CNumber();

        virtual void InitRes(DATAFILE * dat) {};

        void SetPos(int x, int y);
        BITMAP* SetBitmap(int number, BITMAP* bitmap);

        inline void SetAxis(int axis) {m_axis = axis;};

        inline void Value(int value) { m_to_value = m_value = value % m_modulo; };
        inline int  Value(void     ) { return m_value;                          };
        
        void NextValue(int nextvalue);
        inline int  NextValue(void         ) { return m_to_value;                 };
        
        inline void Modulo(int modulo) {m_modulo = modulo;};
        inline int  Modulo(void)       {return m_modulo;  };

        inline void Glyphs(int num_glyphs) {m_glyphs = num_glyphs;};
        inline int  Glyphs(void)           {return m_glyphs;  };

        inline void GlyphRollDelay(int delay_frames) {m_glyph_roll_delay = delay_frames;};
        inline int  GlyphRollDelay(void)             {return m_glyph_roll_delay;};

        virtual void Update(void);
        virtual void Draw(BITMAP* dest);
        
        inline bool IsFlipping(void) {return m_state != STABLE;};
        inline bool IsStable(void)   {return m_state == STABLE;};
        
        void RollToGlyph (int glyph_number, int overrolls);
        void RollToNumber(int number,       int overrolls);
        
    private:
        static const int NUMBERS      = 10;          // Count of numbers 0..9
        static const int GLYPHS       = 9;           // Count of glyphs
        static const int GLYPHS_START = 10;          // Index of first glyph
           
        enum e_state
        {
            STABLE = 0,
            FLIP_NEXT,
            FLIPPING_UPPER,
            FLIPPING_LOWER,
            FLIP_DELAYED
        };
        int m_state;
        
        enum e_mode
        {
            NORMAL = 0,               // count numbers only
            ROLL_TO_GLYPH,            // roll to a specific glyph (with overrolling glyphs)
            ROLL_TO_NUMBER            // roll to a specific number (with overrolling numbers)
        };
        int m_mode;
        
        int m_overroll_count;         // count of overrolls
        int m_glyph_roll_delay;       // delay to roll to gyph
        int m_glyph_roll_delay_cnt;   // delay counter
        int m_roll_to;                // Destination of a roll
        

        std::vector<BITMAP*> m_bitmaps;
        int m_x;
        int m_y;
        int m_modulo;
        int m_glyphs;
        int m_axis;
        int m_value;
        int m_next_number;
        int m_to_value;
        float m_flip_speed;
        float m_flip_pos;
};

#endif
