#ifndef CMAINSCREEN_H_INCLUDED
#define CMAINSCREEN_H_INCLUDED

#include "CMainObject.h"
#include "allegro.h"
#include "CTerminal.h"
#include "CCounter.h"
#include "CKeylock.h"


class CMainScreen : public CMainObject
{
    public:
        CMainScreen();
        virtual ~CMainScreen();
        
        virtual void InitRes(DATAFILE * dat);
        virtual void Update(void);
        virtual void Draw(BITMAP* dest);
        virtual void Reset(void);
    protected:
        enum e_state
        {
            STATE_STARTUP = 0,
            STATE_DELAY,
            STATE_LOOP,
            STATE_REWIND,
            STATE_REWINDING_,
            STATE_RESTART_COUNTER,
            STATE_EXIT_MESSAGE,
            STATE_COUNTER_EXPIRED,
            STATE_COUNTER_EXPIRED_LOOP,
            STATE_TYPING_EXPIRED,
            STATE_TYPING_NEW_CHANCE,
            STATE_FINISHED
        };
        e_state m_state;

        void InitInstance(void);
        void ProcessTerminalInput_Loop(void);
        void ProcessTerminalInput_Expired(void);
        void ProcessSetCmd(std::stringstream &input);
        
        void Delay(e_state state, int ticks);
        int m_delay_count;
        e_state m_delayed_state;
        
        CTerminal * m_terminal;
        CCounter  * m_lost_counter;
        CKeylock  * m_keylock;
        
        SAMPLE* m_snd_end;

        bool IsCode(const std::string & s);            
        
};


#endif
