
#ifndef CCOUNTER_H_INCLUDED
#define CCOUNTER_H_INCLUDED

#include "CMainObject.h"
#include <allegro.h>
#include <vector>
#include "CNumber.h"
 
class CCounter : public CMainObject
{
    public:
        CCounter();
        virtual ~CCounter();
        
        void SetPos(int x, int y);
        virtual void InitRes(DATAFILE * dat);

        void Value(int value, bool with_flip = true);
        inline int  Value(void) { return m_value;       };
        
        int GetH(void);
        int GetW(void);
        
        int GetX(void) {return m_x;};
        int GetY(void) {return m_y;};

        void Start(void);
        void Stop(void);
        
        void Crush(void);
        void DeCrush(void);
        
        inline void FadeSoundOut(void) {BadsoundDawn();};

        void Rewind(int to_value);
        void RollToGlyphs(int glyphs);

        
        virtual void Update(void);
        virtual void Draw(BITMAP* dest);
        
        inline bool IsStopped(void)   { return m_state == STOPPED;   };
        inline bool IsCounting(void)  { return m_state == COUNTING;  };
        inline bool IsRewinding(void) { return (m_state == ROLLING) || m_rewind_requested;   };
        inline bool IsCrushing(void)  { return m_state == CRUSHING;  };
        inline bool IsCrushed(void)   { return m_state == CRUSHED;   };
        
        inline bool IsExpired(void)   { return m_expired;            };

    private:
        static const int COUNTER_CRUSHED_PICS = 24;
        static const int COUNTER_CRUSHED_FRAMES_PER_PIC = 5;

        static const int numbers_datafile_objects[5/*Digit, 0 = lowest*/][19/*Number 0 to 9 and glyph 1 to 9*/];
        static const int numbers_glyph_overrolls[5]; // Number of overrolls when rolling to glyphs for each digit
        static const int m_glyph_roll_delay[5];

        static const int counter_crushed[COUNTER_CRUSHED_PICS];
        
        
        enum e_state
        {
            STOPPED = 0,
            COUNTING,
            ROLLING,
            CRUSHING,
            CRUSHED,
            DECRUSHING,
        };
        int m_state;

        
        CNumber m_number[5];
        
        int m_x;
        int m_y;
        int m_value;
        int m_to_value;
        int m_updates_per_second;
        int m_update_counter;
        int m_snd_did_delay;
        bool m_expired;
        
        int m_crushed_pic;
        bool m_rewind_requested;
        
        BITMAP * m_chassis;
        BITMAP * m_pic_crushed[COUNTER_CRUSHED_PICS];
        SAMPLE * m_snd_tick;
        SAMPLE * m_snd_did;
        SAMPLE * m_snd_alert;
        SAMPLE * m_snd_rewind;
        SAMPLE * m_snd_rewind_end;
        SAMPLE * m_snd_bad_sound;
        
        enum e_badsound_state
        {
            BADSOUND_OFF = 0,
            BADSOUND_RISING,
            BADSOUND_FULLSPEED,
            BADSOUND_DAWNING
        } m_badsound_state;
        float m_bad_sound_speed;

        void BadsoundRaise(void);
        void BadsoundDawn(void);
        void BadsoundUpdate(void);
        
        bool ValueToNumbers(int value, bool with_flip = true);
        void GlyphsToNumbers(int glyphs);
        void SetNumberPositions(int x, int y);
        void Tick(void);
        void SplitValueToDigits(int value, int digits[5]);
};

#endif
