// CApplication.h


#ifndef CAPPLICATION_H_INCLUDED
#define CAPPLICATION_H_INCLUDED

#include "CMainObject.h"

#include <allegro.h>
#include <string>

class CApplication
{
    public:
        static const int TICKS_PER_SECOND = 60;
        static const int TERMINAL_STR_MAX_LEN = 30;
        static const int ESC_KEY_THRESHOLD = TICKS_PER_SECOND * 2; // two seconds to exit application
        
        static void SoundEnabled(bool enabled);
        static bool SoundEnabled(void);
        
        static void TickSecondsEnabled(bool enabled);
        static bool TickSecondsEnabled(void);

        static void DigiVolume(int volume);
        static int  DigiVolume(void);

        static void MidiVolume(int volume);
        static int  MidiVolume(void);

        static void CheatsEnabled(bool enabled);
        static bool CheatsEnabled(void);


        CApplication();
        virtual ~CApplication();
        
        void Run(void);
    
    protected:
        static void UpdateVolume(void);

        static bool sound_enabled;
        static bool cheats_enabled;
        static bool tick_seconds_enabled;
        static int  sound_digi_volume;
        static int  sound_midi_volume;

        void InitInstance(void);
        void StartTicker(void);
        void StopTicker(void);
        
        void Draw(void);
        
        bool FadeIn(void);
        bool FadeOut(void);
        
        static int m_ticker;

    private:
        enum e_mainstate
        {
            STATE_STARTUP = 0,
            STATE_ENTER_MODE,
            STATE_FADE_MODE_IN,
            STATE_MODE_LOOP,
            STATE_FADE_MODE_OUT,
            STATE_FINISHED
            
        } m_mainstate;

        enum e_mode
        {
            MODE_INTRO = 0,
            MODE_TITLE,
            MODE_MAINSCREEN,
            MODE_CREDITS
        } m_mode;

        enum e_screenshot_state
        {
            SCREENSHOT_IDLE = 0,
            SCREENSHOT_TAKE,
            SCREENSHOT_TAKEN
        } m_screenshot;

        static void Ticker(void);
        void SaveScreenshot(BITMAP * src);

        bool m_f1_key_down;
        bool m_finished;
        int m_fade_value;
        int m_counter;
        int m_esc_key_counter;
        BITMAP * m_buffer;
        BITMAP * m_fade_buffer;
        DATAFILE * m_datafile;
        
        CMainObject* m_main_object;
};



#endif
