#include <stdlib.h>
#include <time.h>
#include <allegro.h>
#include <fblend.h>

#include <string>

#include "AreYouLost_private.h"

#include "CMyException.hpp"
#include "CApplication.h"
#include "Datafile_objects.h"

#include "Logfile.hpp"


using namespace std;




int main(int argc, char *argv[])
{
	srand( (unsigned)time( NULL ) );

    CApplication* app = NULL;
    
    for(int i = 1; i < argc; i++)
    {
        if(strcmp(argv[i], "cheat") == 0)
        {
            CApplication::CheatsEnabled(true);
        }
        if(strcmp(argv[i], "mute") == 0)
        {
            CApplication::SoundEnabled(false);
        }
        if(strcmp(argv[i], "tick_seconds") == 0)
        {
            CApplication::TickSecondsEnabled(true);
        }
    }
    
    try
    {
        try
        {
            Logfile = new CLogfile("Logfile.txt");
        }
        catch(...)
        {
            Logfile = NULL;
        }
        MYASSERTVALIDMSG(Logfile, "Failed creating Logfile object.");
        
        Logfile->Message(PRODUCT_NAME " V" VER_STRING);
        if(CApplication::CheatsEnabled())
        {
            Logfile->Message("cheat enabled");
        }
        Logfile->Message("compiled: " __DATE__ " " __TIME__);
        Logfile->Message("allegro : " ALLEGRO_VERSION_STR);
        Logfile->Message("fblend  : " FBLEND_VERSION_STRING);
        
        Logfile->LogCPUCaps();

        try
        {
            app = new CApplication;
        }
        catch(...)
        {
            app = NULL;
        }
        MYASSERTVALIDMSG(app, "Failed creating Application object.");
        app->Run();
    }
    catch(std::exception e)
    {
        if(Logfile) 
        {
            Logfile->Message("Application aborted with Exception!");
            Logfile->Message(e.what());
        }
        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
        allegro_message("Exception detected.\n%s", e.what());
    }
    catch(std::string s)
    {
        if(Logfile) 
        {
            Logfile->Message("Application aborted with String-Exception!");
            Logfile->Message(s.c_str());
        }
        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
        allegro_message("Exception detected.\n%s", s.c_str());
    }
    catch(...)
    {
        if(Logfile) 
        {
            Logfile->Message("Application aborted with unknown Exception!");
        }
        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
        allegro_message("Unknown exception detected.%s");
    }
    
    if(app) delete app;
    app = NULL;

    if(Logfile) delete Logfile;
    Logfile = NULL;

	return 0;
}
END_OF_MAIN()




