#ifndef CLOGFILE
#define CLOGFILE

#include <stdio.h>
#include <string>

// define LOGFILE_CONSOLE_OUT for output to the console window too

class CLogfile
{
    public:
        CLogfile(const std::string &logfilename, bool append = false);
        CLogfile();
        virtual ~CLogfile();
        void Message(const std::string &message);
        void Message(const char * message);
        void SetFilename(const std::string &newname, bool append);
        void printf(const char * format, ...);

        void LogCPUCaps(void);
        void LogDisplayCaps(void);
        void LogDisplayMode(void);
    private:
        std::string filename;
        void WriteHeader(void);
};            

extern CLogfile * Logfile;

#endif
