
#include "Logfile.hpp"
#include "allegro.h"
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <STDARG.H>

#ifdef LOGFILE_CONSOLE_OUT
#include <iostream>
#endif

using namespace std;

CLogfile * Logfile = NULL;

CLogfile::~CLogfile()
{
    time_t now;
    time(&now);
    if (filename.size())
    {
        Message("----------------------------------------");
        Message("Finishing log.");
        Message(ctime(&now));
        filename = "";
    }    
}    

void CLogfile::SetFilename(const string &newname, bool append)
{
    filename = newname;
    if ((!append) || !exists(filename.c_str())) WriteHeader();
}    

CLogfile::CLogfile(const string &logfilename, bool append)
{
    SetFilename(logfilename, append);
}   

void CLogfile::WriteHeader(void)
{
    time_t now;
    if (filename.empty()) return;
    FILE * logfile = fopen(filename.c_str(), "wt");  // Datei neu anlegen
    if (NULL == logfile) return;
    time(&now);
    for (int i = 0; i < 40; i++) fputc('-', logfile);
    fprintf(logfile, "\nLogfile: %s\n", filename.c_str());
    fprintf(logfile,   "Created: %s", ctime(&now));
    for (int i = 0; i < 40; i++) fputc('-', logfile);
    fputc('\n', logfile);
    fclose(logfile);
}    


CLogfile::CLogfile()
{
    filename = "";
}   
 
void CLogfile::Message(const string &message)
{
    if (filename.empty()) return;
    FILE * logfile = fopen(filename.c_str(), "at+");  // an Datei anhngen
    if (NULL == logfile) return;
    fprintf(logfile, "%s\n", message.c_str());
    fclose(logfile);
    #ifdef LOGFILE_CONSOLE_OUT
    cout << message << endl;
    #endif
}    

void CLogfile::Message(const char * message)
{
    if (filename.empty()) return;
    FILE * logfile = fopen(filename.c_str(), "at+");  // an Datei anhngen
    if (NULL == logfile) return;
    fprintf(logfile, "%s\n", message);
    fclose(logfile);
    #ifdef LOGFILE_CONSOLE_OUT
    cout << message << endl;
    #endif
}    

void CLogfile::printf(const char * format, ...)
{
    if (filename.empty()) return;
    FILE * logfile = fopen(filename.c_str(), "at+");  // an Datei anhngen
    if (NULL == logfile) return;
    va_list arg;
    va_start(arg, format);
    vfprintf (logfile, format, arg);
    #ifdef LOGFILE_CONSOLE_OUT
    vprintf (format, arg);
    #endif
    va_end(arg);
    fputc('\n', logfile);
    fclose(logfile);
    #ifdef LOGFILE_CONSOLE_OUT
    cout << endl;
    #endif
}    

void CLogfile::LogCPUCaps(void)
{
    check_cpu();    // If allegro is not allready initialized
    Message("--------------- CPU info ---------------");
    printf("Vendor : %s", cpu_vendor);
    
    char * txt = "unknown";
    switch(cpu_family)
    {
        case CPU_FAMILY_I386    :
            txt = "CPU_FAMILY_I386";
            break;
        case CPU_FAMILY_I486    :
            txt = "CPU_FAMILY_I486";
            break;
        case CPU_FAMILY_I586    :
            txt = "CPU_FAMILY_I586";
            break;
        case CPU_FAMILY_I686    :
            txt = "CPU_FAMILY_I686";
            break;
        case CPU_FAMILY_ITANIUM :
            txt = "CPU_FAMILY_ITANIUM";
            break;
        case CPU_FAMILY_POWERPC :
            txt = "CPU_FAMILY_POWERPC";
            break;
        case CPU_FAMILY_EXTENDED:
            txt = "CPU_FAMILY_EXTENDED";
            break;
    }
    printf("Family : %s", txt);
    printf("Model  : %d", cpu_model);

    struct
    {
        int flag;
        const char * txt;
    } capabilities[] = 
    {
        {CPU_ID,        "CPU_ID"},
        {CPU_FPU,       "CPU_FPU"},
        {CPU_IA64,      "CPU_IA64"},
        {CPU_AMD64,     "CPU_AMD64"},
        {CPU_MMX,       "CPU_MMX"},
        {CPU_MMXPLUS,   "CPU_MMXPLUS"},
        {CPU_SSE,       "CPU_SSE"},
        {CPU_SSE2,      "CPU_SSE2"},
        {CPU_SSE3,      "CPU_SSE3"},
        {CPU_3DNOW,     "CPU_3DNOW"},
        {CPU_ENH3DNOW,  "CPU_ENH3DNOW"},
        {CPU_CMOV,      "CPU_CMOV"},
        {0,             NULL}
    };
    printf("Caps   : 0x%04X", cpu_capabilities);
//    if(cpu_capabilities & CPU_ID)       Message("- CPU_ID");
//    if(cpu_capabilities & CPU_FPU)      Message("- CPU_FPU");
//    if(cpu_capabilities & CPU_IA64)     Message("- CPU_IA64");
//    if(cpu_capabilities & CPU_AMD64)    Message("- CPU_AMD64");
//    if(cpu_capabilities & CPU_MMX)      Message("- CPU_MMX");
//    if(cpu_capabilities & CPU_MMXPLUS)  Message("- CPU_MMXPLUS");
//    if(cpu_capabilities & CPU_SSE)      Message("- CPU_SSE");
//    if(cpu_capabilities & CPU_SSE2)     Message("- CPU_SSE2");
//    if(cpu_capabilities & CPU_SSE3)     Message("- CPU_SSE3");
//    if(cpu_capabilities & CPU_3DNOW)    Message("- CPU_3DNOW");
//    if(cpu_capabilities & CPU_ENH3DNOW) Message("- CPU_ENH3DNOW");
//    if(cpu_capabilities & CPU_CMOV)     Message("- CPU_CMOV");
    int i = 0;
    while(capabilities[i].txt)
    {
        if (cpu_capabilities & capabilities[i].flag)
        {
            printf("-%s", capabilities[i].txt);
        }    
        i++;
    }    
    Message("----------------------------------------");
}

void CLogfile::LogDisplayCaps(void)
{
    struct
    {
        int flag;
        const char * txt;
    } capabilities[] = 
    {
        {GFX_CAN_SCROLL,                   "GFX_CAN_SCROLL"                  },
        {GFX_CAN_TRIPLE_BUFFER,            "GFX_CAN_TRIPLE_BUFFER"           },
        {GFX_HW_CURSOR,                    "GFX_HW_CURSOR"                   },
        {GFX_SYSTEM_CURSOR,                "GFX_SYSTEM_CURSOR"               },
        {GFX_HW_HLINE,                     "GFX_HW_HLINE"                    },
        {GFX_HW_HLINE_XOR,                 "GFX_HW_HLINE_XOR"                },
        {GFX_HW_HLINE_SOLID_PATTERN,       "GFX_HW_HLINE_SOLID_PATTERN"      },
        {GFX_HW_HLINE_COPY_PATTERN,        "GFX_HW_HLINE_COPY_PATTERN"       },
        {GFX_HW_FILL,                      "GFX_HW_FILL"                     },
        {GFX_HW_FILL_XOR,                  "GFX_HW_FILL_XOR"                 },
        {GFX_HW_FILL_SOLID_PATTERN,        "GFX_HW_FILL_SOLID_PATTERN"       },
        {GFX_HW_FILL_COPY_PATTERN,         "GFX_HW_FILL_COPY_PATTERN"        },
        {GFX_HW_LINE,                      "GFX_HW_LINE"                     },
        {GFX_HW_LINE_XOR,                  "GFX_HW_LINE_XOR"                 },
        {GFX_HW_TRIANGLE,                  "GFX_HW_TRIANGLE"                 },
        {GFX_HW_TRIANGLE_XOR,              "GFX_HW_TRIANGLE_XOR"             },
        {GFX_HW_GLYPH,                     "GFX_HW_GLYPH"                    },
        {GFX_HW_VRAM_BLIT,                 "GFX_HW_VRAM_BLIT"                },
        {GFX_HW_VRAM_BLIT_MASKED,          "GFX_HW_VRAM_BLIT_MASKED"         },
        {GFX_HW_MEM_BLIT,                  "GFX_HW_MEM_BLIT"                 },
        {GFX_HW_MEM_BLIT_MASKED,           "GFX_HW_MEM_BLIT_MASKED"          },
        {GFX_HW_SYS_TO_VRAM_BLIT,          "GFX_HW_SYS_TO_VRAM_BLIT"         },
        {GFX_HW_SYS_TO_VRAM_BLIT_MASKED,   "GFX_HW_SYS_TO_VRAM_BLIT_MASKED"  },
        {0,                                NULL                              }
    };
        

    Message("--------- Display capabilities ---------");
    printf("gfx_capabilities: 0x%08X:", gfx_capabilities);
    int i = 0;
    while(capabilities[i].txt)
    {
        if (gfx_capabilities & capabilities[i].flag)
        {
            printf("-%-31s: available", capabilities[i].txt);
        }    
        else
        {
            printf("-%-31s: -", capabilities[i].txt);
        }    
        i++;
    }    
    Message("----------------------------------------");
}

void CLogfile::LogDisplayMode(void)
{
    Message("------------- Display mode -------------");
    printf("mode : %s", is_windowed_mode() ? "windowed" : "fullscreen");
    printf("size : %dx%d", screen->w, screen->h);
    printf("depth: %dbit", get_color_depth());
    printf("rate : %dHz", get_refresh_rate());
    Message("----------------------------------------");
}


