#include "CTitle.h"
#include "Datafile_objects.h"

#include "Logfile.hpp"

#include "allegro.h"
#include <string>

void CTitle::InitInstance(void)
{
    m_state = STARTUP;
    m_bmp_dharma = NULL;
    m_bmp_candle = NULL;
    m_dharma_size = 1.0f;
    m_terminal = NULL;
    m_intro_txt = NULL;
}

CTitle::CTitle()
{
    InitInstance();
}

CTitle::~CTitle()
{
    if (m_terminal) delete m_terminal;
    m_terminal = NULL;
}
        
void CTitle::InitRes(DATAFILE * dat)
{
    if(dat == NULL)
    {
        m_bmp_dharma = NULL;
        m_bmp_candle = NULL;
        m_intro_txt = NULL;
    }
    else
    {
        if((m_bmp_dharma = (BITMAP*)dat[DAT_DHARMA_LOGO].dat) == NULL)
        {
            // Object not set!
            throw(std::string("Datafile Error! Bitmap for dharma is NULL."));
        }
        if((m_bmp_candle = (BITMAP*)dat[DAT_CANDLE].dat) == NULL)
        {
            // Object not set!
            throw(std::string("Datafile Error! Bitmap for Candle is NULL."));
        }
        if((m_intro_txt = (char*)dat[DAT_TXT_INTRO].dat) == NULL)
        {
            // Object not set!
            throw(std::string("Datafile Error! Pointer for intro text is NULL."));
        }
    }
}

void CTitle::Reset(void)
{
    m_state = STARTUP;
    m_counter = 0;
    m_dharma_size = 1.0f;
    m_finished = false;
}

void CTitle::Update(void)
{
    if(key[KEY_SPACE]) m_finished = true;
    switch(m_state)
    {
        case STARTUP:
            m_counter++;
            if(m_counter >= 60) m_state = ZOOM_DHARMA_OUT;
            break;
        case ZOOM_DHARMA_OUT:
            m_dharma_size -= (0.3f / 60.0f);
            if(m_dharma_size <= 0.625f) 
            {
                m_dharma_size = 0.625f;
                m_state = TERMINAL_MESSAGE;
                m_terminal = new CTerminal();
                int y = (int)((float)m_bmp_dharma->h * m_dharma_size);
                m_terminal->Pos(m_bmp_candle->w, y);
                m_terminal->Size(screen->w - m_bmp_candle->w -1, screen->h - y);
                m_terminal->Type(m_intro_txt);
            }
            break;
        case TERMINAL_MESSAGE:
            if(m_terminal)
            {
                m_terminal->Update();
                if(m_terminal->IsFinished()) 
                {
                    m_finished = true;
                    m_state = FINISHED;
                }
            }
            break;
        case FINISHED:
            break;        
    }
}

void CTitle::Draw(BITMAP* dest)
{
    int dw = (int)((float)m_bmp_dharma->w * m_dharma_size);
    int dh = (int)((float)m_bmp_dharma->h * m_dharma_size);

    stretch_blit(m_bmp_dharma, 
                 dest, 
                 0, 
                 0, 
                 m_bmp_dharma->w, 
                 m_bmp_dharma->h, 
                 (dest->w - dw)/2, 
                 0, 
                 dw, 
                 dh);
    
    if(m_state == TERMINAL_MESSAGE || m_state == FINISHED)
    {
        draw_sprite(dest, m_bmp_candle, 0, dest->h - m_bmp_candle->h);
    }
    
    if(m_terminal)
    {
        m_terminal->Draw(dest);
    }
}

