#ifndef CTERMINAL_H_INCLUDED
#define CTERMINAL_H_INCLUDED

#include "allegro.h"

#include <string>
#include <sstream>
#include <vector>

#include "CMainObject.h"
#include "CRectObject.h"



class CTerminal : public CMainObject, public CRectObject
{
    public:
        CTerminal();
        virtual ~CTerminal();
        
        virtual void InitRes(DATAFILE * dat);
        virtual void Update(void);
        virtual void Draw(BITMAP* dest);
        
        void Input(void);
        void Clear(void);
        void Type(const std::string &str, bool input_after_typing = false);
        void Repeat(const std::string &str, int count = -1, bool input_after_typing = false);
        void Stop(void);

        std::string InputString(void);
        void InputString(const std::string &str);
        
        std::string TypeString(void)                    {return m_type_stream.str();};
        int  TypeDelayTicks(void)                       {return m_type_delay_ticks;};        
        void TypeDelayTicks(int ticks)                  {m_type_delay_ticks = ticks; };        

        int  StringMaxLen(void)                         {return m_str_max_length;};        
        void StringMaxLen(int len)                      {m_str_max_length = len; };        
        
        bool WordWrap(void)                             {return m_wordwrap;};
        void WordWrap(bool wordwrap)                    {m_wordwrap = wordwrap;};

        void NewLine(void);

    private:
        enum e_state
        {
            STATE_IDLE = 0,
            STATE_DELAY,
            STATE_TYPING,
            STATE_REPEATING,
            STATE_INPUT
        };
        int m_state; 
        
    protected:
        virtual void Size_Changed(void);
        void UpdateInput(void);
        void UpdateTyping(void);

        void Delay(int state, int ticks);
        int m_delay_count;
        int m_delayed_state;
        
        int m_cursor_count;
        int m_cursor_on_ticks;
        int m_cursor_off_ticks;
        bool m_cursor_on;
        bool m_wordwrap;
        bool m_input_after_typing;
        
        void ResizeStringArray(void);
        void ScrollStringArray(void);
        
        int NextWordLength(void);
        
        std::stringstream m_type_stream;
        int m_type_delay_ticks_std;
        int m_type_delay_ticks;
        int m_repeat_count;
        
        std::string * m_pinput_str;
        std::string m_prompt_str;
        
        std::vector<std::string*> m_strings;
        int m_string_count;
        int m_akt_string;
        int m_first_string_y;
        int m_string_x;
        
        int m_str_max_length;
        int m_border_dist;
        

        

};

#endif
