#include "CNumber.h"
#include <stdlib.h>
#include <math.h>

#include "Logfile.hpp"

CNumber::CNumber()
{
    m_bitmaps.resize(NUMBERS + GLYPHS);
    for (int i = 0 ; i < NUMBERS + GLYPHS ;  i++) m_bitmaps[i] = NULL;
    m_x = 0;
    m_y = 0;
    m_next_number = m_to_value = m_value = 0;
    m_modulo = 10;
    m_glyphs = 9;
    m_axis = 36;
    m_state = STABLE;
    m_mode = NORMAL;
    m_overroll_count = 0;
    m_glyph_roll_delay_cnt = 0;
    m_glyph_roll_delay = 0;
    //m_flip_speed = M_PI / (float)(15 + (rand()%11));
    //m_flip_speed = M_PI / (float)(10 + (rand()%5));
    m_flip_speed = M_PI / (float)(8 + (rand()%3)*2);
    m_flip_pos = 0.0f;
}

CNumber::~CNumber()
{
}

void CNumber::SetPos(int x, int y)
{
    m_x = x;
    m_y = y;
}

BITMAP* CNumber::SetBitmap(int number, BITMAP* bitmap)
{
    number %= (NUMBERS + GLYPHS);
    m_bitmaps[number] = bitmap;
    return m_bitmaps[number];
}

void CNumber::RollToGlyph (int glyph_number, int overrolls)
{
    m_mode = ROLL_TO_GLYPH;
    m_overroll_count = overrolls;
    glyph_number %= GLYPHS;
    m_to_value = GLYPHS_START + glyph_number;
    m_finished = false;
    m_glyph_roll_delay_cnt = m_glyph_roll_delay;
    if(m_glyph_roll_delay_cnt)
    {
        m_state = FLIP_DELAYED;
    }
    else
    {
        m_state = FLIP_NEXT;
    }
}

void CNumber::RollToNumber(int number,       int overrolls)
{
    m_mode = ROLL_TO_NUMBER;
    m_overroll_count = overrolls;
    m_to_value = number % m_modulo;
    m_finished = false;
    m_state = FLIP_NEXT;
}


void CNumber::NextValue(int nextvalue) 
{
    if(m_value != nextvalue)
    {
        m_mode = NORMAL;
        m_to_value = nextvalue % m_modulo;
        m_finished = false;
    }
    else
    {
        m_finished = true;
    }
    
};

void CNumber::Update(void)
{
    switch(m_state)
    {
        case FLIP_DELAYED:
            if(m_glyph_roll_delay_cnt)
            {
                m_glyph_roll_delay_cnt--;
            }
            else
            {
                m_state = FLIP_NEXT;
            }
            break;
        case STABLE:
            if(m_value == m_to_value) break;
            // fall through
        case FLIP_NEXT:
            switch(m_mode)
            {
                case NORMAL:
                    m_next_number = m_value -1;
                    if (m_next_number < 0) m_next_number += m_modulo;
                    break;
                case ROLL_TO_GLYPH:
                    if(m_value == GLYPHS_START || m_value == 0) // if first glyph or number ...
                    {
                        m_next_number = GLYPHS_START + GLYPHS-1;// ... next is last glyph ...
                    }
                    else
                    {
                        m_next_number = m_value -1;             // ... elsewise decrease value
                    }
                    break;
                case ROLL_TO_NUMBER:
                    if(m_value == GLYPHS_START || m_value == 0) // if first glyph or number ...
                    {
                        m_next_number = m_modulo -1;            // ... next is last number ...
                    }
                    else
                    {
                        m_next_number = m_value -1;             // ... elsewise decrease value
                    }


                    m_next_number = m_value -1;
                    if (m_next_number < 0) m_next_number += m_modulo;
                    break;
            }
            m_flip_pos = 0.0f;
            m_state = FLIPPING_UPPER;
            // fall through
        case FLIPPING_UPPER:
            m_flip_pos += m_flip_speed;
            if(m_flip_pos > M_PI_2) m_state = FLIPPING_LOWER;
            break;

        case FLIPPING_LOWER:
            m_flip_pos += m_flip_speed;
            if(m_flip_pos >= M_PI) 
            {
                m_value = m_next_number;
                if(m_value != m_to_value)
                {
                    m_state = FLIP_NEXT;
                }
                else
                {
                    switch(m_mode)
                    {
                        case ROLL_TO_GLYPH:
                        case ROLL_TO_NUMBER:
                            if(m_overroll_count <= 0)
                            {
                                m_overroll_count = 0;
                                m_state = STABLE;
                                m_finished = true;
                            }
                            else
                            {
                                --m_overroll_count;
                                m_state = FLIP_NEXT;
                            }
                            break;
                        default:
                            m_state = STABLE;
                            m_finished = true;
                    }
                }
            }
            break;

        default:
            m_state = STABLE;
            m_finished = true;
    }
}


void CNumber::Draw(BITMAP* dest)
{
    switch(m_state)
    {
        case FLIPPING_UPPER:
            {
                // oberen Teil der neuen Nummer malen
                if(m_bitmaps[m_next_number]) 
                    masked_blit(m_bitmaps[m_next_number], 
                                dest, 
                                0, 
                                0, 
                                m_x, 
                                m_y, 
                                m_bitmaps[m_next_number]->w, 
                                m_axis);
    
                // sich bewegenden Teil der alten Nummer darber malen
                int h = (int)((float)m_axis * fabs(cos(m_flip_pos)));
                if(m_bitmaps[m_value]) 
                    masked_stretch_blit(m_bitmaps[m_value], 
                                dest, 
                                0, 
                                0, 
                                m_bitmaps[m_value]->w, 
                                m_axis, 
                                m_x, 
                                m_y + m_axis - h, 
                                m_bitmaps[m_value]->w, 
                                h);
                
                
                // unteren Teil der alten Nummer malen
                if(m_bitmaps[m_value]) 
                    masked_blit(m_bitmaps[m_value], 
                                dest, 
                                0, 
                                m_axis, 
                                m_x, 
                                m_y + m_axis, 
                                m_bitmaps[m_value]->w, 
                                m_bitmaps[m_value]->h - m_axis);
    
                //hline(dest, m_x, m_y, m_x + 50, makecol(255,0,0));
            }
            
            break;

        case FLIPPING_LOWER:
            {
                // oberen Teil der neuen Nummer malen
                if(m_bitmaps[m_next_number])
                    masked_blit(m_bitmaps[m_next_number], 
                                dest, 
                                0, 
                                0, 
                                m_x, 
                                m_y, 
                                m_bitmaps[m_next_number]->w, 
                                m_axis);
    
                // unteren Teil der alten Nummer malen
                if(m_bitmaps[m_value]) 
                    masked_blit(m_bitmaps[m_value], 
                                dest, 
                                0, 
                                m_axis, 
                                m_x, 
                                m_y + m_axis, 
                                m_bitmaps[m_value]->w, 
                                m_bitmaps[m_value]->h - m_axis);
    
                // sich bewegenden Teil der neuen Nummer darber malen
                int h = (int)((float)(m_bitmaps[m_next_number]->h - m_axis) * fabs(cos(m_flip_pos)));
                if(m_bitmaps[m_next_number]) 
                    masked_stretch_blit(m_bitmaps[m_next_number], 
                                dest, 
                                0, 
                                m_axis, 
                                m_bitmaps[m_next_number]->w, 
                                m_bitmaps[m_next_number]->h - m_axis, 
                                m_x, 
                                m_y + m_axis, 
                                m_bitmaps[m_next_number]->w, 
                                h);
    
                //hline(dest, m_x, m_y, m_x + 50, makecol(0,255,0));
            }
            break;
        default:
            if(m_bitmaps[m_value]) draw_sprite(dest, m_bitmaps[m_value], m_x, m_y);
    }
    //textprintf_ex(dest, font, m_x, m_y, makecol(255,255,255), makecol(0,0,0), "%d %d %d", m_value, m_to_value, m_next_number);

}

        
