// Eigene Exception-Klasse

#include <exception>
#include <string>
#include <sstream>

#ifndef CMYEXCEPTION
#define CMYEXCEPTION

//namespace MySpace {
    
//using namespace std;    

#define MYASSERTMSG(condition, message) \
    if(!(condition)) throw(CMyException(#condition ": " message, __FILE__, __LINE__))

#define MYASSERTVALIDMSG(pointer, message) \
    if((pointer == NULL)) throw(CMyException(#pointer " not valid: " message, __FILE__, __LINE__))

#define MYASSERT(condition) \
    if(!(condition)) throw(CMyException(#condition, __FILE__, __LINE__))

#define MYASSERTVALID(pointer) \
    if((pointer == NULL)) throw(CMyException(#pointer " not valid", __FILE__, __LINE__))

class CMyException : public std::exception
{
    public:
        CMyException()
        {
            m_msg = "Not specified error.";
        };

        CMyException(const CMyException &src)
        {
            m_msg = src.m_msg;
        };

        CMyException &operator=(const CMyException &src)
        {
            m_msg = src.m_msg;
        };

        CMyException(const std::string & msg)
        {
            m_msg = msg;
        };

        CMyException(const std::stringstream & msg)
        {
            m_msg = msg.str();
        };

        CMyException(const char * msg)
        {
            m_msg = msg;
        };

        CMyException(const std::string & msg, const std::string & file)
        {
            m_msg = file + ":" + msg;
        };

        CMyException(const std::stringstream & msg, const std::string & file)
        {
            m_msg = file + ":" + msg.str();
        };

        CMyException(const std::string & msg, const std::string & file, const unsigned long line)
        {
            std::stringstream str;
            str << file << "(" << line << "):" << msg;
            m_msg = str.str();
        };

        CMyException(const std::stringstream & msg, const std::string & file, const unsigned long line)
        {
            std::stringstream str;
            str << file << "(" << line << "):" << msg;
            m_msg = str.str();
        };


        virtual ~CMyException() throw() {};
        
        virtual const char* what() const throw()
        {
            return m_msg.c_str();
        };
        
    private:
        std::string m_msg;
};

//}

#endif
