#ifndef CKEYLOCK_H_INCLUDED
#define CKEYLOCK_H_INCLUDED

#include "allegro.h"

#include <string>
#include <sstream>
#include <vector>

#include "CMainObject.h"
#include "CRectObject.h"



class CKeylock : public CMainObject, public CRectObject
{
    public:
        CKeylock();
        virtual ~CKeylock();
        
        virtual void InitRes(DATAFILE * dat);
        virtual void Update(void);
        virtual void Draw(BITMAP* dest);
        
        void SetPositions(int x_out, int x_in, int y);
        
        void MoveIn(void);
        void MoveOut(void);
        
        inline bool IsIn(void)     { return m_state == STATE_IN;};
        inline bool IsOut(void)    { return m_state == STATE_OUT;};
        inline bool IsMoving(void) { return m_state == STATE_MOVING_OUT || m_state == STATE_MOVING_IN;};
        
        inline bool IsKeyTurned(void) { return m_key_turned; };
        
        
    private:
        enum e_state
        {
            STATE_OUT = 0,
            STATE_MOVING_IN,
            STATE_IN,
            STATE_MOVING_OUT
        };
        int m_state; 

        BITMAP * m_keylock;
        BITMAP * m_key;
        SAMPLE * m_snd_keyturn;
        
        int m_move_speed;
        int m_x_in;
        int m_x_out;
        
        int m_hotspot_x;
        int m_hotspot_y;
        int m_hotspot_radius;
        bool m_hotspot_mouseover;
        
        int m_key_offset_x;
        int m_key_offset_y;
        int m_mouse_focus_x_bkp;
        int m_mouse_focus_y_bkp;
        
        bool m_key_turned;
        
        bool IsMouseOverHotspot(void);

};

#endif
