#include "CKeylock.h"
#include <limits>

#include "Datafile_objects.h"

#include "Logfile.hpp"

using namespace std;


CKeylock::CKeylock()
{
    m_keylock           = NULL;
    m_key               = NULL;
    m_snd_keyturn       = NULL;
    m_move_speed        = 2;
    m_state             = STATE_OUT;
    m_x_in              = 0;
    m_x_out             = 0;
    m_hotspot_x         = 52;
    m_hotspot_y         = 83;
    m_hotspot_radius    = 10;
    m_hotspot_mouseover = false;
    m_key_offset_x      = 11;
    m_key_offset_y      = 39;
    m_mouse_focus_x_bkp = 0;
    m_mouse_focus_y_bkp = 0;
    m_finished          = false;
    m_key_turned        = false;
}


bool CKeylock::IsMouseOverHotspot(void)
{
    if(!IsPointIn(mouse_x, mouse_y)) return false;

    int dx = m_x + m_hotspot_x - mouse_x;
    int dy = m_y + m_hotspot_y - mouse_y;
    int rq = m_hotspot_radius * m_hotspot_radius;
    if(dx*dx + dy*dy > rq) return false;
    return true;
}

CKeylock::~CKeylock()
{
}

void CKeylock::InitRes(DATAFILE * dat)
{
    if(dat == NULL)
    {
        m_keylock     = NULL;
        m_key         = NULL;
        m_snd_keyturn = NULL;
    }
    else
    {
        if((m_keylock = (BITMAP *)dat[DAT_KEYLOCK].dat ) == NULL)
        {
            // Object not set!
            throw(std::string("Datafile Error! Bitmap for Keylock is NULL."));
        }
        Size(m_keylock->w, m_keylock->h);
        
        if((m_key = (BITMAP *)dat[DAT_KEY].dat ) == NULL)
        {
            // Object not set!
            throw(std::string("Datafile Error! Bitmap for Key is NULL."));
        }

        if((m_snd_keyturn = (SAMPLE *)dat[DAT_SND_KEYTURN].dat ) == NULL)
        {
            // Object not set!
            throw(std::string("Datafile Error! Sample for Keyturn is NULL."));
        }
    }
}

void CKeylock::SetPositions(int x_out, int x_in, int y)
{
    m_x_in = x_in;
    m_x_out = x_out;
    Pos(x_out, y);
}

void CKeylock::MoveIn(void)
{
    if(IsIn()) return;
    m_state = STATE_MOVING_IN;
    m_finished = false;
    m_key_turned = false;
}

void CKeylock::MoveOut(void)
{
    if(IsOut()) return;
    m_state = STATE_MOVING_OUT;
    m_finished = false;
    set_mouse_sprite(NULL);
    set_mouse_sprite_focus(m_mouse_focus_x_bkp, m_mouse_focus_y_bkp);
}

void CKeylock::Update(void)
{
    m_hotspot_mouseover = IsMouseOverHotspot();
    switch(m_state)
    {
        case STATE_MOVING_OUT:
            m_x += m_move_speed;
            if(m_x >= m_x_out)
            {
                m_x = m_x_out;
                m_state = STATE_OUT;
                m_key_turned = false;
                m_finished = true;
            }
            break;
        case STATE_MOVING_IN:
            m_x -= m_move_speed;
            if(m_x <= m_x_in)
            {
                m_x = m_x_in;
                m_state = STATE_IN;
                m_mouse_focus_x_bkp = mouse_x_focus;
                m_mouse_focus_y_bkp = mouse_y_focus;
                set_mouse_sprite(m_key);
                set_mouse_sprite_focus(m_key_offset_x, m_key_offset_y);
                m_finished = true;
            }
            break;
        case STATE_IN:
            if(m_hotspot_mouseover)
            {
                if(mouse_b & 0x0001)
                {
                    play_sample(m_snd_keyturn, 255, 127, 1000, 0);
                    m_key_turned = true;
                    MoveOut();
                }
            }
    }
}

void CKeylock::Draw(BITMAP* dest)
{
    if(m_state == STATE_OUT) return;        // Off the screen, don't draw 
    if(m_keylock == NULL) return;
    
    masked_blit(m_keylock, dest, 0, 0, m_x, m_y, m_w, m_h);
    
    if(0)
    {
        // Draw the hotspot
        int hotspot_color;
        if(m_hotspot_mouseover)
        {
            hotspot_color = makecol(255,0,0);
        }
        else
        {
            hotspot_color = makecol(128,128,128);
        }
        putpixel(dest, m_x + m_hotspot_x, m_y + m_hotspot_y, hotspot_color);
        circle(dest, m_x + m_hotspot_x, m_y + m_hotspot_y, m_hotspot_radius, hotspot_color);
    }
}    
