#ifndef CRECTOBJECT_H_INCLUDED
#define CRECTOBJECT_H_INCLUDED


class CRectObject
{
    public:
        CRectObject() :  m_x(0), m_y(0), m_w(0), m_h(0) {};
        CRectObject(int x, int y) : m_x(x), m_y(y), m_w(0), m_h(0) {};
        CRectObject(int x, int y, int w, int h) : m_x(x), m_y(y), m_w(w), m_h(h) {};
        CRectObject(const CRectObject &r) : m_x(r.m_x), m_y(r.m_y), m_w(r.m_w), m_h(r.m_h) {};

        ~CRectObject() {};
        
        inline int X(void) {return m_x;};
        inline int Y(void) {return m_y;};
        inline int W(void) {return m_w;};
        inline int H(void) {return m_h;};

        void X(int x)           { if(x != m_x) { m_x = x; Position_Changed();} };
        void Y(int y)           { if(y != m_y) { m_y = y; Position_Changed();} };
        void Pos(int x, int y)  { if((y != m_y)||(x != m_x))  { m_y = y; m_x = x; Position_Changed();} };
        
        void W(int w)           { if(w != m_w) { m_w = w; Size_Changed();} };
        void H(int h)           { if(h != m_h) { m_h = h; Size_Changed();} };
        void Size(int w, int h) { if((w != m_w)||(h != m_h))  { m_w = w; m_h = h; Size_Changed();} };
        
        bool IsPointIn(int px, int py)
        {
            if(px < m_x || px >= m_x + m_w) return false;
            if(py < m_y || py >= m_y + m_h) return false;
            return true;
        }
        
    protected:
        virtual void Position_Changed(void) {};
        virtual void Size_Changed(void) {};
        
        int m_x;
        int m_y;
        int m_w;
        int m_h;

};

#endif
