#include "CIntro.h"
#include "Datafile_objects.h"

#include "allegro.h"
#include <string>

void CIntro::InitInstance(void)
{
    m_state = STATE_STARTUP;
    m_bmp_lost = NULL;
    m_snd_intro = NULL;
    m_counter = 0;
    m_lost_factor = 0.2;
    m_lost_grow_step = 0.0015;

}

CIntro::CIntro()
{
    InitInstance();
}

CIntro::~CIntro()
{
}
        
void CIntro::InitRes(DATAFILE * dat)
{
    if(dat == NULL)
    {
        m_bmp_lost = NULL;
        m_snd_intro = NULL;
    }
    else
    {
        if((m_bmp_lost = (BITMAP*)dat[DAT_LOST].dat) == NULL)
        {
            // Object not set!
            throw(std::string("Datafile Error! Bitmap for 'Lost' is NULL."));
        }
        if(( m_snd_intro = (SAMPLE *)dat[DAT_SND_INTRO].dat) == NULL)
        {
            // Object not set!
            throw(std::string("Datafile Error! 'Intro' sample is NULL."));
        }
    }
}

void CIntro::Reset(void)
{
    m_state = STATE_STARTUP;
    m_finished = false;
}

void CIntro::Update(void)
{
    //if(key[KEY_SPACE]) m_finished = true;
    switch(m_state)
    {
        case STATE_STARTUP:
            m_counter = 0;
            play_sample(m_snd_intro, 255, 127, 1000, 0);
            m_state = STATE_LOOP;
            break;
        case STATE_LOOP:
            m_counter++;
            if(m_counter > 10 * 60)
            {
                m_state = STATE_FINISHED;
            }
            m_lost_factor += m_lost_grow_step;
            break;
        case STATE_FINISHED:
            m_lost_factor += m_lost_grow_step;
            m_finished = true;
            break;        
    }
}

void CIntro::Draw(BITMAP* dest)
{
    int lost_w = (int)(m_bmp_lost->w * m_lost_factor);
    int lost_h = (int)(m_bmp_lost->h * m_lost_factor);

    textout_centre_ex(dest, font, "Are You ...", dest->w/2, 5, makecol(192,192,192), -1);

    masked_stretch_blit(m_bmp_lost, 
                 dest, 
                 0, 
                 0, 
                 m_bmp_lost->w, 
                 m_bmp_lost->h, 
                 (dest->w - lost_w)/2, 
                 (dest->h - lost_h)/2 - 15, 
                 lost_w, 
                 lost_h);

    int y = dest->h - 3 * (text_height(font) + 5);
    textout_centre_ex(dest, font, "'Lost' is (c) by Touchstone Television", dest->w/2, y, makecol(192,192,192), -1);
    y += text_height(font) + 5;
    textout_centre_ex(dest, font, "'Are you Lost' is presented by", dest->w/2, y, makecol(192,192,192), -1);
    y += text_height(font) + 5;
    textout_centre_ex(dest, font, "Raabinator " __DATE__, dest->w/2, y, makecol(192,192,192), -1);
}

