// CApplication.cpp

#include "AreYouLost_private.h"

#include "CApplication.h"
#include "Datafile_objects.h"
#include "CIntro.h"
#include "CTitle.h"
#include "CMainScreen.h"
#include "CCredits.h"

#include "Logfile.hpp"
#include "CMyException.hpp"

#include "allegro.h"
#include <string>
#include <sstream>
#include <iomanip>

#include <fblend.h>


using namespace std;

//static 
void CApplication::Ticker(void)
{
    m_ticker++;
}
END_OF_FUNCTION(CApplication::Ticker)

//static 
int CApplication::m_ticker = 0; 

//static 
bool CApplication::cheats_enabled = false;

//static 
bool CApplication::tick_seconds_enabled = false;

//static 
bool CApplication::sound_enabled = true;

//static 
int  CApplication::sound_digi_volume = 255;

//static 
int  CApplication::sound_midi_volume = 255;

//static 
void CApplication::UpdateVolume(void)
{
    if(sound_enabled)
    {
        set_volume(sound_digi_volume, sound_midi_volume);
    }
    else
    {
        set_volume(1, 1);   // using 1 because 0 doesn't start a sample
    }
}

//static 
void CApplication::SoundEnabled(bool enabled)
{
    sound_enabled = enabled;
    UpdateVolume();
}

//static 
bool CApplication::SoundEnabled(void)
{
    return sound_enabled;
}

//static 
void CApplication::DigiVolume(int volume)
{
    if(volume < 0) volume = 0;
    sound_digi_volume = volume < 255 ? volume : 255;
    UpdateVolume();
}

//static 
int  CApplication::DigiVolume(void)
{
    return sound_digi_volume;
}

//static 
void CApplication::MidiVolume(int volume)
{
    if(volume < 0) volume = 0;
    sound_midi_volume = volume < 255 ? volume : 255;
    UpdateVolume();
}

//static 
int  CApplication::MidiVolume(void)
{
    return sound_midi_volume;
}

//static 
void CApplication::TickSecondsEnabled(bool enabled)
{
    tick_seconds_enabled = enabled;
}

//static 
bool CApplication::TickSecondsEnabled(void)
{
    return tick_seconds_enabled;
}

//static 
void CApplication::CheatsEnabled(bool enabled)
{
    cheats_enabled = enabled;
}

//static 
bool CApplication::CheatsEnabled(void)
{
    return cheats_enabled;
}



CApplication::CApplication()
{
    m_buffer = NULL;
    m_fade_buffer = NULL;
    m_main_object = NULL;
    m_datafile = NULL;
    m_fade_value = 0;
    m_counter = 0;
    m_esc_key_counter = 0;
    m_mainstate = STATE_STARTUP;
    m_mode = MODE_INTRO;
    m_screenshot = SCREENSHOT_IDLE;
    m_finished = false;
    m_f1_key_down = false;
}

CApplication::~CApplication()
{
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
     
	if(m_buffer) destroy_bitmap(m_buffer);
	m_buffer = NULL;

	if(m_fade_buffer) destroy_bitmap(m_fade_buffer);
	m_fade_buffer = NULL;

    if(m_datafile) unload_datafile(m_datafile);
    m_datafile = NULL;

    if(m_main_object) delete m_main_object;
    m_main_object = NULL;

}

void CApplication::InitInstance(void)
{
	int depth, res;

	if(allegro_init())
	{
        throw string("Failed initializing Allegro library.");
    }
	if(install_timer() != 0)
	{
        throw string("Failed initializing Timer module.");
    }
	if(install_keyboard() != 0)
	{
        throw string("Failed initializing Keyboard module.");
    }
	if(install_mouse() < 0)
	{
        throw string("Failed initializing Mouse.");
    }
	
	if(install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0)
	{
        Logfile->Message("Failed initializing Sound module.");
        Logfile->Message(allegro_error);
    }

	depth = desktop_color_depth();
	if (depth == 0) depth = 32;
	
	if(depth < 15)
	{
        throw(std::string("Your desktop color depth is loo low.\nTry at least 15/16 Bits, best is 32 Bits."));
    }
	set_color_depth(depth);
	res = set_gfx_mode(GFX_AUTODETECT_WINDOWED, 320, 200, 0, 0);
	//res = set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 320, 200, 0, 0);
	if (res != 0) 
    {
        throw(std::string(allegro_error));
	}

    Logfile->LogDisplayCaps();
    Logfile->LogDisplayMode();
    
    set_window_title(PRODUCT_NAME " V" VER_STRING);

    UpdateVolume();
    
    if(is_windowed_mode())
    {
        set_display_switch_mode(SWITCH_BACKGROUND);
    }
    else
    {
        set_display_switch_mode(SWITCH_BACKAMNESIA);
    }
    
    m_buffer = create_bitmap(screen->w, screen->h);
    MYASSERTVALIDMSG(m_buffer, "failed creating buffer");

    m_fade_buffer = create_bitmap(screen->w, screen->h);
    MYASSERTVALIDMSG(m_fade_buffer, "failed creating fade-buffer");

    m_datafile = load_datafile("AreYouLost.dat");
    MYASSERTVALIDMSG(m_datafile, "failed loading datafile");
    

}

void CApplication::SaveScreenshot(BITMAP * src)
{
    int nr = 1;
    bool saved = false;
    const char * format = get_config_string("screenshot", "format", "tga");
    while (!saved && (nr < 1000))
    {
        stringstream fname;
        fname << "Screenshot_";
        fname << setw(3) << setfill('0') << right << nr << "." << format;
        
        FILE * f = fopen(fname.str().c_str(), "r");
        if (f == NULL)
        {
            PALETTE pal;
            get_palette(pal);
            BITMAP * bmp = create_bitmap(src->w, src->h);
            if (NULL == bmp)
            {
                if (Logfile) Logfile->Message("Failed creating tmp-bitmap for screenshot");
                return;
            }
            blit(src, bmp, 0, 0, 0, 0, src->w, src->h);
            if (save_bitmap(fname.str().c_str(), bmp, pal))
            {
                fname << " failed saving";
            }
            else
            {
                fname << " saved";
            }
            if (Logfile) Logfile->Message(fname.str());
            destroy_bitmap(bmp);            
            saved = true;
        }
        else
        {
            fclose(f);
            nr++;
        }
    }
}


void CApplication::StartTicker(void)
{
    int r = install_int_ex(Ticker, BPS_TO_TIMER(TICKS_PER_SECOND));
    MYASSERTMSG(r == 0, "failed installing ticker");
    m_ticker = 0;
}

void CApplication::StopTicker(void)
{
    remove_int(Ticker);
}

bool CApplication::FadeIn(void)
{
    m_fade_value += 2;
    if(m_fade_value >= 255)
    {
        m_fade_value = 255;
        return true;
    }
    return false;
}

bool CApplication::FadeOut(void)
{
    m_fade_value -= 2;
    if(m_fade_value <= 0)
    {
        m_fade_value = 0;
        return true;
    }
    return false;
}


void CApplication::Run(void)
{
    InitInstance();
    
    show_mouse(screen);
      
    m_mainstate = STATE_STARTUP;
    
    bool do_it = true;
    bool redraw = true;
    StartTicker();
    while (!m_finished)
    {
        while(m_ticker)
        {
            m_ticker--;
            if(key[KEY_ESC]) 
            {
                // User must hold ESC-Key a while for exitting
                m_esc_key_counter++;
                if(m_esc_key_counter >= ESC_KEY_THRESHOLD) m_finished = true;
            }
            else
            {
                m_esc_key_counter = 0;
            }
            if(key[KEY_PRTSCR])
            {
                if(m_screenshot == SCREENSHOT_IDLE) m_screenshot = SCREENSHOT_TAKE;
            }
            else
            {
                if(m_screenshot == SCREENSHOT_TAKEN) m_screenshot = SCREENSHOT_IDLE;
            }
            if(key[KEY_F1])
            {
                if(!m_f1_key_down)
                {
                    SoundEnabled(!SoundEnabled());
                    m_f1_key_down = true;
                }
            }
            else
            {
                m_f1_key_down = false;
            }
                
            if(m_main_object) m_main_object->Update();
            switch(m_mainstate)
            {
                case STATE_STARTUP:
                    m_mode = MODE_INTRO;
                    m_mainstate = STATE_ENTER_MODE;
                    //Fall through !!!
                case STATE_ENTER_MODE:
                    if(m_main_object) delete m_main_object;
                    m_main_object = NULL;
                    try
                    {
                        switch(m_mode)
                        {
                            case MODE_INTRO:
                                m_main_object = new CIntro;
                                break;
                            case MODE_TITLE:
                                m_main_object = new CTitle;
                                break;
                            case MODE_MAINSCREEN:
                                m_main_object = new CMainScreen;
                                break;
                            case MODE_CREDITS:
                                m_main_object = new CCredits;
                                break;
                        }
                    }
                    catch(...)
                    {
                        m_main_object = NULL;
                    }
                    MYASSERTVALIDMSG(m_main_object, "Application failed creating CIntro object.");
                    m_main_object->InitRes(m_datafile);
                    m_mainstate = STATE_FADE_MODE_IN;
                    //Fall through !!!
                case STATE_FADE_MODE_IN:
                    if(FadeIn()) 
                    {
                        m_mainstate = STATE_MODE_LOOP;
                        m_counter = 0;
                    }
                    break;
                case STATE_MODE_LOOP:
                    if(m_main_object->IsFinished())
                    {
                        m_mainstate = STATE_FADE_MODE_OUT;
                    }
                    break;
                case STATE_FADE_MODE_OUT:
                    if(FadeOut()) 
                    {
                        switch(m_mode)
                        {
                            case MODE_INTRO:
                                m_mode = MODE_TITLE;
                                m_mainstate = STATE_ENTER_MODE;
                                break;
                            case MODE_TITLE:
                                m_mode = MODE_MAINSCREEN;
                                m_mainstate = STATE_ENTER_MODE;
                                break;
                            case MODE_MAINSCREEN:
                                m_mode = MODE_CREDITS;
                                m_mainstate = STATE_ENTER_MODE;
                                break;
                            case MODE_CREDITS:
                                m_mainstate = STATE_FINISHED;
                                break;
                        }
                    }
                    break;
                case STATE_FINISHED:
                    m_finished = true;
                    break;
                default:
                    MYASSERTMSG(m_mainstate != m_mainstate, "Unknown state detected in CApplication.");
            }
            redraw = true;
        }

        if(redraw && !m_finished) Draw();
	}
}



void CApplication::Draw(void)
{
    clear_bitmap(m_buffer);

    if(m_main_object) m_main_object->Draw(m_buffer);

    if(!SoundEnabled())
    {
        textout_right_ex(m_buffer, font, "mute", m_buffer->w, 0, makecol(128, 192, 128), -1);
    }
    
    vsync();
    scare_mouse();
    if(m_fade_value < 255)
    {
        clear_bitmap(m_fade_buffer);
        fblend_trans(m_buffer, m_fade_buffer, 0, 0, m_fade_value);  
        blit(m_fade_buffer, screen, 0, 0, 0, 0, m_buffer->w, m_buffer->h);
    }
    else
    {
        blit(m_buffer, screen, 0, 0, 0, 0, m_buffer->w, m_buffer->h);
    }
    unscare_mouse();
    if(m_screenshot == SCREENSHOT_TAKE)
    {
        SaveScreenshot(screen);
        m_screenshot = SCREENSHOT_TAKEN;
    }
}
