#include <allegro.h>

#include "ventplay.h"
#include "game.h"
#include "icontrol.h"



#define MOVE_PLAYER(d, SIGN, bc, cond, fw, bw, u, v, TOSIDE1, TOSIDE2)		\
{																			\
	u##f SIGN##= 0x800l;													\
	if (u##f bc 0x8000l) {													\
		game.player.vent.dir = d;											\
		game.player.vent.u &= ~0xFFFFl;										\
		game.player.vent.u += u##f;											\
		game.player.vent.frame += 0x800 - 1;								\
		game.player.vent.frame &= 0xFFFFl;									\
		game.player.vent.frame++;											\
		return;																\
	}																		\
	if (cond) {																\
		int transit = VM_CAN_TRANSIT(game.vent_map->layer[0][y][x]);		\
																			\
		int layer;															\
		for (layer = 0; layer <= transit; layer++) {						\
			unsigned char toside1 = game.vent_map->layer[game.player.vent.layer ^ layer] TOSIDE1; \
			unsigned char toside2 = game.vent_map->layer[game.player.vent.layer ^ layer] TOSIDE2; \
																			\
			if (VM_CAN_GO(toside1)) {										\
				if (go_straight) {											\
					if (VM_CAN_GO(toside2)) {								\
						game.player.vent.dir = d;							\
						game.player.vent.u &= ~0xFFFFl;						\
						game.player.vent.u += u##f;							\
						game.player.vent.frame += 0x800 - 1;				\
						game.player.vent.frame &= 0xFFFFl;					\
						game.player.vent.frame++;							\
						game.player.vent.layer ^= layer;					\
						return;												\
					}														\
				}															\
				if (!go_straight) {											\
					game.player.vent.dir = (d ^ 2) & ~1;					\
					game.player.vent.u &= ~0x7FFFl;							\
					game.player.vent.u |= fw;								\
					game.player.vent.v -= 0x800l;							\
					if ((game.player.vent.v & 0xF800l) == 0x7800l) {		\
						game.player.vent.v &= ~0x7FFFl;						\
						game.player.vent.v |= 0x8000l;						\
					}														\
					game.player.vent.frame += 0x800 - 1;					\
					game.player.vent.frame &= 0xFFFFl;						\
					game.player.vent.frame++;								\
					return;													\
				}															\
			}																\
			if (!go_straight) {												\
				if (VM_CAN_GO(toside2)) {									\
					game.player.vent.dir = (d ^ 2) | 1;						\
					game.player.vent.u &= ~0x7FFFl;							\
					game.player.vent.u |= fw;								\
					game.player.vent.v += 0x800l;							\
					if ((game.player.vent.v & 0xF800l) == 0x8000l)			\
						game.player.vent.v &= ~0x7FFFl;						\
					game.player.vent.frame += 0x800 - 1;					\
					game.player.vent.frame &= 0xFFFFl;						\
					game.player.vent.frame++;								\
					return;													\
				}															\
			}																\
		}																	\
	}																		\
	game.player.vent.u &= ~0x7FFFl;											\
	game.player.vent.u |= fw;												\
	u##f = 0x8000l;															\
}



#define MOVE_PLAYER_X(d, SIGN, bc, cond, fw, bw) MOVE_PLAYER(d, SIGN, bc, cond, fw, bw, x, y, [y + (yf >> 15) - 1][x SIGN 1], [y + ((yf + 0x7FFFl) >> 16)][x SIGN 1])
#define MOVE_PLAYER_Y(d, SIGN, bc, cond, fw, bw) MOVE_PLAYER(d, SIGN, bc, cond, fw, bw, y, x, [y SIGN 1][x + (xf >> 15) - 1], [y SIGN 1][x + ((xf + 0x7FFFl) >> 16)])



static void move_vent_player(void)
{
	int x = game.player.vent.x >> 16;
	int y = game.player.vent.y >> 16;
	int xf = game.player.vent.x & 0xFFFFl;
	int yf = game.player.vent.y & 0xFFFFl;

#define go_straight 1

	if (ckey[CKEY_LEFT ] && !ckey[CKEY_RIGHT]) { MOVE_PLAYER_X(0, -, >=, x > 0                   , 0x0000l, 0x8000l); }
	if (ckey[CKEY_RIGHT] && !ckey[CKEY_LEFT ]) { MOVE_PLAYER_X(1, +, <=, x < game.vent_map->w - 1, 0x8000l, 0x0000l); }
	if (ckey[CKEY_UP   ] && !ckey[CKEY_DOWN ]) { MOVE_PLAYER_Y(2, -, >=, y > 0                   , 0x0000l, 0x8000l); }
	if (ckey[CKEY_DOWN ] && !ckey[CKEY_UP   ]) { MOVE_PLAYER_Y(3, +, <=, y < game.vent_map->h - 1, 0x8000l, 0x0000l); }

#undef go_straight

#define go_straight 0

	if (ckey[CKEY_LEFT ] && !ckey[CKEY_RIGHT]) { MOVE_PLAYER_X(0, -, >=, x > 0                   , 0x0000l, 0x8000l); }
	if (ckey[CKEY_RIGHT] && !ckey[CKEY_LEFT ]) { MOVE_PLAYER_X(1, +, <=, x < game.vent_map->w - 1, 0x8000l, 0x0000l); }
	if (ckey[CKEY_UP   ] && !ckey[CKEY_DOWN ]) { MOVE_PLAYER_Y(2, -, >=, y > 0                   , 0x0000l, 0x8000l); }
	if (ckey[CKEY_DOWN ] && !ckey[CKEY_UP   ]) { MOVE_PLAYER_Y(3, +, <=, y < game.vent_map->h - 1, 0x8000l, 0x0000l); }

#undef go_straight

	/* If we reach here, the player didn't move, or he has just finished
	 * moving.
	 */
	game.player.vent.frame = 0;
}



void update_vent_player(void)
{
	if (game.mode != GM_ALIVE)
		return;

	move_vent_player();

	if (ckey[CKEY_CLUB]) {
		if (!game.clubheld) {
			int club = game.vent_map->layer
				[game.player.vent.layer]
				[game.player.vent.y >> 16]
				[game.player.vent.x >> 16];
			int vent;

			if (club == VM_ENDING)
				game.mode = GM_ENDMAP;
			else {
				club -= VM_HOTSPOT;
				if (club >= 0) {
					game.resumeclub = game.club = game.hotspot_club[club];
					vent = game.hotspot_vent[club];
					game.player.club.mode = CP_VENT;
					game.player.club.firecount = 0;
					game.player.club.x = (int)game.club_map[game.club]->vent_x[vent] << 16;
					game.player.club.y = (int)game.club_map[game.club]->vent_y[vent] << 16;
					game.player.club.yv = 0;
					game.resumeplayer.club = game.player.club;
				}
			}
			game.clubheld = 1;
		}
	} else
		game.clubheld = 0;

	if (game.growl_v >= 0) {
		deallocate_voice(game.growl_v);
		game.growl_v = -1;
	}
}
