#ifndef INCLUDED_VENTMAP_H
#define INCLUDED_VENTMAP_H


typedef struct VENT_MAP
{
	int w, h;

	unsigned char **layer[2];
}
VENT_MAP;


#define VM_NOTHING  0
#define VM_GRASS    1
#define VM_CLUB     2
#define VM_VENT     3
#define VM_JUNCTION 4
#define VM_ENDING   5
#define VM_HOTSPOT  6
/* Use (VM_HOTSPOT + n), where n is an index into the Hotspot Tables in the
 * GAME struct. See game.h for more info.
 */

#define VM_CAN_GO(n) ((n) >= VM_VENT)
#define VM_CAN_TRANSIT(n) ((n) == VM_JUNCTION)


VENT_MAP *create_vent_map(int w, int h);
void destroy_vent_map(VENT_MAP *map);


#define VML_W 30
#define VML_H 25


#define VMU_W 36
#define VMU_H 30


void draw_vent_map(BITMAP *bmp, float *plx, float *ply);


#endif /* INCLUDED_VENTMAP_H */
