#include <stdlib.h>
#include <allegro.h>

#include "ventmap.h"



VENT_MAP *create_vent_map(int w, int h)
{
	int y;

	VENT_MAP *map = malloc(sizeof(*map));

	if (!map)
		return NULL;

	map->w = w;
	map->h = h;

	map->layer[0] = NULL;
	map->layer[1] = NULL;

	map->layer[0] = malloc(h * sizeof(*map->layer[0]));

	if (!map->layer[0]) {
		destroy_vent_map(map);
		return NULL;
	}

	map->layer[0][0] = malloc(h * w * sizeof(*map->layer[0][0]));

	if (!map->layer[0][0]) {
		destroy_vent_map(map);
		return NULL;
	}

	map->layer[1] = malloc(h * sizeof(*map->layer[1]));

	if (!map->layer[1]) {
		destroy_vent_map(map);
		return NULL;
	}

	map->layer[1][0] = malloc(h * w * sizeof(*map->layer[1][0]));

	if (!map->layer[1][0]) {
		destroy_vent_map(map);
		return NULL;
	}

	for (y = 1; y < h; y++)
		map->layer[0][y] = map->layer[0][y - 1] + w;

	for (y = 1; y < h; y++)
		map->layer[1][y] = map->layer[1][y - 1] + w;

	return map;
}



void destroy_vent_map(VENT_MAP *map)
{
	if (map) {
		if (map->layer[0]) {
			free(map->layer[0][0]);
			free(map->layer[0]);
		}
		if (map->layer[1]) {
			free(map->layer[1][0]);
			free(map->layer[1]);
		}
		free(map);
	}
}
