#include <math.h>
#include <allegro.h>

#include "main.h"
#include "game.h"
#include "ventmap.h"



typedef struct DVM_JUNCTION
{
	V3D_f v3d[4];

	struct DVM_JUNCTION *next;
}
DVM_JUNCTION;



static void draw_player(BITMAP *bmp)
{
	float x = bmp->w * 0.5;
	float y = bmp->h * 0.5;

	float xr, yr;
	float xf, yf;

	int frame = game.player.vent.frame + 0x1FFFl;
	float u = 63.99;
	int datref = GFX_VENT_MAN0;

	switch (game.player.vent.dir) {
		case 0:
			xf = -1.0; yf = 0.0;
			break;
		case 1:
			xf = 1.0; yf = 0.0;
			break;
		case 2:
			xf = 0.0; yf = -1.0;
			break;
		default:
			xf = 0.0; yf = 1.0;
	}

	xr = -yf;
	yr = xf;

	if (game.player.vent.layer) {
		xr *= 0.5 * VMU_W;
		xf *= 0.5 * VMU_W;
		yr *= 0.5 * VMU_H;
		yf *= 0.5 * VMU_H;
	} else {
		xr *= 0.5 * VML_W;
		xf *= 0.5 * VML_W;
		yr *= 0.5 * VML_H;
		yf *= 0.5 * VML_H;
	}

	if (frame & 0x4000l) {
		datref++;
		xf *= 2;
		yf *= 2;
		u = 127.99;
	}

	if (frame & 0x8000l) {
		xr = -xr;
		yr = -yr;
	}

	{
		V3D_f v3d[4] = {
			{x - xf - xr, y - yf - yr, 0, 0.01,  0.01, 0},
			{x - xf + xr, y - yf + yr, 0, 0.01, 63.99, 0},
			{x + xf + xr, y + yf + yr, 0, u   , 63.99, 0},
			{x + xf - xr, y + yf - yr, 0, u   ,  0.01, 0}
		};

		quad3d_f(bmp, POLYTYPE_ATEX_MASK, dat[datref].dat, &v3d[0], &v3d[1], &v3d[2], &v3d[3]);
	}
}



void draw_vent_map(BITMAP *bmp, float *plx, float *ply)
{
	VENT_MAP *map = game.vent_map;

	float xc = fixtof(game.player.vent.x);
	float yc = fixtof(game.player.vent.y);

	int player_on_top = (
		VM_CAN_TRANSIT(
			map->layer[0][game.player.vent.y >> 16][game.player.vent.x >> 16]
		) | game.player.vent.layer
	);

	int x, y;
	int x_start;
	int xs, ys;
	int xs_start;

	DVM_JUNCTION *firstjunc = NULL;

	xs_start = floor(bmp->w * 0.5 - xc * VML_W);
	ys = floor(bmp->h * 0.5 - yc * VML_H);

	x_start = -((xs_start + VML_W - 1) / VML_W);
	y = -((ys + VML_H - 1) / VML_H);

	xs_start += x_start * VML_W;
	ys += y * VML_H;

	for (; ys < bmp->h; y++, ys += VML_H) {
		for (xs = xs_start, x = x_start; xs < bmp->w; x++, xs += VML_W) {
			unsigned char c;

			if (x >= 0 && x < map->w && y >= 0 && y < map->h)
				c = map->layer[0][y][x];
			else
				c = VM_GRASS;

			if (VM_CAN_TRANSIT(c)) {
				DVM_JUNCTION *junc = malloc(sizeof(*junc));
				junc->v3d[0].u = 0.01;  junc->v3d[0].v = 0.01;
				junc->v3d[1].u = 0.01;  junc->v3d[1].v = 63.99;
				junc->v3d[2].u = 63.99; junc->v3d[2].v = 63.99;
				junc->v3d[3].u = 63.99; junc->v3d[3].v = 0.01;

				if (x > 0 && VM_CAN_GO(map->layer[0][y][x - 1])) {
					junc->v3d[0].x = xs; junc->v3d[0].y = ys;
					junc->v3d[1].x = xs; junc->v3d[1].y = ys + VML_H;
					junc->v3d[3].x = floor(bmp->w * 0.5 + (x - xc) * VMU_W) + VMU_W;
					junc->v3d[3].y = floor(bmp->h * 0.5 + (y - yc) * VMU_H);
					junc->v3d[2].x = junc->v3d[3].x;
					junc->v3d[2].y = junc->v3d[3].y + VMU_H;
				} else if (x < map->w - 1 && VM_CAN_GO(map->layer[0][y][x + 1])) {
					junc->v3d[3].x = xs + VML_W; junc->v3d[3].y = ys;
					junc->v3d[2].x = xs + VML_W; junc->v3d[2].y = ys + VML_H;
					junc->v3d[0].x = floor(bmp->w * 0.5 + (x - xc) * VMU_W);
					junc->v3d[0].y = floor(bmp->h * 0.5 + (y - yc) * VMU_H);
					junc->v3d[1].x = junc->v3d[0].x;
					junc->v3d[1].y = junc->v3d[0].y + VMU_H;
				} else if (y > 0 && VM_CAN_GO(map->layer[0][y - 1][x])) {
					junc->v3d[0].x = xs;         junc->v3d[0].y = ys;
					junc->v3d[3].x = xs + VML_W; junc->v3d[3].y = ys;
					junc->v3d[1].x = floor(bmp->w * 0.5 + (x - xc) * VMU_W);
					junc->v3d[1].y = floor(bmp->h * 0.5 + (y - yc) * VMU_H) + VMU_H;
					junc->v3d[2].x = junc->v3d[1].x + VMU_W;
					junc->v3d[2].y = junc->v3d[1].y;
				} else {
					junc->v3d[1].x = xs;         junc->v3d[1].y = ys + VML_H;
					junc->v3d[2].x = xs + VML_W; junc->v3d[2].y = ys + VML_H;
					junc->v3d[0].x = floor(bmp->w * 0.5 + (x - xc) * VMU_W);
					junc->v3d[0].y = floor(bmp->h * 0.5 + (y - yc) * VMU_H);
					junc->v3d[3].x = junc->v3d[0].x + VMU_W;
					junc->v3d[3].y = junc->v3d[0].y;
				}

				junc->next = firstjunc;
				firstjunc = junc;

				c = VM_NOTHING;
			}

			switch (c) {
				case VM_NOTHING:
					blit(dat[GFX_VML_NOTHING].dat, bmp, 0, 0, xs, ys, VML_W, VML_H);
					break;
				case VM_GRASS:
					blit(dat[GFX_VML_GRASS].dat, bmp, 0, 0, xs, ys, VML_W, VML_H);
					break;
				case VM_CLUB:
					blit(dat[GFX_VML_CLUB].dat, bmp, 0, 0, xs, ys, VML_W, VML_H);
					break;
				default:
					blit(dat[GFX_VML_VENT].dat, bmp, 0, 0, xs, ys, VML_W, VML_H);
			}
		}
	}

	while (firstjunc)
	{
		DVM_JUNCTION *next;

		quad3d_f(bmp, POLYTYPE_ATEX, dat[GFX_VMJ_VENT].dat,
			&firstjunc->v3d[0],
			&firstjunc->v3d[1],
			&firstjunc->v3d[2],
			&firstjunc->v3d[3]
		);

		next = firstjunc->next;
		free(firstjunc);
		firstjunc = next;
	}

	if (!player_on_top)
		draw_player(bmp);

	xs_start = floor(bmp->w * 0.5 - xc * VMU_W);
	ys = floor(bmp->h * 0.5 - yc * VMU_H);

	x_start = -((xs_start + VMU_W - 1) / VMU_W);
	y = -((ys + VMU_H - 1) / VMU_H);

	xs_start += x_start * VMU_W;
	ys += y * VMU_H;

	for (; ys < bmp->h; y++, ys += VMU_H) {
		for (xs = xs_start, x = x_start; xs < bmp->w; x++, xs += VMU_W) {
			if (x >= 0 && x < map->w && y >= 0 && y < map->h) {
				unsigned char c = map->layer[1][y][x];
				if (c >= VM_HOTSPOT)
					blit(dat[GFX_VMU_GRILLE].dat, bmp, 0, 0, xs, ys, VMU_W, VMU_H);
				else if (c == VM_VENT || c == VM_ENDING)
					blit(dat[GFX_VMU_VENT].dat, bmp, 0, 0, xs, ys, VMU_W, VMU_H);
			}
		}
	}

	if (player_on_top)
		draw_player(bmp);

	*plx = bmp->w >> 1;
	*ply = bmp->h >> 1;
}
