/* Ripped from Set Up Us The Bomb !!!, but written by me in the first place. */

#include <allegro.h>

#include "timeloop.h"
#include "icontrol.h"


static int in_progress = 0;
static int timeloop_speed;


int game_time;

volatile int true_game_time;
int max_game_time;


void timeloop_handler(void) {

 if (true_game_time < max_game_time)
	 true_game_time++;

} END_OF_FUNCTION(timeloop_handler);



/* This function is re-entrant (from the update function). Subtimeloops will
   use the same speed as their parents, though you may specify different
   values for everything else. true_game_time, and hence game_time, will
   continue to count evenly across the two loops.
*/
void timeloop(int speed,
              int max_skip,
              void *data,
              int (*update)(void *data),
              void (*draw)(void *data)) {

    if (in_progress++ == 0) {

        true_game_time = game_time = 0;
        max_game_time = max_skip;

        timeloop_speed = speed;

        install_int_ex(timeloop_handler, speed);

		start_control();
    }

	for (;;) {

	    (*draw)(data);

		while (game_time >= true_game_time)
			yield_timeslice();

		while (game_time < true_game_time) {
			game_time++;

			poll_ckeys();

			if ((*update)(data)) {

                if (--in_progress == 0) {
					end_control();
			    	remove_int(timeloop_handler);
				}

				return;
			}
		}

		max_game_time = game_time + max_skip;
	}
}



typedef struct TIMELOOP {

 struct TIMELOOP *next;

 int in_progress;
 int speed;

} TIMELOOP;


static TIMELOOP *parent = 0;



/* Call from inside the update function if you want to stop this timeloop.
   Its parameters will be saved for restart_timeloop(), but game_time will
   restart when you return. Meanwhile you may initiate a new timeloop with
   fresh game_time counters.
*/
void stop_timeloop(void) {

 TIMELOOP *newparent;

 end_control();
 remove_int(timeloop_handler);

 newparent = malloc(sizeof(TIMELOOP));

 newparent->in_progress = in_progress;
 newparent->speed = timeloop_speed;

 newparent->next = parent;
 parent = newparent;

 in_progress = 0;
}



void restart_timeloop(void) {

 TIMELOOP *old = parent;

 ASSERT(old);

 in_progress = old->in_progress;
 timeloop_speed = old->speed;

 parent = old->next;
 free(old);

 true_game_time = game_time = 0;
 max_game_time = 1;

 install_int_ex(timeloop_handler, timeloop_speed);

 start_control();
}



void initialise_timeloop(void) {
 LOCK_FUNCTION(timeloop_handler);
 LOCK_VARIABLE(true_game_time);
 LOCK_VARIABLE(max_game_time);

 initialise_control();
}
