#include <allegro.h>

#include "maps.h"
#include "themaps.h"
#include "multiray.h"
#include "strobe.h"



float multiray_params[4][2] = {
	{0.7071067812, 0.7071067812},
	{-0.7071067812, 0.7071067812},
	{0.8, 0.6},
	{-0.8, 0.6}
};


LIGHT map0_lights[3] = {
	{
		/* x, y */ 0, 0,
		/* create */ &create_strobe,
		/* destroy */ &destroy_strobe,
		/* update */ &update_strobe,
		/* draw */ &draw_strobe,
		/* params */ NULL
	},
	{
		/* x, y */ 1, 1,
		/* create */ &create_multiray,
		/* destroy */ &destroy_multiray,
		/* update */ &update_multiray,
		/* draw */ &draw_multiray,
		/* params */ multiray_params[0]
	},
	{
		/* x, y */ 15, 1,
		/* create */ &create_multiray,
		/* destroy */ &destroy_multiray,
		/* update */ &update_multiray,
		/* draw */ &draw_multiray,
		/* params */ multiray_params[1]
	}
};


LIGHT map1_lights[3] = {
	{
		/* x, y */ 0, 0,
		/* create */ &create_strobe,
		/* destroy */ &destroy_strobe,
		/* update */ &update_strobe,
		/* draw */ &draw_strobe,
		/* params */ NULL
	},
	{
		/* x, y */ 2, 1,
		/* create */ &create_multiray,
		/* destroy */ &destroy_multiray,
		/* update */ &update_multiray,
		/* draw */ &draw_multiray,
		/* params */ multiray_params[0]
	},
	{
		/* x, y */ 14, 1,
		/* create */ &create_multiray,
		/* destroy */ &destroy_multiray,
		/* update */ &update_multiray,
		/* draw */ &draw_multiray,
		/* params */ multiray_params[1]
	}
};


LIGHT map2_lights[5] = {
	{
		/* x, y */ 0, 0,
		/* create */ &create_strobe,
		/* destroy */ &destroy_strobe,
		/* update */ &update_strobe,
		/* draw */ &draw_strobe,
		/* params */ NULL
	},
	{
		/* x, y */ 2, 1,
		/* create */ &create_multiray,
		/* destroy */ &destroy_multiray,
		/* update */ &update_multiray,
		/* draw */ &draw_multiray,
		/* params */ multiray_params[2]
	},
	{
		/* x, y */ 14, 1,
		/* create */ &create_multiray,
		/* destroy */ &destroy_multiray,
		/* update */ &update_multiray,
		/* draw */ &draw_multiray,
		/* params */ multiray_params[3]
	},
	{
		/* x, y */ 2, 5,
		/* create */ &create_multiray,
		/* destroy */ &destroy_multiray,
		/* update */ &update_multiray,
		/* draw */ &draw_multiray,
		/* params */ multiray_params[2]
	},
	{
		/* x, y */ 14, 5,
		/* create */ &create_multiray,
		/* destroy */ &destroy_multiray,
		/* update */ &update_multiray,
		/* draw */ &draw_multiray,
		/* params */ multiray_params[3]
	}
};



#include "clubbeg.inc"

static PRE_CLUB_MAP club_map0[2] = {
	{
		{
			{W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W},
			{W,_,_,_,_,_,_,_,b,_,_,_,_,_,_,W},
			{W,_,_,_,_,_,_,_,_,_,_,_,_,_,_,W},
			{W,_,_,_,_,B,_,_,_,_,_,B,_,_,_,W},
			{W,_,_,_,_,B,_,_,_,_,_,B,_,_,_,W},
			{a,_,_,_,_,_,_,_,_,_,_,_,_,_,_,c},
			{W,_,S,_,_,_,_,_,_,_,_,_,_,_,_,W},
			{W,_,S,_,S,_,_,_,_,_,_,_,_,_,_,W},
			{W,_,S,_,S,_,_,_,_,_,_,_,_,_,_,W},
			{F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F}
		},
		/* vent_x    */ { 0, 8,15},
		/* vent_y    */ { 5, 1, 5},
		/* vent_type */ {VL,VH,VR},
		/* lights */ 3, map0_lights,
		/* n_squirrels */ 10,
		/* dog_time */ 3000
	},
	{
		{
			{W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W},
			{W,W,_,_,_,_,_,b,_,_,_,_,_,_,W,W},
			{W,W,_,_,_,_,_,_,_,_,_,_,_,_,W,W},
			{W,W,_,_,_,_,_,_,_,_,_,_,_,_,W,W},
			{W,W,_,_,_,_,_,_,_,_,_,_,_,_,W,W},
			{W,a,_,_,_,_,_,_,_,_,_,_,_,_,c,W},
			{W,W,_,_,_,_,_,_,_,_,_,_,S,_,W,W},
			{W,W,_,_,_,_,_,_,_,_,S,_,S,_,W,W},
			{W,W,_,_,_,_,_,_,_,_,S,_,S,_,W,W},
			{F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F}
		},
		/* vent_x    */ { 1, 7,14},
		/* vent_y    */ { 5, 1, 5},
		/* vent_type */ {VL,VH,VR},
		/* lights */ 3, map1_lights,
		/* n_squirrels */ 20,
		/* dog_time */ 3000
	}
};

#include "clubend.inc"



#include "ventbeg.inc"

static unsigned char vent_map0[2][11][23] = {
	{
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
		{0,0,0,C,C,C,C,C,C,C,0,0,0,0,0,0,X,V,0,0,0,0,0},
		{0,X,0,C,C,C,C,C,C,C,0,0,0,0,0,0,0,f,0,0,0,0,0},
		{0,V,0,C,C,C,C,C,C,C,0,X,0,C,C,C,C,C,C,C,C,C,0},
		{0,V,0,C,C,C,C,C,C,C,0,V,0,C,C,C,C,C,C,C,C,C,0},
		{0,V,a,C,C,C,C,C,C,C,c,V,0,C,C,C,C,C,C,C,C,C,0},
		{0,V,0,C,C,C,C,C,C,C,0,V,0,C,C,C,C,C,C,C,C,C,0},
		{0,V,0,C,C,C,C,C,C,C,0,X,0,C,C,C,C,C,C,C,C,C,0},
		{0,X,0,C,C,C,C,C,C,C,0,0,0,0,0,0,0,d,0,0,0,0,0},
		{0,0,0,C,C,C,C,C,C,C,0,0,0,0,0,0,X,V,0,0,0,0,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
	},
	{
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,G,G,G,G},
		{0,V,V,V,V,V,V,0,0,0,0,0,0,0,0,V,X,0,0,G,G,G,G},
		{0,X,0,0,0,0,V,0,V,V,V,V,0,0,0,V,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,V,0,V,0,0,X,0,0,0,V,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,V,0,V,0,0,0,0,0,0,V,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,b,0,V,V,V,V,V,V,0,V,V,e,V,V,V,V,E},
		{0,0,0,0,0,0,V,0,V,0,0,0,0,V,0,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,V,0,V,0,0,X,0,V,0,0,0,0,0,0,0,0,0},
		{0,X,0,0,0,0,V,0,V,V,V,V,0,V,0,0,0,0,0,0,0,0,0},
		{0,V,V,V,V,V,V,0,0,0,0,0,0,V,V,V,X,0,0,G,G,G,G},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,G,G,G,G}
	}
};

#include "ventend.inc"



#include "clubbeg.inc"

static PRE_CLUB_MAP club_map1[3] = {
	{
		{
			{W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W},
			{W,_,b,_,_,c,_,_,_,_,d,_,_,e,_,W},
			{W,_,_,_,_,_,_,_,_,_,_,_,_,_,_,W},
			{W,_,_,_,_,_,_,_,_,_,_,_,_,_,_,W},
			{W,_,_,_,_,_,_,_,_,_,_,_,_,_,_,W},
			{a,_,_,_,_,_,_,_,_,_,_,_,_,_,_,f},
			{W,_,_,S,_,_,_,_,_,_,_,_,S,_,_,W},
			{W,_,_,S,_,_,_,_,_,_,_,S,S,_,_,W},
			{W,_,_,S,_,_,_,_,_,_,_,S,S,_,_,W},
			{F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F}
		},
		/* vent_x    */ { 0, 2, 5,10,13,15},
		/* vent_y    */ { 5, 1, 1, 1, 1, 5},
		/* vent_type */ {VL,VH,VH,VH,VH,VR},
		/* lights */ 3, map0_lights,
		/* n_squirrels */ 10,
		/* dog_time */ 2500
	},
	{
		{
			{W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W},
			{W,_,_,b,_,_,_,_,_,_,_,_,_,_,_,W},
			{W,_,_,_,_,_,_,_,_,_,_,_,_,_,_,W},
			{W,_,_,B,_,_,B,_,_,B,_,_,B,_,_,W},
			{W,_,_,B,_,_,B,_,_,B,_,_,B,_,_,W},
			{a,_,_,_,_,_,_,_,_,_,_,_,_,_,_,c},
			{W,_,_,_,_,_,_,S,S,_,_,_,_,_,_,W},
			{W,_,_,_,_,S,_,S,S,_,S,_,_,_,_,W},
			{W,_,_,_,_,S,_,S,S,_,S,_,_,_,_,W},
			{F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F}
		},
		/* vent_x    */ { 0, 3,15},
		/* vent_y    */ { 5, 1, 5},
		/* vent_type */ {VL,VH,VR},
		/* lights */ 3, map0_lights,
		/* n_squirrels */ 15,
		/* dog_time */ 2500
	},
	{
		{
			{W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W},
			{W,W,_,_,_,_,_,_,_,_,_,_,_,_,W,W},
			{W,W,_,_,_,_,_,_,_,_,_,_,_,_,W,W},
			{W,W,_,_,_,_,_,_,_,_,_,_,_,_,W,W},
			{W,W,_,_,_,_,_,_,_,_,_,_,_,_,W,W},
			{W,a,_,_,_,_,_,_,_,_,_,_,_,_,b,W},
			{W,W,_,_,S,_,_,_,_,_,_,_,_,_,W,W},
			{W,W,_,_,S,_,S,_,_,_,_,_,_,_,W,W},
			{W,W,_,_,S,_,S,_,_,_,_,_,_,_,W,W},
			{F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F}
		},
		/* vent_x    */ { 1,14},
		/* vent_y    */ { 5, 5},
		/* vent_type */ {VL,VR},
		/* lights */ 3, map1_lights,
		/* n_squirrels */ 20,
		/* dog_time */ 2500
	}
};

#include "clubend.inc"



#include "ventbeg.inc"

static unsigned char vent_map1[2][21][25] = {
	{
		{G,G,G,G,G,G,G,G,G,G,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
		{G,G,G,G,G,G,G,G,G,G,0,0,0,C,C,C,C,C,C,C,C,C,0,0,0},
		{G,G,G,G,G,G,G,G,G,G,0,X,0,C,C,C,C,C,C,C,C,C,0,0,0},
		{G,G,G,G,G,G,G,G,G,G,0,V,g,C,C,C,C,C,C,C,C,C,i,V,0},
		{G,G,G,G,G,G,G,G,G,G,0,X,0,C,C,C,C,C,C,C,C,C,0,X,0},
		{G,G,G,G,G,G,G,G,G,G,0,0,0,C,C,C,C,C,C,C,C,C,0,0,0},
		{0,V,0,V,0,V,0,V,0,V,0,0,0,C,C,C,C,C,C,C,C,C,0,0,0},
		{0,V,V,V,V,V,V,V,V,V,X,0,0,C,C,C,C,C,C,C,C,C,0,0,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
		{0,X,0,C,C,C,C,C,C,C,C,C,C,0,X,0,C,C,C,C,C,C,0,0,0},
		{0,V,0,C,C,C,C,C,C,C,C,C,C,0,V,0,C,C,C,C,C,C,0,0,0},
		{0,V,0,C,C,C,C,C,C,C,C,C,C,0,V,0,C,C,C,C,C,C,0,0,0},
		{0,V,0,C,C,C,C,C,C,C,C,C,C,0,V,0,C,C,C,C,C,C,k,V,0},
		{0,V,a,C,C,C,C,C,C,C,C,C,C,f,V,0,C,C,C,C,C,C,0,V,0},
		{0,0,0,C,C,C,C,C,C,C,C,C,C,0,0,0,C,C,C,C,C,C,0,V,0},
		{0,0,0,C,C,C,C,C,C,C,C,C,C,0,X,0,C,C,C,C,C,C,0,V,0},
		{0,0,0,C,C,C,C,C,C,C,C,C,C,0,V,j,C,C,C,C,C,C,0,X,0},
		{0,0,0,C,C,C,C,C,C,C,C,C,C,0,0,0,C,C,C,C,C,C,0,0,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,C,C,C,C,C,C,0,0,0},
		{0,V,V,V,V,V,V,V,V,V,V,V,V,V,X,0,C,C,C,C,C,C,0,0,0},
		{0,E,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
	},
	{
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,0,0,0,0,V,V,V,V,0,0,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,0,0,0,0,X,0,0,V,0,0,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,h,0,0,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,0,0,0,0,X,0,0,V,0,0,0,0,0,0,0,0,X,0},
		{0,0,0,0,0,0,0,0,0,0,0,V,V,V,V,0,V,V,V,V,V,V,V,V,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,V,0,V,0,0,0,0,0,0,0,0},
		{0,V,V,V,V,0,0,0,0,0,X,V,0,0,V,0,V,0,0,0,0,0,0,0,0},
		{0,V,0,0,V,0,0,0,0,0,0,V,0,0,V,0,V,0,0,0,0,0,0,0,0},
		{0,X,0,0,V,0,V,V,V,V,0,V,0,0,X,0,V,0,0,0,0,0,0,0,0},
		{0,0,0,0,V,0,V,0,0,V,0,V,0,0,0,0,V,0,0,0,0,0,0,0,0},
		{0,0,0,0,V,0,V,0,0,V,0,V,0,0,V,V,V,0,0,0,0,0,0,0,0},
		{0,0,0,0,V,0,V,0,0,V,0,V,0,0,V,0,0,0,0,0,0,0,0,0,0},
		{0,0,0,0,b,0,c,0,0,d,0,e,0,0,V,0,0,0,0,0,0,0,0,0,0},
		{0,0,0,0,V,0,V,0,0,V,0,V,0,0,V,0,0,0,0,0,0,0,0,0,0},
		{0,0,0,0,V,0,V,0,0,V,0,V,0,0,X,0,0,0,0,0,0,0,0,0,0},
		{0,0,0,0,V,0,V,0,0,V,0,V,0,0,0,0,0,0,0,0,0,0,0,X,0},
		{0,0,0,0,V,0,V,0,0,V,0,V,0,0,0,0,0,0,0,0,0,0,0,V,0},
		{0,0,0,0,V,0,V,0,0,V,0,V,0,0,0,0,0,0,0,0,0,0,0,V,0},
		{0,0,0,0,V,V,V,0,0,V,V,V,0,0,X,V,V,V,V,V,V,V,V,V,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
	}
};

#include "ventend.inc"



#include "clubbeg.inc"

static PRE_CLUB_MAP club_map2[2] = {
	{
		{
			{W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W},
			{W,_,_,_,_,_,_,_,_,_,_,_,_,_,_,W},
			{a,_,_,_,_,_,_,_,_,_,_,_,_,_,_,b},
			{W,_,_,_,_,_,W,W,_,_,_,_,_,_,_,W},
			{W,W,W,W,W,W,W,_,_,W,W,W,W,W,W,W},
			{W,_,_,_,_,_,_,_,W,W,_,_,_,_,_,W},
			{c,_,_,_,_,_,_,_,_,_,_,_,_,_,_,d},
			{W,_,_,S,_,_,_,_,_,_,_,_,S,_,_,W},
			{W,_,_,S,_,_,_,_,_,_,_,S,S,_,_,W},
			{F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F}
		},
		/* vent_x    */ { 0,15, 0,15},
		/* vent_y    */ { 2, 2, 6, 6},
		/* vent_type */ {VL,VR,VL,VR},
		/* lights */ 5, map2_lights,
		/* n_squirrels */ 20,
		/* dog_time */ 6000
	},
	{
		{
			{W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W},
			{W,_,_,_,_,_,_,b,_,_,_,_,_,_,_,W},
			{W,_,_,_,_,_,_,_,_,_,_,_,_,_,_,W},
			{W,_,_,B,_,_,B,_,_,B,_,_,B,_,_,W},
			{W,_,_,B,_,_,B,_,_,B,_,_,B,_,_,W},
			{a,_,_,_,_,_,_,_,_,_,_,_,_,_,_,c},
			{W,_,_,_,_,_,_,S,S,_,_,_,_,_,_,W},
			{W,_,_,_,_,_,S,S,S,_,S,_,_,_,_,W},
			{W,_,_,_,_,_,S,S,S,_,S,_,S,_,_,W},
			{F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F}
		},
		/* vent_x    */ { 0, 7,15},
		/* vent_y    */ { 5, 1, 5},
		/* vent_type */ {VL,VH,VR},
		/* lights */ 3, map0_lights,
		/* n_squirrels */ 20,
		/* dog_time */ 1500
	}
};

#include "clubend.inc"



#include "ventbeg.inc"

static unsigned char vent_map2[2][11][29] = {
	{
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,V,0},
		{0,0,0,C,C,C,C,C,C,C,C,C,C,C,0,0,0,C,C,C,C,C,C,C,0,X,V,V,0},
		{0,0,0,C,C,C,C,C,C,C,C,C,C,C,0,0,0,C,C,C,C,C,C,C,0,0,0,0,0},
		{0,0,0,C,C,C,C,C,C,C,C,C,C,C,0,0,0,C,C,C,C,C,C,C,0,X,V,V,0},
		{0,0,0,C,C,C,C,C,C,C,C,C,C,C,0,0,0,C,C,C,C,C,C,C,0,0,0,V,0},
		{0,V,e,C,C,C,C,C,C,C,C,C,C,C,g,V,a,C,C,C,C,C,C,C,b,X,0,V,0},
		{0,X,0,C,C,C,C,C,C,C,C,C,C,C,0,0,0,C,C,C,C,C,C,C,0,0,0,V,0},
		{0,0,0,C,C,C,C,C,C,C,C,C,C,C,0,X,c,C,C,C,C,C,C,C,d,V,V,V,0},
		{0,0,0,C,C,C,C,C,C,C,C,C,C,C,0,0,0,C,C,C,C,C,C,C,0,0,0,0,0},
		{0,0,0,C,C,C,C,C,C,C,C,C,C,C,0,0,0,C,C,C,C,C,C,C,0,0,0,0,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	},
	{
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,V,V,X,0,0,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,V,0,0,0,0,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,V,V,X,0,0,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,X,V,V,0},
		{0,X,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,V,0},
		{0,V,V,V,V,V,V,V,f,V,V,V,V,V,V,X,0,0,0,0,0,0,0,0,0,0,0,V,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,V,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,V,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,E,0}
	}
};

#include "ventend.inc"



MAP the_map[N_MAPS] = {
	{
		/* vmw, vmh, vent_map */ 23, 11, &vent_map0[0][0][0],

		/* hotspot_club */ {0, 0, 0, 1, 1, 1},
		/* hotspot_vent */ {0, 1, 2, 0, 1, 2},
		/* hotspot_dir  */ {1, 3, 0, 2, 1, 3},

		/* n_club_maps, club_map */ 2, club_map0,

		/* club */ -1,

		/* pl_layer, plx, ply, pl_dir */ 0, 1, 5, 1,

		/* n_balls */ 500
	},
	{
		/* vmw, vmh, vent_map */ 25, 21, &vent_map1[0][0][0],

		/* hotspot_club */ {0, 0, 0, 0, 0, 0, 1, 1, 1, 2, 2},
		/* hotspot_vent */ {0, 1, 2, 3, 4, 5, 0, 1, 2, 0, 1},
		/* hotspot_dir  */ {1, 3, 3, 3, 3, 0, 1, 3, 0, 1, 0},

		/* n_club_maps, club_map */ 3, club_map1,

		/* club */ -1,

		/* pl_layer, plx, ply, pl_dir */ 0, 1, 6, 3,

		/* n_balls */ 200
	},
	{
		/* vmw, vmh, vent_map */ 29, 11, &vent_map2[0][0][0],

		/* hotspot_club */ {0, 0, 0, 0, 1, 1, 1},
		/* hotspot_vent */ {0, 1, 2, 3, 0, 1, 2},
		/* hotspot_dir  */ {1, 0, 1, 0, 1, 3, 0},

		/* n_club_maps, club_map */ 2, club_map2,

		/* club */ -1,

		/* pl_layer, plx, ply, pl_dir */ 0, 27, 0, 3,

		/* n_balls */ 100
	}
};