#ifndef INCLUDED_STROBE_H
#define INCLUDED_STROBE_H


#include "clubmap.h"
#include "light.h"


#define STROBE_PERIOD  20
#define STROBE_ON_TIME 10

typedef struct STROBE
{
	/* Used to control the flashing. */
	int time;

	/* Used to turn the light on and off over longer periods of time. */
	int on;
	int count;
}
STROBE;


void *create_strobe(LIGHT *light, void *params);
void destroy_strobe(void *data);
void update_strobe(LIGHT *light, void *data);
void draw_strobe(CLUB_MAP *map, LIGHT *light, void *data, RGB (*grid)[81]);


#endif /* INCLUDED_STROBE_H */
