#include <stdlib.h>
#include <allegro.h>

#include "clubmap.h"
#include "strobe.h"
#include "options.h"



void *create_strobe(LIGHT *light, void *params)
{
	STROBE *strobe = malloc(sizeof(*strobe));

	(void)params;

	if (!strobe)
		return NULL;

	strobe->on = rand() & 1;

	if (strobe->on) {
		strobe->time = rand() % STROBE_PERIOD;
		strobe->count = rand() % (1000 + (rand() & 1023));
	} else
		strobe->count = rand() % (2000 + (rand() & 1023));

	return strobe;
}



void destroy_strobe(void *data)
{
	free(data);
}



void update_strobe(LIGHT *light, void *data)
{

#define data ((STROBE *)data)

	if (data->on) {
		data->time += strobe_mode;
		data->time %= STROBE_PERIOD;
	}

	if (data->count <= 0) {
		data->on ^= 1;
		if (data->on) {
			data->time = 0;
			data->count = 1000 + (rand() & 1023);
		} else
			data->count = 2000 + (rand() & 1023);
	}

	data->count--;

#undef data

}



void draw_strobe(CLUB_MAP *map, LIGHT *light, void *data, RGB (*grid)[81])
{

#define data ((STROBE *)data)

	int x, y;

	(void)map;
	(void)light;

	if (strobe_mode && data->on && data->time < STROBE_ON_TIME) {
		for (y = 0; y < 51; y++) {
			for (x = 0; x < 81; x++) {
				grid[y][x].r = 31;
				grid[y][x].g = 31;
				grid[y][x].b = 31;
			}
		}
	}

#undef data

}