#ifndef INCLUDED_SQUIRREL_H
#define INCLUDED_SQUIRREL_H


#define MAX_SQUIRRELS 50


#define SQUIRREL_RADIUS 0.3

#define SQUIRREL_DEATH_SPEED 0.16


#define SM_OFF       0
#define SM_SUSPENDED 1
#define SM_ALIVE     2
#define SM_DEAD      3

#define SD_RIGHT   1
#define SD_FALLING 2

typedef struct SQUIRREL
{
	int mode;

	fixed x, y;
	fixed xv, yv;
	int dir;
	int count;
	int frame;

	/* When dir is 0, the squirrel moves left.
	 * When dir is 1, the squirrel moves right.
	 * xv controls the velocity along the perimeter of the level.
	 * count is decremented to determine when dir must next change.
	 * If dir is 2 or 3, then the squirrel falls and xv and yv become
	 * velocity the x and y axes respectively.
	 */
}
SQUIRREL;


#endif /* INCLUDED_SQUIRREL_H */
