#include <allegro.h>

#include "main.h"
#include "timeloop.h"
#include "icontrol.h"
#include "game.h"
#include "maps.h"
#include "playgame.h"
#include "menuback.h"
#include "leet.h"
#include "iris.h"
#include "cutscene.h"
#include "csending.h"



void update_sound(void)
{
	if (game.mode == GM_ALIVE && game.club >= 0 && game.club_map[game.club]->dog_time == 0) {
		if (game.growl_v < 0) {
			game.growl_v = allocate_voice(dat[SFX_GROWL].dat);
			if (game.growl_v >= 0) {
				voice_set_volume(game.growl_v, 64);
				voice_set_playmode(game.growl_v, PLAYMODE_LOOP);
				voice_start(game.growl_v);
			}
		}
	} else {
		if (game.growl_v >= 0) {
			deallocate_voice(game.growl_v);
			game.growl_v = -1;
		}
	}

	/*
	if (game.club >= 0)
		set_music_volume(music, 255);
	else
		set_music_volume(music, 32);
	*/
}



int update_game(void *data)
{
	int n;

	(void)data;

	while (keypressed()) {
		int k = readkey();

		cheat_character(k & 255);

		if (k >> 8 == KEY_ESC)
			game.paused = !game.paused;
		else if (game.paused) {
			if (k >> 8 == KEY_UP || k >> 8 == KEY_DOWN) {
				game.paused ^= 3; /* Alternate between 1 and 2. */
			} else if (k >> 8 == KEY_SPACE || k >> 8 == KEY_ENTER) {
				if (game.paused == 2)
					return 1;
				else
					game.paused = 0;
			}
		}
	}

	//poll_music(music);

	if (game.paused)
		return 0;

	if (game.mode != GM_ALIVE) {
		if (game.delay)
			game.delay--;
		else {
			if (game.iris <= 0) {
				if (game.mode == GM_DEAD) {
					if (game.lives <= 0) {
						end_map();
						run_cutscene(cs_dead);
						return 1;
					}
					game.lives--;
					resume_map();
				} else if (advance_game())
					return 1;
			} else {
				game.iris--;
				if (game.iris > IRIS_DELAY_TIME)
					game.iris--;
				if (game.iris == 0)
					game.delay = RESUME_DELAY;
				else if (game.iris == IRIS_DELAY_TIME)
					game.delay = IRIS_DELAY;
			}
		}
	}

	if (game.mode == GM_ALIVE) {
		if (game.delay)
			game.delay--;
		else if (game.iris < IRIS_START) {
			game.iris++;
			if (game.iris > IRIS_DELAY_TIME)
				game.iris++;
			else if (game.iris == IRIS_DELAY_TIME)
				game.delay = IRIS_DELAY;
		}
	}

	if (game.club >= 0)
		update_club_player(game.club_map[game.club]);
	else
		update_vent_player();

	for (n = 0; n < MAX_CLUB_MAPS; n++) {
		CLUB_MAP *map = game.club_map[n];
		if (map)
			update_club_map(map, n == game.club);
	}

	update_sound();

	return 0;
}



void draw_game(void *data)
{
	float x, y;

	(void)data;

	if (game.club >= 0)
		draw_club_map(scrbuf, game.club_map[game.club], &x, &y);
	else
		draw_vent_map(scrbuf, &x, &y);

	if (game.mode == GM_ENDMAP)
		textout_centre(scrbuf, dat[THE_FONT].dat, get1337("YAY!"), scrbuf->w >> 1, (scrbuf->h - 8) >> 1, COL_WHITE);

	if (game.iris < IRIS_START)
		draw_iris(scrbuf, x, y, game.iris * (1.25 * 320.0 / IRIS_START), game.iris * (1.25 * 200.0 * 4.0 / 3.0 / IRIS_START));

	if (game.paused) {
		blit(dat[GFX_VMJ_VENT].dat, scrbuf, 0, 0, (scrbuf->w - 64) >> 1, (scrbuf->h - 64) >> 1, 64, 64);
		textout_centre(scrbuf, dat[THE_FONT].dat, get1337("PAUSED"), scrbuf->w >> 1, 70, COL_WHITE);
		textout_right(scrbuf, dat[THE_FONT].dat, get1337("Level: "), 172, 80, COL_CYAN);
		textout(scrbuf, dat[THE_FONT].dat, printf1337("%d", game.map + 1), 172, 80, COL_WHITE);
		textout_right(scrbuf, dat[THE_FONT].dat, get1337("Lives: "), 172, 90, COL_CYAN);
		textout(scrbuf, dat[THE_FONT].dat, printf1337("%d", game.lives), 172, 90, COL_WHITE);
		textout_right(scrbuf, dat[THE_FONT].dat, get1337("Score: "), 172, 100, COL_CYAN);
		textout(scrbuf, dat[THE_FONT].dat, printf1337("%d", game.score), 172, 100, COL_WHITE);
		textout_centre(scrbuf, dat[THE_FONT].dat, printf1337("Continue", game.score), scrbuf->w >> 1, 110, game.paused == 1 ? COL_WHITE : COL_DARKGREEN);
		textout_centre(scrbuf, dat[THE_FONT].dat, printf1337("Quit", game.score), scrbuf->w >> 1, 120, game.paused == 2 ? COL_WHITE : COL_DARKGREEN);
	}

	vsync();
	blit(scrbuf, screen, 0, 0, 0, 0, scrbuf->w, scrbuf->h);
}



int mkc_play_game(void)
{
	stop_timeloop();
	shut_down_menu_system();

	start_control();

	if (start_game()) {
		end_control();
		return 1;
	}

	timeloop(
		BPS_TO_TIMER(100),
		10,
		NULL,
		&update_game,
		&draw_game
	);

	end_game();

	end_control();

	initialise_menu_system();
	restart_timeloop();

	return 0;
}