#include <stdlib.h>
#include <math.h>
#include <allegro.h>

#include "main.h"
#include "clubmap.h"
#include "multiray.h"



void *create_multiray(LIGHT *light, void *params)
{
	MULTIRAY *multiray = malloc(sizeof(*multiray));

	if (!multiray)
		return NULL;

	multiray->xd = ((float *)params)[0];
	multiray->yd = ((float *)params)[1];
	multiray->angle = rand() * (2 * M_PI / RAND_MAX);
	multiray->ad = rand() % 3 - 1;
	multiray->c1 = rand() % 5;
	multiray->c2 = rand() % 5;
	multiray->c3 = rand() % 5;

	return multiray;
}



void destroy_multiray(void *data)
{
	free(data);
}



void update_multiray(LIGHT *light, void *data)
{

#define data ((MULTIRAY *)data)

	if (data->ad < 0) {
		data->angle -= M_PI / 64;
		while (data->angle < 0)
			data->angle += 2 * M_PI;
	} else if (data->ad) {
		data->angle += M_PI / 64;
		while (data->angle >= 2 * M_PI)
			data->angle -= 2 * M_PI;
	}

	if ((rand() & 63) == 0)
		data->ad = rand() % 3 - 1;

	if ((rand() & 63) == 0) data->c1 = rand() % 5;
	if ((rand() & 63) == 0) data->c2 = rand() % 5;
	if ((rand() & 63) == 0) data->c3 = rand() % 5;

#undef data

}



static void lightcast(CLUB_MAP *map, float xs, float ys, float dx, float dy, RGB (*grid)[81], float r, float g, float b)
{
	int x, y;
	float xf, yf;

	if (dx > dy && dx > -dy) {
		dy /= dx;
		x = xf = floor(xs);
		xf = xf + 1 - xs;
		y = yf = floor(ys);
		yf = ys - yf;
		grid[y+1][x].r += xf * yf * r;
		grid[y+1][x].g += xf * yf * g;
		grid[y+1][x].b += xf * yf * b;
		LIGHTCLIP(grid[y+1][x]);
		yf = 1 - yf;
		grid[y][x].r += xf * yf * r;
		grid[y][x].g += xf * yf * g;
		grid[y][x].b += xf * yf * b;
		LIGHTCLIP(grid[y][x]);
		ys += xf * dy;
		for (x++; x < 81; x++) {
			y = yf = floor(ys);
			if ((unsigned int)y >= 50) break;
			if (CM_LIGHT_BOTH_BLOCKED(map->tile[y/5][x/5], map->tile[y/5][(x-1)/5])) {
				xs = x;
				goto illuminate;
			}
			yf = ys - yf;
			grid[y+1][x].r += yf * r;
			grid[y+1][x].g += yf * g;
			grid[y+1][x].b += yf * b;
			LIGHTCLIP(grid[y+1][x]);
			yf = 1 - yf;
			grid[y][x].r += yf * r;
			grid[y][x].g += yf * g;
			grid[y][x].b += yf * b;
			LIGHTCLIP(grid[y][x]);
			ys += dy;
		}
	} else if (dx < dy && dx < -dy) {
		dy /= -dx;
		x = xf = floor(xs);
		xf = xs - xf;
		y = yf = floor(ys);
		yf = ys - yf;
		grid[y+1][x].r += xf * yf * r;
		grid[y+1][x].g += xf * yf * g;
		grid[y+1][x].b += xf * yf * b;
		LIGHTCLIP(grid[y+1][x]);
		yf = 1 - yf;
		grid[y][x].r += xf * yf * r;
		grid[y][x].g += xf * yf * g;
		grid[y][x].b += xf * yf * b;
		LIGHTCLIP(grid[y][x]);
		ys += xf * dy;
		xf = 0;
		for (x--; x >= 0; x--) {
			y = yf = floor(ys);
			if ((unsigned int)y >= 50) break;
			if (CM_LIGHT_BOTH_BLOCKED(map->tile[y/5][x/5], map->tile[y/5][(x-1)/5])) {
				xs = x;
				goto illuminate;
			}
			yf = ys - yf;
			grid[y+1][x].r += yf * r;
			grid[y+1][x].g += yf * g;
			grid[y+1][x].b += yf * b;
			LIGHTCLIP(grid[y+1][x]);
			yf = 1 - yf;
			grid[y][x].r += yf * r;
			grid[y][x].g += yf * g;
			grid[y][x].b += yf * b;
			LIGHTCLIP(grid[y][x]);
			ys += dy;
		}
	} else if (dy > 0) {
		dx /= dy;
		y = yf = floor(ys);
		yf = yf + 1 - ys;
		x = xf = floor(xs);
		xf = xs - xf;
		grid[y][x+1].r += yf * xf * r;
		grid[y][x+1].g += yf * xf * g;
		grid[y][x+1].b += yf * xf * b;
		LIGHTCLIP(grid[y][x+1]);
		xf = 1 - xf;
		grid[y][x].r += yf * xf * r;
		grid[y][x].g += yf * xf * g;
		grid[y][x].b += yf * xf * b;
		LIGHTCLIP(grid[y][x]);
		xs += yf * dx;
		yf = 0;
		for (y++; y < 51; y++) {
			x = xf = floor(xs);
			if ((unsigned int)x >= 80) break;
			if (CM_LIGHT_BOTH_BLOCKED(map->tile[y/5][x/5], map->tile[(y-1)/5][x/5])) {
				ys = y;
				goto illuminate;
			}
			xf = xs - xf;
			grid[y][x+1].r += xf * r;
			grid[y][x+1].g += xf * g;
			grid[y][x+1].b += xf * b;
			LIGHTCLIP(grid[y][x+1]);
			xf = 1 - xf;
			grid[y][x].r += xf * r;
			grid[y][x].g += xf * g;
			grid[y][x].b += xf * b;
			LIGHTCLIP(grid[y][x]);
			xs += dx;
		}
	} else {
		dx /= -dy;
		y = yf = floor(ys);
		yf = ys - yf;
		x = xf = floor(xs);
		xf = xs - xf;
		grid[y][x+1].r += yf * xf * r;
		grid[y][x+1].g += yf * xf * g;
		grid[y][x+1].b += yf * xf * b;
		LIGHTCLIP(grid[y][x+1]);
		xf = 1 - xf;
		grid[y][x].r += yf * xf * r;
		grid[y][x].g += yf * xf * g;
		grid[y][x].b += yf * xf * b;
		LIGHTCLIP(grid[y][x]);
		xs += yf * dx;
		yf = 0;
		for (y--; y >= 0; y--) {
			x = xf = floor(xs);
			if ((unsigned int)x >= 81) break;
			if (CM_LIGHT_BOTH_BLOCKED(map->tile[y/5][x/5], map->tile[(y-1)/5][x/5])) {
				ys = y;
				goto illuminate;
			}
			xf = xs - xf;
			grid[y][x+1].r += xf * r;
			grid[y][x+1].g += xf * g;
			grid[y][x+1].b += xf * b;
			LIGHTCLIP(grid[y][x+1]);
			xf = 1 - xf;
			grid[y][x].r += xf * r;
			grid[y][x].g += xf * g;
			grid[y][x].b += xf * b;
			LIGHTCLIP(grid[y][x]);
			xs += dx;
		}
	}

	return;

	illuminate: /* Illuminate surfaces around point (xs, ys). */

	{
		int x_start;
		int x_end;
		int y_end;

		x = ceil(xs);
		y = ceil(ys);
		x_end = x + 2;
		x_start = x - 2;
		y_end = y + 2;
		y = y - 2;

		if (x_start < 0) x_start = 0;
		if (x_end > 81) x_end = 81;
		if (y < 0) y = 0;
		if (y_end > 51) y_end = 51;

		for (yf = 0.5 * (y - ys); y < y_end; y++, yf += 0.5) {
			for (x = x_start, xf = 0.5 * (x - xs); x < x_end; x++, xf += 0.5) {
				float v = 1.0 - sqrt(xf * xf + yf * yf);
				if (v > 0) {
					grid[y][x].r += v * r;
					grid[y][x].g += v * g;
					grid[y][x].b += v * b;
					LIGHTCLIP(grid[y][x]);
				}
			}
		}
	}
}



void draw_multiray(CLUB_MAP *map, LIGHT *light, void *data, RGB (*grid)[81])
{

#define data ((MULTIRAY *)data)

	float c = cos(data->angle);
	float s = sin(data->angle);

	float c2 = 0.6 * c - 0.8 * s;
	float s2 = 0.6 * s + 0.8 * c;

	float xd = data->xd;
	float yd = data->yd;

	float xr = yd;
	float yr = -xd;

	static float colour[5][3] = {
		{24,  0,  0},
		{ 0, 24,  0},
		{24, 24,  0},
		{ 0,  0, 24},
		{24,  0, 24}
	};

	float *col1 = colour[data->c1];
	float *col2 = colour[data->c2];
	float *col3 = colour[data->c3];

	lightcast(map, light->x * 5, light->y * 5, 2.0*xd + s*xr, 2.0*yd + s*yr, grid, col1[0], col1[1], col1[2]);
	lightcast(map, light->x * 5, light->y * 5, 2.2*xd + c*xr, 2.2*yd + c*yr, grid, col1[0], col1[1], col1[2]);
	lightcast(map, light->x * 5, light->y * 5, 2.6*xd - s*xr, 2.6*yd - s*yr, grid, col1[0], col1[1], col1[2]);
	lightcast(map, light->x * 5, light->y * 5, 2.4*xd - c*xr, 2.4*yd - c*yr, grid, col1[0], col1[1], col1[2]);

	lightcast(map, light->x * 5, light->y * 5, 2.7*xd + s2*xr, 2.7*yd + s2*yr, grid, col2[0], col2[1], col2[2]);
	lightcast(map, light->x * 5, light->y * 5, 2.5*xd + c2*xr, 2.5*yd + c2*yr, grid, col2[0], col2[1], col2[2]);
	lightcast(map, light->x * 5, light->y * 5, 2.1*xd - s2*xr, 2.1*yd - s2*yr, grid, col2[0], col2[1], col2[2]);
	lightcast(map, light->x * 5, light->y * 5, 2.3*xd - c2*xr, 2.3*yd - c2*yr, grid, col2[0], col2[1], col2[2]);

	lightcast(map, light->x * 5, light->y * 5, 7.2*xd + s*xr, 7.2*yd + s*yr, grid, col3[0], col3[1], col3[2]);
	lightcast(map, light->x * 5, light->y * 5, 6.0*xd + c*xr, 6.0*yd + c*yr, grid, col3[0], col3[1], col3[2]);
	lightcast(map, light->x * 5, light->y * 5, 6.6*xd - s*xr, 6.6*yd - s*yr, grid, col3[0], col3[1], col3[2]);
	lightcast(map, light->x * 5, light->y * 5, 7.8*xd - c*xr, 7.8*yd - c*yr, grid, col3[0], col3[1], col3[2]);

#undef data

}