/* menuproc.h

   This module provides a set of standard 'draw' and 'key' procs you can use
   to construct the menus. Note: no 'key' procs are required for non-options.

   'draw' procs are prefixed md_.
   'key' procs are prefixed mk_.
   This convention is kept throughout the program.
*/

#ifndef INCLUDED_MENUPROC_H
#define INCLUDED_MENUPROC_H

/* md_marquee()  displays a scrolling marquee 
 *  dp is the text, k is used internally. Set it to 0 initially.
 */
void md_marquee(BITMAP *bmp, BOMB_MENU *entry, int selected);

/* Text output. dp points to the string.
   d is the colour when not selected - don't choose white for an option!
   When selected, the text appears white.
*/
void md_text(BITMAP *bmp, BOMB_MENU *entry, int selected);
void md_text_centre(BITMAP *bmp, BOMB_MENU *entry, int selected);
void md_text_right(BITMAP *bmp, BOMB_MENU *entry, int selected);

/* md_selection(): use as follows:

   For example: "Animal Abundance: None / Rare / Moderate / Profuse"

   "Animal Abundance:" is the actual option. Display it with md_text_right(),
   and activate it with mk_option() or your own custom function.
   It will go white when selected, although the word to the right won't
   change colour.

   Display the word to the right using md_selection(). It is a non-option.

   d is the colour.
   dp points to the option in question, which should be a 0-based int.
   dp2 points to an array of char pointers:

   char *array[] = {"None", "Rare", "Moderate", "Profuse"};
   dp2 = array;

   This function will use the int to choose which string to display.
*/
void md_selection(BITMAP *bmp, BOMB_MENU *entry, int selected);

void md_bitmap(BITMAP *bmp, BOMB_MENU *entry, int selected);
void md_sprite(BITMAP *bmp, BOMB_MENU *entry, int selected);

/* mk_option().
   kp points to the option in question (an int).
   k2 represents the number of values for this option.
   The left and right arrows will change the value, keeping it within the
   range 0 to k2-1.
*/
int mk_option(BOMB_MENU *entry, int k);

/* Command. kp points to a function, return type int, no parameters. When
   Space or Enter are pressed on this option, the function is called and the
   return value is relayed back to the menu system - so if the command
   function returns 1, the menu will exit. Command functions are prefixed
   with mkc_. This convention is kept throughout the program.
*/
int mk_command(BOMB_MENU *entry, int k);

/* Command function for exiting the menu. Simply returns 1. */
int mkc_exit(void);

#endif /* INCLUDED_MENUPROC_H */
