#include <stdlib.h>
#include <allegro.h>

#include "main.h"
#include "menuback.h"
#include "leet.h"



#define N_PHRASES 11

const char *the_phrase[N_PHRASES] = {
/* Ook */ "holy 'carp' on a stick!",
/* Trumgottist */ "\"One morning, I shot an elephant in my pajamas. How he got into my pajamas I don't know.\"",
/* sicgamemaker */ "The best ideas come from twisted minds, and I've got a lot of ideas.-me",
"\" \" - silence",
"\"people arn't getting smarter, they just find more creative ways to be stupid\" - Dr. Sellars",
/* X-Viila */ "ave atque vale!",
/* Mattias */ "*** Hi! I''m a signature virus. Copy me into your signature to help me spread! ***",
/* Johnny13 */ "\"Think Cyber\"",
/* Digital Dimensions */ "\"Television is the retina of the mind's eye.\"",
/* Peitz */ "\"Hardware is nothing, gameplay is everything.\"",
/* Unknown Programmer */ "My Motto is... \"Whatever you saw someone at the distance will always remain unknown. That is because your eyes are damaged.\""
};



#define LETTER_SEPARATION 10
#define UNIT_POINTS      300
#define MAX_POINTS      4800

#define CHAR_W 20
#define CHAR_H 10

typedef struct TEXTSPLINE
{
	struct TEXTSPLINE *next;

	const char *str;

	int p;

	int n_points;

	int x[MAX_POINTS + 1], y[MAX_POINTS + 1];
}
TEXTSPLINE;



TEXTSPLINE *firstspline;



void initialise_menu_system(void)
{
	firstspline = NULL;
}



void shut_down_menu_system(void)
{
	TEXTSPLINE *spline = firstspline;

	while (spline) {
		TEXTSPLINE *next = spline->next;
		free(spline);
		spline = next;
	}
}



void get_edge_point(int point[2])
{
	point[0] = rand() % (2 * (GFX_W + CHAR_W + GFX_H + CHAR_H));
	point[1] = -CHAR_H;

	if (point[0] >= 2 * (GFX_W + CHAR_W) + GFX_H + CHAR_H) {
		point[1] = point[0] - 2 * (GFX_W + CHAR_W) - GFX_H - CHAR_H;
		point[0] = -(CHAR_W >> 1);
	} else if (point[0] >= 2 * (GFX_W + CHAR_W)) {
		point[1] = GFX_H;
		point[0] -= CHAR_W >> 1;
	} else if (point[0] >= GFX_W + CHAR_W) {
		point[1] = point[0] - (GFX_W + CHAR_W);
		point[0] = GFX_W + (CHAR_W >> 1);
	} else
		point[0] -= CHAR_W >> 1;
}



void get_nearby_point(int src[2], int dest[2])
{
	int x_min = src[0] - 128;
	int x_max = src[0] + 128;
	int y_min = src[1] - 128;
	int y_max = src[1] + 128;

	if (x_min < 0) x_min = 0;
	if (x_min > GFX_W) x_min = GFX_W;
	if (x_max < 0) x_max = 0;
	if (x_max > GFX_W) x_max = GFX_W;
	if (y_min < 0) y_min = 0;
	if (y_min > GFX_H) y_min = GFX_H;
	if (y_max < 0) y_max = 0;
	if (y_max > GFX_H) y_max = GFX_H;

	dest[0] = x_min + rand() % (x_max + 1 - x_min);
	dest[1] = y_min + rand() % (y_max + 1 - y_min);
}



void update_menu_background(void)
{
	int r;

	TEXTSPLINE *spline;

	for (spline = firstspline; spline; spline = spline->next)
		spline->p++;

	r = rand() & 1023;

	if (r < N_PHRASES) {
		int point[8];
		int n = 0;

		spline = malloc(sizeof(*spline));

		if (!spline)
			return;

		spline->str = the_phrase[r];

		get_edge_point(&point[0]);
		get_nearby_point(&point[0], &point[2]);
		get_nearby_point(&point[2], &point[4]);
		get_nearby_point(&point[4], &point[6]);

		calc_spline(point, UNIT_POINTS + 1, &spline->x[n], &spline->y[n]);

		n += UNIT_POINTS;

		while (n < UNIT_POINTS - MAX_POINTS && (rand() & 3)) {
			point[0] = point[6];
			point[1] = point[7];
			point[2] = (point[6] << 1) - point[4];
			point[3] = (point[7] << 1) - point[5];

			get_nearby_point(&point[2], &point[4]);
			get_nearby_point(&point[4], &point[6]);

			calc_spline(point, UNIT_POINTS, &spline->x[n], &spline->y[n]);

			n += UNIT_POINTS;
		}

		point[0] = point[6];
		point[1] = point[7];
		point[2] = (point[6] << 1) - point[4];
		point[3] = (point[7] << 1) - point[5];

		get_nearby_point(&point[2], &point[4]);
		get_edge_point(&point[6]);

		calc_spline(point, UNIT_POINTS, &spline->x[n], &spline->y[n]);

		n += UNIT_POINTS;

		spline->p = 0;

		spline->n_points = n;

		spline->next = firstspline;
		firstspline = spline;
	}
}



void draw_menu_background(void)
{
	TEXTSPLINE **spline_p, *spline;
	int p;
	const char *str;
	char buf[2] = {0, 0};

	clear(scrbuf);

	spline_p = &firstspline;

	while (*spline_p) {
		spline = *spline_p;

		p = spline->p;

		str = spline->str;

		ASSERT(*str);

		while (p >= spline->n_points) {
			str++;
			if (!*str)
				goto exhausted;
			p -= LETTER_SEPARATION;
		}

		while (p >= 0 && *str) {
			buf[0] = *str++;
			textout_centre(scrbuf, dat[THE_FONT].dat, get1337(buf),
				spline->x[p], spline->y[p], COL_DARKGREEN);
			p -= LETTER_SEPARATION;
		}

		spline_p = &spline->next;
		continue;

		exhausted:

		*spline_p = spline->next;
		free(spline);
	}
}
